/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit4.legacy.internal.impl.testcaseworkaround;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.internal.runners.TestClassMethodsRunner;
import org.junit.internal.runners.TestMethodRunner;
import org.junit.runner.notification.RunNotifier;
import org.powermock.core.spi.PowerMockTestListener;
import org.powermock.modules.junit4.legacy.internal.impl.testcaseworkaround.PowerMockJUnit4LegacyTestMethodRunner;
import org.powermock.reflect.Whitebox;
import org.powermock.tests.utils.PowerMockTestNotifier;
import org.powermock.tests.utils.impl.PowerMockTestNotifierImpl;
import org.powermock.tests.utils.impl.StaticConstructorSuppressExtractorImpl;

public class PowerMockJUnit4LegacyTestClassMethodsRunner
extends TestClassMethodsRunner {
    private final PowerMockTestNotifier powerMockTestNotifier;

    public PowerMockJUnit4LegacyTestClassMethodsRunner(Class<?> klass, PowerMockTestListener[] powerMockTestListeners) {
        super(klass);
        this.powerMockTestNotifier = new PowerMockTestNotifierImpl(powerMockTestListeners);
        List testMethods = (List)Whitebox.getInternalState((Object)((Object)this), (String)"fTestMethods", TestClassMethodsRunner.class);
        testMethods.addAll(this.getAdditionalTestMethods(klass));
    }

    private List<Method> getAdditionalTestMethods(Class<?> klass) {
        LinkedList<Method> additionalMethods = new LinkedList<Method>();
        if (klass != null && klass.getSuperclass().equals(TestCase.class)) {
            Method[] methods;
            for (Method method : methods = klass.getMethods()) {
                if (!this.isAdditionalTestMethod(method)) continue;
                additionalMethods.add(method);
            }
        }
        return additionalMethods;
    }

    private boolean isAdditionalTestMethod(Method method) {
        return !method.isAnnotationPresent(Ignore.class) && method.getName().startsWith("test") && Modifier.isPublic(method.getModifiers()) && method.getReturnType().equals(Void.TYPE) && method.getAnnotation(Test.class) == null;
    }

    protected TestMethodRunner createMethodRunner(Object test, Method method, RunNotifier notifier) {
        return new PowerMockJUnit4LegacyTestMethodRunner(test, method, notifier, this.methodDescription(method), this.powerMockTestNotifier);
    }

    public void run(RunNotifier notifier) {
        List methods = (List)Whitebox.getInternalState((Object)((Object)this), (String)"fTestMethods");
        if (methods.isEmpty()) {
            notifier.testAborted(this.getDescription(), (Throwable)new Exception("No runnable methods"));
        }
        for (Method method : methods) {
            StaticConstructorSuppressExtractorImpl staticConstructorSuppressExtractorImpl = new StaticConstructorSuppressExtractorImpl();
            Class<?> testType = this.getTestClass();
            ClassLoader thisClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
            if (!thisClassLoader.equals(testType.getClassLoader())) {
                try {
                    testType = thisClassLoader.loadClass(testType.getName());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Internal error in PowerMock", e);
                }
            }
            if (staticConstructorSuppressExtractorImpl.getTestClasses((AnnotatedElement)method) == null) {
                staticConstructorSuppressExtractorImpl.getTestClasses(testType);
            }
            this.invokeTestMethod(method, notifier);
        }
    }
}

