/*
 * Decompiled with CFR 0.152.
 */
package play.api.cache;

import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.Done;
import org.apache.pekko.stream.Materializer;
import play.api.cache.AsyncCacheApi;
import play.api.cache.SerializableResult;
import play.api.http.HeaderNames$;
import play.api.http.package$;
import play.api.libs.Codecs$;
import play.api.libs.streams.Accumulator;
import play.api.libs.streams.Accumulator$;
import play.api.mvc.EssentialAction;
import play.api.mvc.EssentialAction$;
import play.api.mvc.RequestHeader;
import play.api.mvc.ResponseHeader;
import play.api.mvc.Result;
import play.api.mvc.Results$;
import play.core.Execution;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0005\u0005}a\u0001B\t\u0013\u0005eA\u0001b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tI\u0001\u0011\t\u0011)A\u0005K!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005I\u0001\t\u0005\t\u0015a\u0003J\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u001d9\u0007A1A\u0005\n!Da!\u001b\u0001!\u0002\u0013Q\u0004\"\u00026\u0001\t\u0013Y\u0007\"B=\u0001\t\u0003Q\bBB=\u0001\t\u0003\t\t\u0001\u0003\u0004z\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u001d\ti\u0001\u0001C\u0001\u0003'Aq!a\u0006\u0001\t\u0003\tIBA\u0007DC\u000eDW\r\u001a\"vS2$WM\u001d\u0006\u0003'Q\tQaY1dQ\u0016T!!\u0006\f\u0002\u0007\u0005\u0004\u0018NC\u0001\u0018\u0003\u0011\u0001H.Y=\u0004\u0001M\u0011\u0001A\u0007\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0005\u0012S\"\u0001\n\n\u0005\r\u0012\"!D!ts:\u001c7)Y2iK\u0006\u0003\u0018.A\u0002lKf\u0004Ba\u0007\u0014)]%\u0011q\u0005\b\u0002\n\rVt7\r^5p]F\u0002\"!\u000b\u0017\u000e\u0003)R!a\u000b\u000b\u0002\u0007548-\u0003\u0002.U\ti!+Z9vKN$\b*Z1eKJ\u0004\"a\f\u001c\u000f\u0005A\"\u0004CA\u0019\u001d\u001b\u0005\u0011$BA\u001a\u0019\u0003\u0019a$o\\8u}%\u0011Q\u0007H\u0001\u0007!J,G-\u001a4\n\u0005]B$AB*ue&twM\u0003\u000269\u000591-Y2iS:<\u0007\u0003B\u000e<{\u0001K!\u0001\u0010\u000f\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:\u0004\"!\u000b \n\u0005}R#A\u0004*fgB|gn]3IK\u0006$WM\u001d\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000b\u0001\u0002Z;sCRLwN\u001c\u0006\u0003\u000br\t!bY8oGV\u0014(/\u001a8u\u0013\t9%I\u0001\u0005EkJ\fG/[8o\u00031i\u0017\r^3sS\u0006d\u0017N_3s!\tQ5+D\u0001L\u0015\taU*\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u001d>\u000bQ\u0001]3lW>T!\u0001U)\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0016aA8sO&\u0011Ak\u0013\u0002\r\u001b\u0006$XM]5bY&TXM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\t]S6\f\u0018\u000b\u00031f\u0003\"!\t\u0001\t\u000b!+\u00019A%\t\u000bM)\u0001\u0019\u0001\u0011\t\u000b\u0011*\u0001\u0019A\u0013\t\u000be*\u0001\u0019\u0001\u001e\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005}\u0013\u0007CA\u0015a\u0013\t\t'FA\bFgN,g\u000e^5bY\u0006\u001bG/[8o\u0011\u0015\u0019g\u00011\u0001`\u0003\u0019\t7\r^5p]\u0006)!-^5mIR\u0011qL\u001a\u0005\u0006G\u001e\u0001\raX\u0001\u0014G\u0006\u001c\u0007.\u001b8h/&$\b.\u0012;fe:LG/_\u000b\u0002u\u0005!2-Y2iS:<w+\u001b;i\u000bR,'O\\5us\u0002\nA\u0002[1oI2,'+Z:vYR$B\u0001\\:voB\u0019QN\u001c9\u000e\u0003\u0011K!a\u001c#\u0003\r\u0019+H/\u001e:f!\tI\u0013/\u0003\u0002sU\t1!+Z:vYRDQ\u0001\u001e\u0006A\u0002A\faA]3tk2$\b\"\u0002<\u000b\u0001\u0004q\u0013aB3uC\u001e\\U-\u001f\u0005\u0006q*\u0001\rAL\u0001\ne\u0016\u001cX\u000f\u001c;LKf\fQ\"\u001b8dYV$Wm\u0015;biV\u001cHC\u0001-|\u0011\u0015a8\u00021\u0001~\u0003\u0019\u0019H/\u0019;vgB\u00111D`\u0005\u0003\u007fr\u00111!\u00138u)\u0015A\u00161AA\u0003\u0011\u0015aH\u00021\u0001~\u0011\u0015\u0019E\u00021\u0001~)\u0015A\u0016\u0011BA\u0006\u0011\u0015aX\u00021\u0001~\u0011\u0015\u0019U\u00021\u0001A\u0003\u001d!WMZ1vYR$2\u0001WA\t\u0011\u0015\u0019e\u00021\u0001A)\rA\u0016Q\u0003\u0005\u0006\u0007>\u0001\r!`\u0001\bG>l\u0007o\\:f)\rA\u00161\u0004\u0005\u0007\u0003;\u0001\u0002\u0019\u0001\u001e\u0002\u0017\u0005dG/\u001a:oCRLg/\u001a")
public final class CachedBuilder {
    private final AsyncCacheApi cache;
    private final Function1<RequestHeader, String> key;
    private final PartialFunction<ResponseHeader, Duration> caching;
    private final Materializer materializer;
    private final PartialFunction<ResponseHeader, Duration> cachingWithEternity;

    public EssentialAction apply(EssentialAction action) {
        return this.build(action);
    }

    public EssentialAction build(EssentialAction action) {
        return EssentialAction$.MODULE$.apply((Function1 & Serializable)request -> {
            String resultKey = (String)$this.key.apply(request);
            String etagKey = resultKey + "-etag";
            return Accumulator$.MODULE$.flatten(Future$.MODULE$.successful((Object)request.headers().get(HeaderNames$.MODULE$.IF_NONE_MATCH())).flatMap((Function1 & Serializable)x0$1 -> {
                Option option = x0$1;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String requestEtag = (String)some.value();
                    return $this.cache.get(etagKey, ClassTag$.MODULE$.apply(String.class)).map((Function1 & Serializable)x0$2 -> {
                        Option option = x0$2;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            String etag = (String)some.value();
                            String string = requestEtag;
                            String string2 = "*";
                            if (!(string == null ? string2 != null : !string.equals(string2)) || CachedBuilder.parseEtag$1(requestEtag).contains((Object)etag)) {
                                return new Some((Object)Accumulator$.MODULE$.done((Object)Results$.MODULE$.NotModified()));
                            }
                        }
                        return None$.MODULE$;
                    }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
                }
                if (None$.MODULE$.equals(option)) {
                    return Future$.MODULE$.successful((Object)None$.MODULE$);
                }
                throw new MatchError((Object)option);
            }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline()).flatMap((Function1 & Serializable)x0$3 -> {
                Option option = x0$3;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Accumulator result2 = (Accumulator)some.value();
                    return Future$.MODULE$.successful((Object)result2);
                }
                if (None$.MODULE$.equals(option)) {
                    return $this.cache.get(resultKey, ClassTag$.MODULE$.apply(SerializableResult.class)).map((Function1 & Serializable)result -> result.collect((PartialFunction)new Serializable(null){
                        private static final long serialVersionUID = 0L;

                        public final <A1 extends SerializableResult, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            if (A1 != null) {
                                A1 A12 = A1;
                                return (B1)Accumulator$.MODULE$.done((Object)A12.result());
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(SerializableResult x1) {
                            SerializableResult serializableResult = x1;
                            return serializableResult != null;
                        }
                    }), (ExecutionContext)Execution.Implicits$.MODULE$.trampoline()).map((Function1 & Serializable)x0$4 -> {
                        Option option = x0$4;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Accumulator cachedResource = (Accumulator)some.value();
                            return cachedResource;
                        }
                        if (None$.MODULE$.equals(option)) {
                            Accumulator accumulatorResult = (Accumulator)action.apply(request);
                            return accumulatorResult.mapFuture((Function1 & Serializable)x$2 -> this.handleResult((Result)x$2, etagKey, resultKey), (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
                        }
                        throw new MatchError((Object)option);
                    }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
                }
                throw new MatchError((Object)option);
            }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline()), $this.materializer);
        });
    }

    private PartialFunction<ResponseHeader, Duration> cachingWithEternity() {
        return this.cachingWithEternity;
    }

    private Future<Result> handleResult(Result result, String etagKey, String resultKey) {
        return (Future)this.cachingWithEternity().andThen((Function1 & Serializable)duration -> {
            String expirationDate = package$.MODULE$.dateFormat().format(Instant.ofEpochMilli(System.currentTimeMillis() + duration.toMillis()));
            String etag = "\"" + Codecs$.MODULE$.sha1(expirationDate) + "\"";
            Result resultWithHeaders = result.withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.ETAG()), (Object)etag), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.EXPIRES()), (Object)expirationDate)}));
            return $this.cache.set(etagKey, etag, (Duration)duration).flatMap((Function1 & Serializable)x$4 -> {
                Done done = x$4;
                return $this.cache.set(resultKey, new SerializableResult(resultWithHeaders), (Duration)duration).map((Function1 & Serializable)x$3 -> {
                    Done done = x$3;
                    return resultWithHeaders;
                }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
            }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
        }).applyOrElse((Object)result.header(), (Function1 & Serializable)x$5 -> Future$.MODULE$.successful((Object)result));
    }

    public CachedBuilder includeStatus(int status) {
        return this.includeStatus(status, (Duration)Duration$.MODULE$.Zero());
    }

    public CachedBuilder includeStatus(int status, int duration) {
        return this.includeStatus(status, (Duration)Duration$.MODULE$.apply((long)duration, TimeUnit.SECONDS));
    }

    public CachedBuilder includeStatus(int status, Duration duration) {
        return this.compose((PartialFunction<ResponseHeader, Duration>)new Serializable(null, status, duration){
            private static final long serialVersionUID = 0L;
            private final int status$1;
            private final Duration duration$4;

            public final <A1 extends ResponseHeader, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.status() == this.status$1) {
                    return (B1)this.duration$4;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(ResponseHeader x1) {
                ResponseHeader responseHeader = x1;
                return responseHeader.status() == this.status$1;
            }
            {
                this.status$1 = status$1;
                this.duration$4 = duration$4;
            }
        });
    }

    public CachedBuilder default(Duration duration) {
        return this.compose((PartialFunction<ResponseHeader, Duration>)new Serializable(null, duration){
            private static final long serialVersionUID = 0L;
            private final Duration duration$5;

            public final <A1 extends ResponseHeader, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    return (B1)this.duration$5;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(ResponseHeader x1) {
                ResponseHeader responseHeader = x1;
                return responseHeader != null;
            }
            {
                this.duration$5 = duration$5;
            }
        });
    }

    public CachedBuilder default(int duration) {
        return this.default((Duration)Duration$.MODULE$.apply((long)duration, TimeUnit.SECONDS));
    }

    public CachedBuilder compose(PartialFunction<ResponseHeader, Duration> alternative) {
        return new CachedBuilder(this.cache, this.key, (PartialFunction<ResponseHeader, Duration>)this.caching.orElse(alternative), this.materializer);
    }

    private static final List parseEtag$1(String etag) {
        Regex Etag = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?:W/)?(\"[^\"]*\")"));
        return Etag.findAllMatchIn((CharSequence)etag).map((Function1 & Serializable)m -> m.group(1)).toList();
    }

    public CachedBuilder(AsyncCacheApi cache, Function1<RequestHeader, String> key, PartialFunction<ResponseHeader, Duration> caching, Materializer materializer) {
        this.cache = cache;
        this.key = key;
        this.caching = caching;
        this.materializer = materializer;
        this.cachingWithEternity = caching.andThen((Function1 & Serializable)duration -> {
            boolean zeroDuration = duration.neg().equals(duration);
            if (zeroDuration) {
                return Duration$.MODULE$.apply(31536000L, TimeUnit.SECONDS);
            }
            return duration;
        });
    }
}

