/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.maven.report.generator;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.pitest.maven.report.generator.ReportGenerationContext;
import org.pitest.maven.report.generator.ReportGenerationResultEnum;
import org.pitest.maven.report.generator.ReportGenerationStrategy;

public class HTMLReportGenerator
implements ReportGenerationStrategy {
    protected static final FileFilter EXCLUDE_TIMESTAMPED_REPORTS_DIRECTORIES = new NotFileFilter((IOFileFilter)new RegexFileFilter("^\\d+$"));

    @Override
    public ReportGenerationResultEnum generate(ReportGenerationContext context) {
        try {
            context.getLogger().debug((CharSequence)("HTMLReportGenerator using directory [" + String.valueOf(context.getReportsDataDirectory()) + "] as directory containing the html report"));
            context.getLogger().debug((CharSequence)("HTMLReportGenerator using directory [" + String.valueOf(context.getSiteDirectory()) + "] as directory that is the destination of the site report"));
            FileUtils.copyDirectory((File)context.getReportsDataDirectory(), (File)context.getSiteDirectory(), (FileFilter)EXCLUDE_TIMESTAMPED_REPORTS_DIRECTORIES);
        }
        catch (IOException e) {
            context.getLogger().warn((Throwable)e);
            return ReportGenerationResultEnum.FAILURE;
        }
        return ReportGenerationResultEnum.SUCCESS;
    }

    @Override
    public String getGeneratorName() {
        return "HTMLReportGenerator";
    }

    @Override
    public String getGeneratorDataFormat() {
        return "HTML";
    }
}

