/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.tooling;

import java.util.Optional;
import org.pitest.mutationtest.tooling.CombinedStatistics;

public final class AnalysisResult {
    private final Optional<CombinedStatistics> statistics;
    private final Optional<Exception> error;

    private AnalysisResult(CombinedStatistics statistics, Exception error) {
        this.statistics = Optional.ofNullable(statistics);
        this.error = Optional.ofNullable(error);
    }

    public static AnalysisResult success(CombinedStatistics statistics) {
        return new AnalysisResult(statistics, null);
    }

    public static AnalysisResult fail(Exception error) {
        return new AnalysisResult(null, error);
    }

    public Optional<CombinedStatistics> getStatistics() {
        return this.statistics;
    }

    public Optional<Exception> getError() {
        return this.error;
    }
}

