/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.highwheel.model;

import java.io.Serializable;

public final class ElementName
implements Serializable,
Comparable<ElementName> {
    private static final long serialVersionUID = 1L;
    private final String name;

    public ElementName(String name) {
        this(name, true);
    }

    public ElementName(String name, boolean intern) {
        this.name = intern ? ElementName.removeSymbols(name).intern() : ElementName.removeSymbols(name);
    }

    private static String removeSymbols(String name) {
        return name.replace('.', '/');
    }

    public ElementName(Class<?> clazz) {
        this(clazz.getName());
    }

    public static ElementName fromString(String clazz) {
        return new ElementName(clazz);
    }

    public static ElementName fromClass(Class<?> clazz) {
        return new ElementName(clazz);
    }

    public String asJavaName() {
        return this.name.replace('/', '.');
    }

    public String asInternalName() {
        return this.name;
    }

    public ElementName getNameWithoutPackage() {
        int lastSeperator = this.name.lastIndexOf(47);
        if (lastSeperator != -1) {
            return new ElementName(this.name.substring(lastSeperator + 1, this.name.length()));
        }
        return this;
    }

    public ElementName getParent() {
        int lastSeperator = this.name.lastIndexOf(47);
        if (lastSeperator != -1) {
            return new ElementName(this.name.substring(0, lastSeperator));
        }
        return new ElementName("");
    }

    public ElementName withoutPrefixChars(int prefixLength) {
        String nameWithoutPackage = this.getNameWithoutPackage().asJavaName();
        return new ElementName(this.getParent().asJavaName() + "/" + nameWithoutPackage.substring(prefixLength, nameWithoutPackage.length()));
    }

    public ElementName withoutSuffixChars(int suffixLength) {
        String nameWithoutPacakge = this.getNameWithoutPackage().asJavaName();
        return new ElementName(this.getParent().asJavaName() + "/" + nameWithoutPacakge.substring(0, nameWithoutPacakge.length() - suffixLength));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElementName other = (ElementName)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.asJavaName();
    }

    @Override
    public int compareTo(ElementName o) {
        return this.asJavaName().compareTo(o.asJavaName());
    }
}

