/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.highwheel.model;

import org.pitest.highwheel.model.AccessPoint;
import org.pitest.highwheel.model.AccessType;

public final class Access {
    private final AccessType type;
    private final AccessPoint source;
    private final AccessPoint dest;

    private Access(AccessPoint source, AccessPoint dest, AccessType type) {
        this.type = type;
        this.dest = dest;
        this.source = source;
    }

    public static Access create(AccessPoint source, AccessPoint dest, AccessType type) {
        return new Access(source, dest, type);
    }

    public int getStrength() {
        return this.type.getStrength();
    }

    public AccessType getType() {
        return this.type;
    }

    public AccessPoint getSource() {
        return this.source;
    }

    public AccessPoint getDest() {
        return this.dest;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dest == null ? 0 : this.dest.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Access other = (Access)obj;
        if (this.dest == null ? other.dest != null : !this.dest.equals(other.dest)) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        return this.type == other.type;
    }
}

