/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.api.saml.v2.metadata;

import java.util.List;
import org.picketlink.identity.federation.api.saml.v2.metadata.SecurityActions;
import org.picketlink.identity.federation.saml.v2.metadata.EndpointType;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IDPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IndexedEndpointType;
import org.picketlink.identity.federation.saml.v2.metadata.RoleDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.SPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.SSODescriptorType;

public class MetaDataExtractor {
    public static String LINE_SEPARATOR = SecurityActions.getSystemProperty("line.separator", "\n");

    public static String toString(EntityDescriptorType edt) {
        StringBuilder builder = new StringBuilder();
        List rolesD = edt.getRoleDescriptorOrIDPSSODescriptorOrSPSSODescriptor();
        for (RoleDescriptorType rdt : rolesD) {
            builder.append("ID=").append(rdt.getID());
            builder.append(LINE_SEPARATOR);
            if (rdt instanceof IDPSSODescriptorType) {
                IDPSSODescriptorType idp = (IDPSSODescriptorType)rdt;
                builder.append(MetaDataExtractor.toString(idp));
            }
            if (!(rdt instanceof SPSSODescriptorType)) continue;
            SPSSODescriptorType sp = (SPSSODescriptorType)rdt;
            builder.append(MetaDataExtractor.toString(sp));
        }
        return builder.toString();
    }

    public static String toString(IDPSSODescriptorType idp) {
        StringBuilder builder = new StringBuilder();
        builder.append(LINE_SEPARATOR);
        IDPSSODescriptorType sdt = idp;
        builder.append(MetaDataExtractor.toString((SSODescriptorType)sdt));
        List ssoServices = idp.getSingleSignOnService();
        if (ssoServices != null) {
            builder.append("Single Sign On Services are:[");
            for (EndpointType edt : ssoServices) {
                builder.append(MetaDataExtractor.toString(edt));
            }
            builder.append("]");
            builder.append(LINE_SEPARATOR);
        }
        return builder.toString();
    }

    public static String toString(SPSSODescriptorType sp) {
        StringBuilder builder = new StringBuilder();
        builder.append(LINE_SEPARATOR);
        SPSSODescriptorType sdt = sp;
        builder.append(MetaDataExtractor.toString((SSODescriptorType)sdt));
        List assertionConsumerServices = sp.getAssertionConsumerService();
        if (assertionConsumerServices != null) {
            builder.append("AssertionConsumer Services are:[");
            for (IndexedEndpointType edt : assertionConsumerServices) {
                builder.append(MetaDataExtractor.toString((EndpointType)edt));
            }
            builder.append("]");
            builder.append(LINE_SEPARATOR);
        }
        builder.append("AuthnRequests Signed=").append(sp.isAuthnRequestsSigned());
        builder.append(LINE_SEPARATOR);
        builder.append("Requires Assertions Signed=").append(sp.isWantAssertionsSigned());
        builder.append(LINE_SEPARATOR);
        return builder.toString();
    }

    public static String toString(SSODescriptorType sso) {
        List sloServices;
        List attrResServices;
        StringBuilder builder = new StringBuilder();
        List nameIDs = sso.getNameIDFormat();
        if (nameIDs != null) {
            for (String nameID : nameIDs) {
                builder.append("NameID=").append(nameID);
                builder.append(LINE_SEPARATOR);
            }
        }
        if ((attrResServices = sso.getArtifactResolutionService()) != null) {
            builder.append("AttributeResolutionServices are:[");
            builder.append(LINE_SEPARATOR);
            for (IndexedEndpointType iet : attrResServices) {
                builder.append(MetaDataExtractor.toString((EndpointType)iet));
            }
            builder.append("]");
        }
        if ((sloServices = sso.getSingleLogoutService()) != null) {
            builder.append("Single Logout Services are:[");
            builder.append(LINE_SEPARATOR);
            for (EndpointType edt : sloServices) {
                builder.append(MetaDataExtractor.toString(edt));
            }
            builder.append("]");
            builder.append(LINE_SEPARATOR);
        }
        return builder.toString();
    }

    public static String toString(EndpointType ept) {
        StringBuilder builder = new StringBuilder();
        builder.append("[Location=").append(ept.getLocation());
        builder.append(",ResponseLocation=").append(ept.getResponseLocation());
        builder.append("]");
        builder.append(LINE_SEPARATOR);
        return builder.toString();
    }
}

