/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play.java;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.Callable;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.play.CallbackController;
import org.pac4j.play.Config;
import org.pac4j.play.StorageHelper;
import org.pac4j.play.java.JavaWebContext;
import org.pac4j.play.java.RequiresAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.libs.Akka;
import play.libs.F;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;
import play.mvc.SimpleResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RequiresAuthenticationAction
extends Action<Result> {
    private static final Logger logger = LoggerFactory.getLogger(RequiresAuthenticationAction.class);
    private static final Method clientNameMethod;
    private static final Method targetUrlMethod;
    private static final Method isAjaxMethod;

    public F.Promise<SimpleResult> call(final Http.Context context) throws Throwable {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(this.configuration);
        String clientName = (String)invocationHandler.invoke(this.configuration, clientNameMethod, null);
        logger.debug("clientName : {}", (Object)clientName);
        String targetUrl = (String)invocationHandler.invoke(this.configuration, targetUrlMethod, null);
        logger.debug("targetUrl : {}", (Object)targetUrl);
        final Boolean isAjax = (Boolean)invocationHandler.invoke(this.configuration, isAjaxMethod, null);
        logger.debug("isAjax : {}", (Object)isAjax);
        String sessionId = StorageHelper.getOrCreationSessionId(context.session());
        logger.debug("sessionId : {}", (Object)sessionId);
        CommonProfile profile = StorageHelper.getProfile(sessionId);
        logger.debug("profile : {}", (Object)profile);
        if (profile != null) {
            return this.delegate.call(context);
        }
        String requestedUrlToSave = CallbackController.defaultUrl(targetUrl, context.request().uri());
        logger.debug("requestedUrlToSave : {}", (Object)requestedUrlToSave);
        StorageHelper.saveRequestedUrl(sessionId, clientName, requestedUrlToSave);
        final Client client = Config.getClients().findClient(clientName);
        logger.debug("client : {}", (Object)client);
        F.Promise promiseOfResult = Akka.future((Callable)new Callable<SimpleResult>(){

            @Override
            public SimpleResult call() {
                try {
                    JavaWebContext webContext = new JavaWebContext(context.request(), context.response(), context.session());
                    RedirectAction action = ((BaseClient)client).getRedirectAction((WebContext)webContext, true, isAjax.booleanValue());
                    logger.debug("redirectAction : {}", (Object)action);
                    return RequiresAuthenticationAction.this.convertToPromise(action);
                }
                catch (RequiresHttpAction e) {
                    int code = e.getCode();
                    logger.debug("requires HTTP action : {}", (Object)code);
                    if (code == 401) {
                        return Results.unauthorized((String)Config.getErrorPage401()).as("text/html; charset=utf-8");
                    }
                    if (code == 403) {
                        return Results.forbidden((String)Config.getErrorPage403()).as("text/html; charset=utf-8");
                    }
                    String message = "Unsupported HTTP action : " + code;
                    logger.error(message);
                    throw new TechnicalException(message);
                }
            }
        });
        return promiseOfResult;
    }

    private SimpleResult convertToPromise(RedirectAction action) {
        switch (action.getType()) {
            case REDIRECT: {
                return RequiresAuthenticationAction.redirect((String)action.getLocation());
            }
            case SUCCESS: {
                return RequiresAuthenticationAction.ok((String)action.getContent()).as("text/html; charset=utf-8");
            }
        }
        throw new TechnicalException("Unsupported RedirectAction type " + action.getType());
    }

    static {
        try {
            clientNameMethod = RequiresAuthentication.class.getDeclaredMethod("clientName", new Class[0]);
            targetUrlMethod = RequiresAuthentication.class.getDeclaredMethod("targetUrl", new Class[0]);
            isAjaxMethod = RequiresAuthentication.class.getDeclaredMethod("isAjax", new Class[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

