/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play.java;

import java.util.HashMap;
import java.util.Map;
import org.pac4j.core.context.BaseResponseContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.play.StorageHelper;
import play.mvc.Http;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaWebContext
extends BaseResponseContext {
    private final Http.Request request;
    private final Http.Response response;
    private final Http.Session session;
    private String scheme = "http";

    public JavaWebContext(Http.Request request, Http.Response response, Http.Session session) {
        this.request = request;
        this.response = response;
        this.session = session;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getRequestHeader(String name) {
        return this.request.getHeader(name);
    }

    public String getRequestMethod() {
        return this.request.method();
    }

    public String getRequestParameter(String name) {
        Map<String, String[]> parameters = this.getRequestParameters();
        String[] values = parameters.get(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Map<String, String[]> getRequestParameters() {
        Map formParameters = this.request.body().asFormUrlEncoded();
        Map urlParameters = this.request.queryString();
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        if (formParameters != null) {
            parameters.putAll(formParameters);
        }
        if (urlParameters != null) {
            parameters.putAll(urlParameters);
        }
        return parameters;
    }

    public Object getSessionAttribute(String key) {
        String sessionId = (String)this.session.get((Object)"pac4jSessionId");
        if (CommonHelper.isNotBlank((String)sessionId)) {
            return StorageHelper.get(sessionId, key);
        }
        return null;
    }

    public void setSessionAttribute(String key, Object value) {
        String sessionId = (String)this.session.get((Object)"pac4jSessionId");
        if (CommonHelper.isNotBlank((String)sessionId)) {
            StorageHelper.save(sessionId, key, value);
        }
    }

    public void setResponseHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public Http.Session getSession() {
        return this.session;
    }

    public String getServerName() {
        String[] split = this.request.host().split(":");
        return split[0];
    }

    public int getServerPort() {
        String[] split = this.request.host().split(":");
        String portStr = split.length > 1 ? split[1] : "80";
        return Integer.valueOf(portStr);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String readRequestContent() {
        return "";
    }

    public String getFullRequestURL() {
        return this.getScheme() + "://" + this.request.host() + this.request.uri();
    }
}

