/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play.java;

import org.apache.commons.lang3.StringUtils;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.play.CallbackController;
import org.pac4j.play.Config;
import org.pac4j.play.StorageHelper;
import org.pac4j.play.java.JavaWebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaController
extends CallbackController {
    protected static final Logger logger = LoggerFactory.getLogger(JavaController.class);

    protected static RedirectAction getRedirectAction(String clientName) {
        return JavaController.getRedirectAction(clientName, null);
    }

    protected static RedirectAction getRedirectAction(String clientName, String targetUrl) {
        String sessionId = StorageHelper.getOrCreationSessionId(JavaController.session());
        String requestedUrlToSave = CallbackController.defaultUrl(targetUrl, JavaController.request().uri());
        logger.debug("requestedUrlToSave : {}", (Object)requestedUrlToSave);
        StorageHelper.saveRequestedUrl(sessionId, clientName, requestedUrlToSave);
        Clients clients = Config.getClients();
        if (clients == null) {
            throw new TechnicalException("No client defined. Use Config.setClients(clients)");
        }
        JavaWebContext webContext = new JavaWebContext(JavaController.request(), JavaController.response(), JavaController.session());
        RedirectAction action = null;
        try {
            action = ((BaseClient)clients.findClient(clientName)).getRedirectAction((WebContext)webContext, false, false);
        }
        catch (RequiresHttpAction e) {
            // empty catch block
        }
        logger.debug("redirectAction : {}", action);
        return action;
    }

    protected static CommonProfile getUserProfile() {
        String sessionId = JavaController.session((String)"pac4jSessionId");
        logger.debug("sessionId for profile : {}", (Object)sessionId);
        if (StringUtils.isNotBlank((CharSequence)sessionId)) {
            CommonProfile profile = StorageHelper.getProfile(sessionId);
            logger.debug("profile : {}", (Object)profile);
            return profile;
        }
        return null;
    }
}

