/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play;

import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.play.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.cache.Cache;
import play.mvc.Http;

public final class StorageHelper {
    private static final Logger logger = LoggerFactory.getLogger(StorageHelper.class);

    public static String getOrCreationSessionId(Http.Session session) {
        String sessionId = (String)session.get((Object)"pac4jSessionId");
        logger.debug("retrieved sessionId : {}", (Object)sessionId);
        if (sessionId == null) {
            sessionId = StorageHelper.generateSessionId();
            logger.debug("generated sessionId : {}", (Object)sessionId);
            session.put("pac4jSessionId", sessionId);
        }
        return sessionId;
    }

    public static String generateSessionId() {
        return UUID.randomUUID().toString();
    }

    public static CommonProfile getProfile(String sessionId) {
        if (sessionId != null) {
            return (CommonProfile)StorageHelper.get(sessionId);
        }
        return null;
    }

    public static void saveProfile(String sessionId, CommonProfile profile) {
        if (sessionId != null) {
            StorageHelper.save(sessionId, profile, Config.getProfileTimeout());
        }
    }

    public static void removeProfile(String sessionId) {
        if (sessionId != null) {
            StorageHelper.remove(sessionId);
        }
    }

    public static String getRequestedUrl(String sessionId, String clientName) {
        return (String)StorageHelper.get(sessionId, clientName + "$" + "pac4jRequestedUrl");
    }

    public static void saveRequestedUrl(String sessionId, String clientName, String requestedUrl) {
        StorageHelper.save(sessionId, clientName + "$" + "pac4jRequestedUrl", requestedUrl);
    }

    public static Object get(String sessionId, String key) {
        if (sessionId != null) {
            return StorageHelper.get(sessionId + "$" + key);
        }
        return null;
    }

    public static void save(String sessionId, String key, Object value) {
        if (sessionId != null) {
            StorageHelper.save(sessionId + "$" + key, value, Config.getSessionTimeout());
        }
    }

    public static void remove(String sessionId, String key) {
        StorageHelper.remove(sessionId + "$" + key);
    }

    public static Object get(String key) {
        return Cache.get((String)StorageHelper.getCacheKey(key));
    }

    public static void save(String key, Object value, int timeout) {
        Cache.set((String)StorageHelper.getCacheKey(key), (Object)value, (int)timeout);
    }

    public static void remove(String key) {
        StorageHelper.save(key, null, 0);
    }

    static String getCacheKey(String key) {
        return StringUtils.isNotBlank((CharSequence)Config.getCacheKeyPrefix()) ? Config.getCacheKeyPrefix() + ":" + key : key;
    }
}

