/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play;

import org.apache.commons.lang3.StringUtils;
import org.pac4j.cas.logout.NoLogoutHandler;
import org.pac4j.core.context.WebContext;
import org.pac4j.play.Config;
import org.pac4j.play.StorageHelper;
import org.pac4j.play.java.JavaWebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlayLogoutHandler
extends NoLogoutHandler {
    private static final Logger logger = LoggerFactory.getLogger(PlayLogoutHandler.class);

    public void destroySession(WebContext context) {
        String logoutRequest = context.getRequestParameter("logoutRequest");
        logger.debug("logoutRequest : {}", (Object)logoutRequest);
        String ticket = StringUtils.substringBetween((String)logoutRequest, (String)"SessionIndex>", (String)"</");
        logger.debug("extract ticket : {}", (Object)ticket);
        String sessionId = (String)StorageHelper.get(ticket);
        logger.debug("found sessionId : {}", (Object)sessionId);
        StorageHelper.removeProfile(sessionId);
        StorageHelper.remove(ticket);
    }

    public void recordSession(WebContext context, String ticket) {
        logger.debug("ticket : {}", (Object)ticket);
        JavaWebContext javaWebContext = (JavaWebContext)context;
        String sessionId = (String)javaWebContext.getSession().get((Object)"pac4jSessionId");
        logger.debug("save sessionId : {}", (Object)sessionId);
        StorageHelper.save(ticket, (Object)sessionId, Config.getProfileTimeout());
    }
}

