/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Clients;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.play.Config;
import org.pac4j.play.StorageHelper;
import org.pac4j.play.java.JavaWebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.mvc.Controller;
import play.mvc.Result;
import play.mvc.Results;

public class CallbackController
extends Controller {
    protected static final Logger logger = LoggerFactory.getLogger(CallbackController.class);

    public static Result callback() {
        Clients clientsGroup = Config.getClients();
        JavaWebContext context = new JavaWebContext(CallbackController.request(), CallbackController.response(), CallbackController.session());
        BaseClient client = (BaseClient)clientsGroup.findClient((WebContext)context);
        logger.debug("client : {}", (Object)client);
        Credentials credentials = null;
        try {
            credentials = client.getCredentials((WebContext)context);
            logger.debug("credentials : {}", (Object)credentials);
        }
        catch (RequiresHttpAction e) {
            int code = context.getResponseStatus();
            logger.debug("requires HTTP action : {}", (Object)code);
            if (code == 401) {
                return CallbackController.unauthorized((String)Config.getErrorPage401()).as("text/html; charset=utf-8");
            }
            if (code == 302) {
                return Results.status((int)302);
            }
            if (code == 200) {
                String content = context.getResponseContent();
                logger.debug("render : {}", (Object)content);
                return CallbackController.ok((String)content).as("text/html; charset=utf-8");
            }
            String message = "Unsupported HTTP action : " + code;
            logger.error(message);
            throw new TechnicalException(message);
        }
        CommonProfile profile = client.getUserProfile(credentials, (WebContext)context);
        logger.debug("profile : {}", (Object)profile);
        String sessionId = StorageHelper.getOrCreationSessionId(CallbackController.session());
        if (profile != null) {
            StorageHelper.saveProfile(sessionId, profile);
        }
        String requestedUrl = StorageHelper.getRequestedUrl(sessionId, client.getName());
        return CallbackController.redirect((String)CallbackController.defaultUrl(requestedUrl, Config.getDefaultSuccessUrl()));
    }

    private static void logout() {
        String sessionId = CallbackController.session((String)"pac4jSessionId");
        logger.debug("sessionId for logout : {}", (Object)sessionId);
        if (StringUtils.isNotBlank((CharSequence)sessionId)) {
            StorageHelper.removeProfile(sessionId);
            logger.debug("remove user profile for sessionId : {}", (Object)sessionId);
        }
        CallbackController.session().remove((Object)"pac4jSessionId");
    }

    public static Result logoutAndOk() {
        CallbackController.logout();
        return CallbackController.ok();
    }

    public static Result logoutAndRedirect() {
        CallbackController.logout();
        Map parameters = CallbackController.request().queryString();
        String[] values = (String[])parameters.get("url");
        String value = null;
        if (values != null && values.length == 1) {
            String value0 = values[0];
            if (Config.getLogoutUrlPattern().matcher(value0).matches()) {
                value = value0;
            }
        }
        return CallbackController.redirect((String)CallbackController.defaultUrl(value, Config.getDefaultLogoutUrl()));
    }

    public static String defaultUrl(String url, String defaultUrl) {
        String redirectUrl = defaultUrl;
        if (StringUtils.isNotBlank((CharSequence)url)) {
            redirectUrl = url;
        }
        logger.debug("defaultUrl : {}", (Object)redirectUrl);
        return redirectUrl;
    }
}

