/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jwt.config.signature;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.jwt.config.signature.AbstractSignatureConfiguration;

public class SecretSignatureConfiguration
extends AbstractSignatureConfiguration {
    private String secret;

    public SecretSignatureConfiguration() {
        this.algorithm = JWSAlgorithm.HS256;
    }

    public SecretSignatureConfiguration(String secret) {
        this();
        this.secret = secret;
    }

    public SecretSignatureConfiguration(String secret, JWSAlgorithm algorithm) {
        this.secret = secret;
        this.algorithm = algorithm;
    }

    protected void internalInit() {
        CommonHelper.assertNotNull((String)"algorithm", (Object)this.algorithm);
        CommonHelper.assertNotBlank((String)"secret", (String)this.secret);
        if (!this.supports(this.algorithm)) {
            throw new TechnicalException("Only the HS256, HS384 and HS512 algorithms are supported for HMac signature");
        }
    }

    @Override
    public boolean supports(JWSAlgorithm algorithm) {
        return algorithm != null && MACVerifier.SUPPORTED_ALGORITHMS.contains(algorithm);
    }

    @Override
    public SignedJWT sign(JWTClaimsSet claims) {
        this.init();
        try {
            MACSigner signer = new MACSigner(this.secret);
            SignedJWT signedJWT = new SignedJWT(new JWSHeader(this.algorithm), claims);
            signedJWT.sign((JWSSigner)signer);
            return signedJWT;
        }
        catch (JOSEException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    @Override
    public boolean verify(SignedJWT jwt) throws JOSEException {
        this.init();
        MACVerifier verifier = new MACVerifier(this.secret);
        return jwt.verify((JWSVerifier)verifier);
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String toString() {
        return CommonHelper.toString(this.getClass(), (Object[])new Object[]{"secret", "[protected]", "algorithm", this.algorithm});
    }
}

