/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.authenticator;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.regex.Matcher;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.definition.CommonProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.http.credentials.X509Credentials;
import org.pac4j.http.credentials.authenticator.AbstractRegexpAuthenticator;
import org.pac4j.http.profile.X509Profile;

public class X509Authenticator
extends AbstractRegexpAuthenticator
implements Authenticator {
    public X509Authenticator() {
        this.setRegexpPattern("CN=(.*?)(?:,|$)");
    }

    public X509Authenticator(String regexpPattern) {
        this.setRegexpPattern(regexpPattern);
    }

    protected void internalInit(boolean forceReinit) {
        this.setProfileDefinitionIfUndefined((ProfileDefinition)new CommonProfileDefinition(x -> new X509Profile()));
    }

    public Optional<Credentials> validate(CallContext ctx, Credentials credentials) {
        this.init();
        X509Certificate certificate = ((X509Credentials)credentials).getCertificate();
        if (certificate == null) {
            throw new CredentialsException("No X509 certificate");
        }
        Principal principal = certificate.getSubjectDN();
        if (principal == null) {
            throw new CredentialsException("No X509 principal");
        }
        String subjectDN = principal.getName();
        this.logger.debug("subjectDN: {}", (Object)subjectDN);
        if (subjectDN == null) {
            throw new CredentialsException("No X509 subjectDN");
        }
        Matcher matcher = this.pattern.matcher(subjectDN);
        if (!matcher.find()) {
            throw new CredentialsException("No matching for pattern: " + this.regexpPattern + " in subjectDN: " + subjectDN);
        }
        if (matcher.groupCount() != 1) {
            throw new CredentialsException("Too many matchings for pattern: " + this.regexpPattern + " in subjectDN: " + subjectDN);
        }
        String id = matcher.group(1);
        X509Profile profile = (X509Profile)this.getProfileDefinition().newProfile(new Object[0]);
        profile.setId(id);
        this.logger.debug("profile: {}", (Object)profile);
        credentials.setUserProfile((UserProfile)profile);
        return Optional.of(credentials);
    }
}

