/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.indirect;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import lombok.Generated;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.credentials.extractor.FormExtractor;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;

public class FormClient
extends IndirectClient {
    private String loginUrl;
    public static final String ERROR_PARAMETER = "error";
    public static final String MISSING_FIELD_ERROR = "missing_field";
    private String usernameParameter = "username";
    private String passwordParameter = "password";

    public FormClient() {
    }

    public FormClient(String loginUrl, Authenticator usernamePasswordAuthenticator) {
        this.loginUrl = loginUrl;
        this.setAuthenticatorIfUndefined(usernamePasswordAuthenticator);
    }

    public FormClient(String loginUrl, String usernameParameter, String passwordParameter, Authenticator usernamePasswordAuthenticator) {
        this.loginUrl = loginUrl;
        this.usernameParameter = usernameParameter;
        this.passwordParameter = passwordParameter;
        this.setAuthenticatorIfUndefined(usernamePasswordAuthenticator);
    }

    public FormClient(String loginUrl, Authenticator usernamePasswordAuthenticator, ProfileCreator profileCreator) {
        this.loginUrl = loginUrl;
        this.setAuthenticatorIfUndefined(usernamePasswordAuthenticator);
        this.setProfileCreatorIfUndefined(profileCreator);
    }

    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotBlank((String)"loginUrl", (String)this.loginUrl);
        CommonHelper.assertNotBlank((String)"usernameParameter", (String)this.usernameParameter);
        CommonHelper.assertNotBlank((String)"passwordParameter", (String)this.passwordParameter);
        this.setRedirectionActionBuilderIfUndefined(ctx -> {
            WebContext webContext = ctx.webContext();
            String finalLoginUrl = this.getUrlResolver().compute(this.loginUrl, webContext);
            return Optional.of(HttpActionHelper.buildRedirectUrlAction((WebContext)webContext, (String)finalLoginUrl));
        });
        this.setCredentialsExtractorIfUndefined((CredentialsExtractor)new FormExtractor(this.usernameParameter, this.passwordParameter));
    }

    public Optional<Credentials> getCredentials(CallContext ctx) {
        this.init();
        CommonHelper.assertNotNull((String)"credentialsExtractor", (Object)this.getCredentialsExtractor());
        String username = ctx.webContext().getRequestParameter(this.usernameParameter).orElse(null);
        try {
            Optional credentials = this.getCredentialsExtractor().extract(ctx);
            this.logger.debug("usernamePasswordCredentials: {}", (Object)credentials);
            if (!credentials.isPresent()) {
                throw this.handleInvalidCredentials(ctx, username, "Username and password cannot be blank -> return to the form with error", MISSING_FIELD_ERROR);
            }
            return credentials;
        }
        catch (CredentialsException e) {
            throw this.handleInvalidCredentials(ctx, username, "Credentials validation fails -> return to the form with error", this.computeErrorMessage((Exception)((Object)e)));
        }
    }

    protected Optional<Credentials> internalValidateCredentials(CallContext ctx, Credentials credentials) {
        CommonHelper.assertNotNull((String)"authenticator", (Object)this.getAuthenticator());
        String username = ((UsernamePasswordCredentials)credentials).getUsername();
        try {
            return this.getAuthenticator().validate(ctx, credentials);
        }
        catch (CredentialsException e) {
            throw this.handleInvalidCredentials(ctx, username, "Credentials validation fails -> return to the form with error", this.computeErrorMessage((Exception)((Object)e)));
        }
    }

    protected HttpAction handleInvalidCredentials(CallContext ctx, String username, String message, String errorMessage) {
        WebContext webContext = ctx.webContext();
        if (this.getAjaxRequestResolver().isAjax(ctx)) {
            this.logger.info("AJAX request detected -> returning 401");
            return HttpActionHelper.buildUnauthenticatedAction((WebContext)webContext);
        }
        String redirectionUrl = CommonHelper.addParameter((String)this.loginUrl, (String)this.usernameParameter, (String)username);
        redirectionUrl = CommonHelper.addParameter((String)redirectionUrl, (String)ERROR_PARAMETER, (String)errorMessage);
        this.logger.debug("redirectionUrl: {}", (Object)redirectionUrl);
        return HttpActionHelper.buildRedirectUrlAction((WebContext)webContext, (String)redirectionUrl);
    }

    protected String computeErrorMessage(Exception e) {
        return e.getClass().getSimpleName();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getLoginUrl() {
        return this.loginUrl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPasswordParameter(String passwordParameter) {
        this.passwordParameter = passwordParameter;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "FormClient(super=" + super.toString() + ", loginUrl=" + this.loginUrl + ", usernameParameter=" + this.usernameParameter + ", passwordParameter=" + this.passwordParameter + ")";
    }
}

