/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.direct;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.credentials.CredentialUtil;
import org.pac4j.http.credentials.extractor.DigestAuthExtractor;

public class DirectDigestAuthClient
extends DirectClient {
    private String realm = "pac4jRealm";

    public DirectDigestAuthClient() {
    }

    public DirectDigestAuthClient(Authenticator digestAuthenticator) {
        this.defaultAuthenticator(digestAuthenticator);
    }

    public DirectDigestAuthClient(Authenticator digestAuthenticator, ProfileCreator profileCreator) {
        this.defaultAuthenticator(digestAuthenticator);
        this.defaultProfileCreator(profileCreator);
    }

    protected void internalInit(boolean forceReinit) {
        this.defaultCredentialsExtractor(new DigestAuthExtractor());
    }

    protected Optional<Credentials> retrieveCredentials(WebContext context, SessionStore sessionStore) {
        String nonce = this.calculateNonce();
        context.setResponseHeader("WWW-Authenticate", "Digest realm=\"" + this.realm + "\", qop=\"auth\", nonce=\"" + nonce + "\"");
        return super.retrieveCredentials(context, sessionStore);
    }

    private String calculateNonce() {
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy:MM:dd:HH:mm:ss.SSS");
        String fmtTime = formatter.format(time);
        return CredentialUtil.encryptMD5(fmtTime + CommonHelper.randomString((int)10));
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"name", this.getName(), "realm", this.realm, "extractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator()});
    }
}

