/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.drools.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.core.common.AgendaItem;
import org.drools.model.Drools;
import org.drools.model.PatternDSL;
import org.drools.model.RuleItemBuilder;
import org.drools.model.view.ViewItem;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.constraint.streams.common.inliner.JustificationsSupplier;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.constraint.streams.drools.DroolsConstraint;
import org.optaplanner.constraint.streams.drools.common.ConsequenceBuilder;
import org.optaplanner.constraint.streams.drools.common.RuleBuilder;

abstract class AbstractRuleContext {
    private final List<ViewItem<?>> viewItems;

    protected AbstractRuleContext(ViewItem<?> ... viewItems) {
        this.viewItems = Arrays.stream(viewItems).collect(Collectors.toList());
    }

    protected static void runConsequence(DroolsConstraint<?> constraint, Drools drools, WeightedScoreImpacter scoreImpacter, int impact, JustificationsSupplier justificationsSupplier) {
        constraint.assertCorrectImpact(impact);
        UndoScoreImpacter undoImpact = scoreImpacter.impactScore(impact, justificationsSupplier);
        AbstractRuleContext.addUndo(drools, undoImpact);
    }

    protected static void runConsequence(DroolsConstraint<?> constraint, Drools drools, WeightedScoreImpacter scoreImpacter, long impact, JustificationsSupplier justificationsSupplier) {
        constraint.assertCorrectImpact(impact);
        UndoScoreImpacter undoImpact = scoreImpacter.impactScore(impact, justificationsSupplier);
        AbstractRuleContext.addUndo(drools, undoImpact);
    }

    protected static void runConsequence(DroolsConstraint<?> constraint, Drools drools, WeightedScoreImpacter scoreImpacter, BigDecimal impact, JustificationsSupplier justificationsSupplier) {
        constraint.assertCorrectImpact(impact);
        UndoScoreImpacter undoImpact = scoreImpacter.impactScore(impact, justificationsSupplier);
        AbstractRuleContext.addUndo(drools, undoImpact);
    }

    private static void addUndo(Drools drools, UndoScoreImpacter undoImpact) {
        AgendaItem agendaItem = (AgendaItem)((RuleContext)drools).getMatch();
        agendaItem.setCallback((Runnable)undoImpact);
    }

    protected <Solution_> RuleBuilder<Solution_> assemble(ConsequenceBuilder<Solution_> consequenceBuilder) {
        return (constraint, scoreImpacterGlobal) -> {
            ArrayList ruleItemBuilderList = new ArrayList(this.viewItems);
            ruleItemBuilderList.add((ViewItem<?>)((RuleItemBuilder)consequenceBuilder.apply(constraint, scoreImpacterGlobal)));
            return PatternDSL.rule((String)constraint.getConstraintPackage(), (String)constraint.getConstraintName()).build(ruleItemBuilderList.toArray(new RuleItemBuilder[0]));
        };
    }
}

