/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.uni;

import java.util.function.Function;
import org.optaplanner.constraint.streams.bavet.common.AbstractScorer;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.core.api.score.Score;

public final class UniScorer<A>
extends AbstractScorer {
    private final String constraintPackage;
    private final String constraintName;
    private final Score<?> constraintWeight;
    private final Function<A, UndoScoreImpacter> scoreImpacter;
    private final int inputStoreIndex;

    public UniScorer(String constraintPackage, String constraintName, Score<?> constraintWeight, Function<A, UndoScoreImpacter> scoreImpacter, int inputStoreIndex) {
        this.constraintPackage = constraintPackage;
        this.constraintName = constraintName;
        this.constraintWeight = constraintWeight;
        this.scoreImpacter = scoreImpacter;
        this.inputStoreIndex = inputStoreIndex;
    }

    public void insert(UniTuple<A> tupleA) {
        if (tupleA.store[this.inputStoreIndex] != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + tupleA + ") was already added in the tupleStore.");
        }
        UndoScoreImpacter undoScoreImpacter = this.scoreImpacter.apply(tupleA.factA);
        tupleA.store[this.inputStoreIndex] = undoScoreImpacter;
    }

    public void retract(UniTuple<A> tupleA) {
        UndoScoreImpacter undoScoreImpacter = (UndoScoreImpacter)tupleA.store[this.inputStoreIndex];
        if (undoScoreImpacter != null) {
            undoScoreImpacter.run();
            tupleA.store[this.inputStoreIndex] = null;
        }
    }

    public String toString() {
        return "Scorer(" + this.constraintName + ") with constraintWeight (" + this.constraintWeight + ")";
    }
}

