/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInliner;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintStream;

public class NodeBuildHelper<Score_ extends Score<Score_>> {
    private final Set<? extends ConstraintStream> activeStreamSet;
    private final Map<Constraint, Score_> constraintWeightMap;
    private final AbstractScoreInliner<Score_> scoreInliner;
    private final Map<ConstraintStream, Consumer<? extends Tuple>> insertMap;
    private final Map<ConstraintStream, Consumer<? extends Tuple>> retractMap;
    private final Map<ConstraintStream, Integer> storeIndexMap;
    private List<AbstractNode> reversedNodeList;

    public NodeBuildHelper(Set<? extends ConstraintStream> activeStreamSet, Map<Constraint, Score_> constraintWeightMap, AbstractScoreInliner<Score_> scoreInliner) {
        this.activeStreamSet = activeStreamSet;
        this.insertMap = new HashMap<ConstraintStream, Consumer<? extends Tuple>>(Math.max(16, activeStreamSet.size()));
        this.retractMap = new HashMap<ConstraintStream, Consumer<? extends Tuple>>(Math.max(16, activeStreamSet.size()));
        this.storeIndexMap = new HashMap<ConstraintStream, Integer>(Math.max(16, activeStreamSet.size() / 2));
        this.reversedNodeList = new ArrayList<AbstractNode>(activeStreamSet.size());
        this.constraintWeightMap = constraintWeightMap;
        this.scoreInliner = scoreInliner;
    }

    public boolean isStreamActive(ConstraintStream stream) {
        return this.activeStreamSet.contains(stream);
    }

    public AbstractScoreInliner<Score_> getScoreInliner() {
        return this.scoreInliner;
    }

    public Score_ getConstraintWeight(Constraint constraint) {
        return (Score_)((Score)this.constraintWeightMap.get(constraint));
    }

    public void addNode(AbstractNode node) {
        this.reversedNodeList.add(node);
    }

    public <Tuple_ extends Tuple> void putInsertRetract(ConstraintStream stream, Consumer<Tuple_> insert, Consumer<Tuple_> retract) {
        this.insertMap.put(stream, insert);
        this.retractMap.put(stream, retract);
    }

    public <Tuple_ extends Tuple> Consumer<Tuple_> getInsert(ConstraintStream stream) {
        Consumer<? extends Tuple> insert = this.insertMap.get(stream);
        if (insert == null) {
            throw new IllegalStateException("Impossible state: the stream (" + stream + ") hasn't build a node yet.");
        }
        return insert;
    }

    public <Tuple_ extends Tuple> Consumer<Tuple_> getRetract(ConstraintStream stream) {
        Consumer<? extends Tuple> retract = this.retractMap.get(stream);
        if (retract == null) {
            throw new IllegalStateException("Impossible state: the stream (" + stream + ") hasn't build a node yet.");
        }
        return retract;
    }

    public <Tuple_ extends Tuple> Consumer<Tuple_> getAggregatedInsert(List<? extends ConstraintStream> streamList) {
        Consumer[] inserts = (Consumer[])streamList.stream().filter(this::isStreamActive).map(this::getInsert).toArray(Consumer[]::new);
        if (inserts.length == 0) {
            throw new IllegalStateException("Impossible state: None of the streamList (" + streamList + ") are active.");
        }
        if (inserts.length == 1) {
            return inserts[0];
        }
        return new AggregatedConsumer(inserts);
    }

    public <Tuple_ extends Tuple> Consumer<Tuple_> getAggregatedRetract(List<? extends ConstraintStream> streamList) {
        Consumer[] retracts = (Consumer[])streamList.stream().filter(this::isStreamActive).map(this::getRetract).toArray(Consumer[]::new);
        if (retracts.length == 0) {
            throw new IllegalStateException("Impossible state: None of the streamList (" + streamList + ") are active.");
        }
        if (retracts.length == 1) {
            return retracts[0];
        }
        return new AggregatedConsumer(retracts);
    }

    public int reserveTupleStoreIndex(ConstraintStream tupleSourceStream) {
        return this.storeIndexMap.compute(tupleSourceStream, (k, index) -> {
            if (index == null) {
                return 0;
            }
            if (index < 0) {
                throw new IllegalStateException("Impossible state: the tupleSourceStream (" + tupleSourceStream + ") is reserving a store after it has been extracted.");
            }
            return index + 1;
        });
    }

    public int extractTupleStoreSize(ConstraintStream tupleSourceStream) {
        Integer lastIndex = this.storeIndexMap.put(tupleSourceStream, Integer.MIN_VALUE);
        return lastIndex == null ? 0 : lastIndex + 1;
    }

    public List<AbstractNode> destroyAndGetNodeList() {
        List<AbstractNode> nodeList = this.reversedNodeList;
        Collections.reverse(nodeList);
        this.reversedNodeList = null;
        return nodeList;
    }

    private static final class AggregatedConsumer<Tuple_ extends Tuple>
    implements Consumer<Tuple_> {
        private final Consumer<Tuple_>[] consumers;

        public AggregatedConsumer(Consumer<Tuple_>[] consumers) {
            this.consumers = consumers;
        }

        @Override
        public void accept(Tuple_ tuple) {
            for (int i = 0; i < this.consumers.length; ++i) {
                this.consumers[i].accept(tuple);
            }
        }
    }
}

