/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.bi;

import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.constraint.streams.bavet.bi.BavetAbstractBiConstraintStream;
import org.optaplanner.constraint.streams.bavet.bi.JoinBiNode;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.BavetJoinConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.NodeBuildHelper;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.common.index.IndexerFactory;
import org.optaplanner.constraint.streams.bavet.common.index.JoinerUtils;
import org.optaplanner.constraint.streams.bavet.uni.BavetJoinBridgeUniConstraintStream;
import org.optaplanner.constraint.streams.bi.DefaultBiJoiner;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.ConstraintStream;

public final class BavetJoinBiConstraintStream<Solution_, A, B>
extends BavetAbstractBiConstraintStream<Solution_, A, B>
implements BavetJoinConstraintStream<Solution_> {
    private final BavetJoinBridgeUniConstraintStream<Solution_, A> leftParent;
    private final BavetJoinBridgeUniConstraintStream<Solution_, B> rightParent;
    private final DefaultBiJoiner<A, B> joiner;

    public BavetJoinBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetJoinBridgeUniConstraintStream<Solution_, A> leftParent, BavetJoinBridgeUniConstraintStream<Solution_, B> rightParent, DefaultBiJoiner<A, B> joiner) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.joiner = joiner;
    }

    @Override
    public boolean guaranteesDistinct() {
        return this.leftParent.guaranteesDistinct() && this.rightParent.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.leftParent.collectActiveConstraintStreams(constraintStreamSet);
        this.rightParent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public ConstraintStream getTupleSource() {
        return this;
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        int inputStoreIndexA = buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource());
        int inputStoreIndexB = buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource());
        Consumer insert = buildHelper.getAggregatedInsert(this.childStreamList);
        Consumer retract = buildHelper.getAggregatedRetract(this.childStreamList);
        int outputStoreSize = buildHelper.extractTupleStoreSize(this);
        IndexerFactory indexerFactory = new IndexerFactory(this.joiner);
        Indexer indexerA = indexerFactory.buildIndexer(true);
        Indexer indexerB = indexerFactory.buildIndexer(false);
        JoinBiNode node = new JoinBiNode(JoinerUtils.combineLeftMappings(this.joiner), JoinerUtils.combineRightMappings(this.joiner), inputStoreIndexA, inputStoreIndexB, insert, retract, outputStoreSize, indexerA, indexerB);
        buildHelper.addNode(node);
        buildHelper.putInsertRetract(this.leftParent, node::insertA, node::retractA);
        buildHelper.putInsertRetract(this.rightParent, node::insertB, node::retractB);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BavetJoinBiConstraintStream that = (BavetJoinBiConstraintStream)o;
        return Objects.equals(this.leftParent.getParent(), that.leftParent.getParent()) && Objects.equals(this.rightParent.getParent(), that.rightParent.getParent()) && Objects.equals(this.joiner, that.joiner);
    }

    public int hashCode() {
        return Objects.hash(this.leftParent.getParent(), this.rightParent.getParent(), this.joiner);
    }

    public String toString() {
        return "BiJoin() with " + this.childStreamList.size() + " children";
    }
}

