/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Function;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;

public abstract class AbstractFlattenLastNode<InTuple_ extends Tuple, OutTuple_ extends Tuple, EffectiveItem_, FlattenedItem_>
extends AbstractNode
implements TupleLifecycle<InTuple_> {
    private final int flattenLastStoreIndex;
    private final Function<EffectiveItem_, Iterable<FlattenedItem_>> mappingFunction;
    private final TupleLifecycle<OutTuple_> nextNodesTupleLifecycle;
    private final Queue<OutTuple_> dirtyTupleQueue = new ArrayDeque<OutTuple_>(1000);

    protected AbstractFlattenLastNode(int flattenLastStoreIndex, Function<EffectiveItem_, Iterable<FlattenedItem_>> mappingFunction, TupleLifecycle<OutTuple_> nextNodesTupleLifecycle) {
        this.flattenLastStoreIndex = flattenLastStoreIndex;
        this.mappingFunction = Objects.requireNonNull(mappingFunction);
        this.nextNodesTupleLifecycle = Objects.requireNonNull(nextNodesTupleLifecycle);
    }

    @Override
    public void insert(InTuple_ tuple) {
        if (tuple.getStore(this.flattenLastStoreIndex) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + tuple + ") was already added in the tupleStore.");
        }
        ArrayList outTupleList = new ArrayList();
        for (FlattenedItem_ item : this.mappingFunction.apply(this.getEffectiveFactIn(tuple))) {
            this.addTuple(tuple, item, outTupleList);
        }
        if (!outTupleList.isEmpty()) {
            tuple.setStore(this.flattenLastStoreIndex, outTupleList);
        }
    }

    private void addTuple(InTuple_ originalTuple, FlattenedItem_ item, List<OutTuple_> outTupleList) {
        OutTuple_ tuple = this.createTuple(originalTuple, item);
        outTupleList.add(tuple);
        this.dirtyTupleQueue.add(tuple);
    }

    protected abstract OutTuple_ createTuple(InTuple_ var1, FlattenedItem_ var2);

    @Override
    public void update(InTuple_ tuple) {
        List outTupleList = (List)tuple.getStore(this.flattenLastStoreIndex);
        if (outTupleList == null) {
            this.insert(tuple);
            return;
        }
        Iterator<FlattenedItem_> iterator = this.mappingFunction.apply(this.getEffectiveFactIn(tuple)).iterator();
        if (!iterator.hasNext()) {
            this.retract(tuple);
            return;
        }
        ArrayList newFlattenedItemList = new ArrayList();
        iterator.forEachRemaining(newFlattenedItemList::add);
        ListIterator outTupleIterator = outTupleList.listIterator();
        while (outTupleIterator.hasNext()) {
            Tuple outTuple = (Tuple)outTupleIterator.next();
            FlattenedItem_ existingFlattenedItem = this.getEffectiveFactOut(outTuple);
            boolean existsAlsoInNew = false;
            ListIterator newFlattenedItemIterator = newFlattenedItemList.listIterator();
            while (newFlattenedItemIterator.hasNext()) {
                Object newFlattenedItem = newFlattenedItemIterator.next();
                if (newFlattenedItem != existingFlattenedItem) continue;
                newFlattenedItemIterator.remove();
                existsAlsoInNew = true;
                break;
            }
            if (!existsAlsoInNew) {
                outTupleIterator.remove();
                this.removeTuple(outTuple);
                continue;
            }
            outTuple.setState(BavetTupleState.UPDATING);
            this.dirtyTupleQueue.add(outTuple);
        }
        for (Object newFlattenedItem : newFlattenedItemList) {
            this.addTuple(tuple, newFlattenedItem, outTupleList);
        }
    }

    protected abstract EffectiveItem_ getEffectiveFactIn(InTuple_ var1);

    protected abstract FlattenedItem_ getEffectiveFactOut(OutTuple_ var1);

    @Override
    public void retract(InTuple_ tuple) {
        List outTupleList = (List)tuple.removeStore(this.flattenLastStoreIndex);
        if (outTupleList == null) {
            return;
        }
        for (Tuple item : outTupleList) {
            this.removeTuple(item);
        }
    }

    private void removeTuple(OutTuple_ outTuple) {
        switch (outTuple.getState()) {
            case CREATING: {
                outTuple.setState(BavetTupleState.ABORTING);
                break;
            }
            case UPDATING: 
            case OK: {
                outTuple.setState(BavetTupleState.DYING);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The tuple (" + outTuple + ") is in an unexpected state (" + outTuple.getState() + ").");
            }
        }
        this.dirtyTupleQueue.add(outTuple);
    }

    @Override
    public void calculateScore() {
        block6: for (Tuple outTuple : this.dirtyTupleQueue) {
            switch (outTuple.getState()) {
                case CREATING: {
                    this.nextNodesTupleLifecycle.insert(outTuple);
                    outTuple.setState(BavetTupleState.OK);
                    continue block6;
                }
                case UPDATING: {
                    this.nextNodesTupleLifecycle.update(outTuple);
                    outTuple.setState(BavetTupleState.OK);
                    continue block6;
                }
                case DYING: {
                    this.nextNodesTupleLifecycle.retract(outTuple);
                    outTuple.setState(BavetTupleState.DEAD);
                    continue block6;
                }
                case ABORTING: {
                    outTuple.setState(BavetTupleState.DEAD);
                    continue block6;
                }
            }
            throw new IllegalStateException("Impossible state: The tuple (" + outTuple + ") in node (" + this + ") is in an unexpected state (" + outTuple.getState() + ").");
        }
        this.dirtyTupleQueue.clear();
    }
}

