/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.reactors;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.ConfigurationManager;
import org.ops4j.pax.exam.ExamConfigurationException;
import org.ops4j.pax.exam.ExamFactory;
import org.ops4j.pax.exam.ExamSystem;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.ProbeBuilder;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.TestContainerFactory;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.options.SystemPropertyOption;
import org.ops4j.pax.exam.options.WarProbeOption;
import org.ops4j.pax.exam.spi.DefaultExamReactor;
import org.ops4j.pax.exam.spi.DefaultExamSystem;
import org.ops4j.pax.exam.spi.ExamReactor;
import org.ops4j.pax.exam.spi.PaxExamRuntime;
import org.ops4j.pax.exam.spi.StagedExamReactor;
import org.ops4j.pax.exam.spi.StagedExamReactorFactory;
import org.ops4j.pax.exam.spi.reactors.AnnotationHandler;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;
import org.ops4j.pax.exam.spi.reactors.PerMethod;
import org.ops4j.pax.exam.spi.reactors.PerSuite;
import org.ops4j.pax.exam.util.Injector;
import org.ops4j.pax.exam.util.InjectorFactory;
import org.ops4j.spi.ServiceProviderFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactorManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReactorManager.class);
    private static ReactorManager instance;
    private Map<String, StagedExamReactorFactory> reactorStrategies;
    private ExamSystem system;
    private String systemType;
    private Class<?> currentTestClass;
    private ExamReactor reactor;
    private TestProbeBuilder defaultProbeBuilder;
    private Map<TestAddress, Object> testAddressToMethodMap = new LinkedHashMap<TestAddress, Object>();
    private Set<Class<?>> testClasses = new HashSet();
    private boolean suiteStarted;
    private ConfigurationManager cm;
    private boolean waitForAfterSuiteEvent;
    private AnnotationHandler annotationHandler;
    private int numConfigurations;

    private ReactorManager() {
        try {
            this.cm = new ConfigurationManager();
            this.system = this.createExamSystem();
            this.reactorStrategies = new HashMap<String, StagedExamReactorFactory>(3);
            this.reactorStrategies.put("PerSuite", new PerSuite());
            this.reactorStrategies.put("PerClass", new PerClass());
            this.reactorStrategies.put("PerMethod", new PerMethod());
        }
        catch (IOException exc) {
            throw new TestContainerException("cannot create Exam system", (Throwable)exc);
        }
    }

    public static synchronized ReactorManager getInstance() {
        if (instance == null) {
            instance = new ReactorManager();
        }
        return instance;
    }

    public synchronized ExamReactor prepareReactor(Class<?> _testClass, Object testClassInstance) throws InstantiationException, IllegalAccessException, InvocationTargetException, IOException {
        this.currentTestClass = _testClass;
        this.reactor = this.createReactor(_testClass);
        this.testClasses.add(_testClass);
        this.addConfigurationsToReactor(_testClass, testClassInstance);
        return this.reactor;
    }

    public StagedExamReactor stageReactor() throws IOException, InstantiationException, IllegalAccessException {
        StagedExamReactor stagedReactor = this.reactor.stage(this.getStagingFactory(this.currentTestClass));
        return stagedReactor;
    }

    private ExamSystem createExamSystem() throws IOException {
        this.systemType = this.cm.getProperty("pax.exam.system", "test");
        String timeout = this.cm.getProperty("pax.exam.service.timeout", "10000");
        SystemPropertyOption timeoutOption = new SystemPropertyOption("pax.exam.service.timeout").value(timeout);
        this.system = "default".equals(this.systemType) ? DefaultExamSystem.create(new Option[]{timeoutOption}) : ("javaee".equals(this.systemType) ? DefaultExamSystem.create(new Option[]{new WarProbeOption()}) : PaxExamRuntime.createTestSystem(new Option[]{timeoutOption}));
        return this.system;
    }

    private void addConfigurationsToReactor(Class<?> testClass, Object testClassInstance) throws IllegalAccessException, InvocationTargetException, IOException {
        Method[] methods;
        this.numConfigurations = 0;
        for (Method m : methods = testClass.getMethods()) {
            if (!this.isConfiguration(m)) continue;
            this.reactor.addConfiguration((Option[])m.invoke(testClassInstance, new Object[0]));
            ++this.numConfigurations;
        }
    }

    public int getNumConfigurations() {
        return this.numConfigurations;
    }

    private boolean isConfiguration(Method m) {
        Configuration conf = m.getAnnotation(Configuration.class);
        return conf != null || this.annotationHandler.isConfiguration(m);
    }

    private StagedExamReactorFactory getStagingFactory(Class<?> testClass) throws InstantiationException, IllegalAccessException {
        ExamReactorStrategy strategy = testClass.getAnnotation(ExamReactorStrategy.class);
        String strategyName = this.cm.getProperty("pax.exam.reactor.strategy");
        if (strategy != null) {
            StagedExamReactorFactory fact = strategy.value()[0].newInstance();
            return fact;
        }
        StagedExamReactorFactory fact = this.annotationHandler.createStagedReactorFactory(testClass);
        if (fact != null) {
            return fact;
        }
        if (strategyName == null) {
            strategyName = this.systemType.equals("cdi") || this.systemType.equals("javaee") ? "PerSuite" : "PerMethod";
        }
        if ((fact = this.reactorStrategies.get(strategyName)) == null) {
            throw new IllegalArgumentException("unknown reactor strategy " + strategyName);
        }
        return fact;
    }

    private DefaultExamReactor createReactor(Class<?> testClass) throws InstantiationException, IllegalAccessException {
        return new DefaultExamReactor(this.system, this.createsTestContainerFactory(testClass));
    }

    private TestContainerFactory createsTestContainerFactory(Class<?> testClass) throws IllegalAccessException, InstantiationException {
        ExamFactory f = testClass.getAnnotation(ExamFactory.class);
        if (f != null) {
            TestContainerFactory fact = (TestContainerFactory)f.value().newInstance();
            return fact;
        }
        TestContainerFactory fact = this.annotationHandler.createTestContainerFactory(testClass);
        if (fact == null) {
            fact = PaxExamRuntime.getTestContainerFactory();
        }
        return fact;
    }

    public TestProbeBuilder createProbeBuilder(Object testClassInstance) throws IOException, ExamConfigurationException {
        TestProbeBuilder probeBuilder;
        if (this.defaultProbeBuilder == null) {
            this.defaultProbeBuilder = this.system.createProbe();
        }
        if ((probeBuilder = this.overwriteWithUserDefinition(this.currentTestClass, testClassInstance)).getTempDir() == null) {
            probeBuilder.setTempDir(this.defaultProbeBuilder.getTempDir());
        }
        return probeBuilder;
    }

    private TestProbeBuilder overwriteWithUserDefinition(Class<?> testClass, Object testInstance) throws ExamConfigurationException {
        Method[] methods;
        for (Method m : methods = testClass.getMethods()) {
            TestProbeBuilder probeBuilder;
            if (!this.isProbeBuilder(m)) continue;
            LOG.debug("User defined probe hook found: " + m.getName());
            try {
                probeBuilder = (TestProbeBuilder)m.invoke(testInstance, this.defaultProbeBuilder);
            }
            catch (Exception e) {
                throw new ExamConfigurationException("Invoking custom probe hook " + m.getName() + " failed", e);
            }
            if (probeBuilder != null) {
                return probeBuilder;
            }
            throw new ExamConfigurationException("Invoking custom probe hook " + m.getName() + " succeeded but returned null");
        }
        LOG.debug("No User defined probe hook found");
        return this.defaultProbeBuilder;
    }

    private boolean isProbeBuilder(Method m) {
        ProbeBuilder builder = m.getAnnotation(ProbeBuilder.class);
        return builder != null || this.annotationHandler.isProbeBuilder(m);
    }

    public String getSystemType() {
        return this.systemType;
    }

    public Object lookupTestMethod(TestAddress address) {
        return this.testAddressToMethodMap.get(address);
    }

    public void storeTestMethod(TestAddress address, Object testMethod) {
        this.testAddressToMethodMap.put(address, testMethod);
    }

    public void beforeSuite(StagedExamReactor stagedReactor) {
        stagedReactor.beforeSuite();
        this.suiteStarted = true;
        this.waitForAfterSuiteEvent = true;
    }

    public void afterSuite(StagedExamReactor stagedReactor) {
        this.waitForAfterSuiteEvent = false;
        stagedReactor.afterSuite();
    }

    public void afterClass(StagedExamReactor stagedReactor, Class<?> klass) {
        stagedReactor.afterClass();
        this.testClasses.remove(klass);
        if (!this.waitForAfterSuiteEvent && this.testClasses.isEmpty()) {
            LOG.info("suite finished");
            stagedReactor.afterSuite();
            this.suiteStarted = false;
            this.testClasses.clear();
            this.testAddressToMethodMap.clear();
        }
    }

    public void beforeClass(StagedExamReactor stagedReactor, Object testClassInstance) {
        if (!this.suiteStarted) {
            this.suiteStarted = true;
            stagedReactor.beforeSuite();
        }
        stagedReactor.beforeClass();
    }

    public void inject(Object test) {
        Injector injector = this.findInjector();
        injector.injectFields(test);
    }

    private Injector findInjector() {
        InjectorFactory injectorFactory = (InjectorFactory)ServiceProviderFinder.loadUniqueServiceProvider(InjectorFactory.class);
        return injectorFactory.createInjector();
    }

    public void setAnnotationHandler(AnnotationHandler annotationHandler) {
        this.annotationHandler = annotationHandler;
    }
}

