/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.analysis.common;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.minhash.MinHashFilterFactory;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractTokenFilterFactory;

public class MinHashTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final MinHashFilterFactory minHashFilterFactory;

    MinHashTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.minHashFilterFactory = new MinHashFilterFactory(this.convertSettings(settings));
    }

    public TokenStream create(TokenStream tokenStream) {
        return this.minHashFilterFactory.create(tokenStream);
    }

    private Map<String, String> convertSettings(Settings settings) {
        HashMap<String, String> settingMap = new HashMap<String, String>();
        settingMap.put("hashCount", settings.get("hash_count"));
        settingMap.put("bucketCount", settings.get("bucket_count"));
        settingMap.put("hashSetSize", settings.get("hash_set_size"));
        settingMap.put("withRotation", settings.get("with_rotation"));
        return settingMap;
    }
}

