/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.analysis.common;

import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.commongrams.CommonGramsFilter;
import org.apache.lucene.analysis.commongrams.CommonGramsQueryFilter;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractTokenFilterFactory;
import org.opensearch.index.analysis.Analysis;
import org.opensearch.index.analysis.TokenFilterFactory;

public class CommonGramsTokenFilterFactory
extends AbstractTokenFilterFactory {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(CommonGramsTokenFilterFactory.class);
    private final CharArraySet words;
    private final boolean ignoreCase;
    private final boolean queryMode;

    CommonGramsTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.ignoreCase = settings.getAsBoolean("ignore_case", Boolean.valueOf(false));
        this.queryMode = settings.getAsBoolean("query_mode", Boolean.valueOf(false));
        this.words = Analysis.parseCommonWords((Environment)env, (Settings)settings, null, (boolean)this.ignoreCase);
        if (this.words == null) {
            throw new IllegalArgumentException("missing or empty [common_words] or [common_words_path] configuration for common_grams token filter");
        }
    }

    public TokenStream create(TokenStream tokenStream) {
        CommonGramsFilter filter = new CommonGramsFilter(tokenStream, this.words);
        if (this.queryMode) {
            return new CommonGramsQueryFilter(filter);
        }
        return filter;
    }

    public TokenFilterFactory getSynonymFilter() {
        if (this.indexSettings.getIndexVersionCreated().onOrAfter((Version)LegacyESVersion.V_7_0_0)) {
            throw new IllegalArgumentException("Token filter [" + this.name() + "] cannot be used to parse synonyms");
        }
        DEPRECATION_LOGGER.deprecate(this.name() + "_synonym_tokenfilters", "Token filter [" + this.name() + "] will not be usable to parse synonyms after v7.0", new Object[0]);
        return this;
    }
}

