/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import lombok.Generated;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.yaml.ReplaceAliasWithAnchorValueVisitor;
import org.openrewrite.yaml.internal.grammar.JsonPathLexer;
import org.openrewrite.yaml.internal.grammar.JsonPathParser;
import org.openrewrite.yaml.internal.grammar.JsonPathParserBaseVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class JsonPathMatcher {
    private final String jsonPath;
    private @Nullable JsonPathParser.JsonPathContext parsed;

    public JsonPathMatcher(String jsonPath) {
        this.jsonPath = jsonPath;
    }

    public <T> Optional<T> find(Cursor cursor) {
        return this.find0(cursor, JsonPathMatcher.resolvedAncestors(cursor));
    }

    private <T> Optional<T> find0(Cursor cursor, List<Tree> cursorPath) {
        if (cursorPath.isEmpty()) {
            return Optional.empty();
        }
        Tree start = this.jsonPath.startsWith(".") && !this.jsonPath.startsWith("..") ? (Tree)cursor.getValue() : cursorPath.get(0);
        JsonPathParser.JsonPathContext ctx = this.parse();
        JsonPathParser.ExpressionContext stop = (JsonPathParser.ExpressionContext)((Object)ctx.children.get(ctx.children.size() - 1));
        JsonPathYamlVisitor v = new JsonPathYamlVisitor(cursorPath, start, stop, false);
        Object result = v.visit((ParseTree)ctx);
        return Optional.ofNullable(result);
    }

    public boolean matches(Cursor cursor) {
        List<Tree> cursorPath = JsonPathMatcher.resolvedAncestors(cursor);
        Tree cursorValue = cursorPath.get(cursorPath.size() - 1);
        return this.find0(cursor, cursorPath).map(o -> {
            if (o instanceof List) {
                List l = (List)o;
                return !Collections.disjoint(l, cursorPath) && l.contains(cursorValue);
            }
            return Objects.equals(o, cursorValue);
        }).orElse(false);
    }

    private static List<Tree> resolvedAncestors(Cursor cursor) {
        ArrayDeque<Tree> deque = new ArrayDeque<Tree>();
        final IdentityHashMap resolved = new IdentityHashMap();
        Iterator it = cursor.getPath(Tree.class::isInstance);
        while (it.hasNext()) {
            Tree tree = (Tree)it.next();
            if (tree instanceof Yaml.Document) {
                tree = new ReplaceAliasWithAnchorValueVisitor<Integer>(){

                    public @Nullable Yaml visit(@Nullable Tree tree, Integer p) {
                        if (tree instanceof Yaml) {
                            Yaml updated = ((Yaml)tree).acceptYaml(this, p);
                            if (updated != tree) {
                                resolved.put(tree, updated);
                            }
                            return updated;
                        }
                        return (Yaml)tree;
                    }
                }.visitNonNull(tree, 0);
                deque.addFirst(tree);
                break;
            }
            deque.addFirst(tree);
        }
        ArrayList<Tree> list = new ArrayList<Tree>(deque);
        if (!resolved.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Tree tree = list.get(i);
                if (!resolved.containsKey(tree)) continue;
                list.set(i, (Tree)resolved.get(tree));
            }
        }
        return list;
    }

    private JsonPathParser.JsonPathContext parse() {
        if (this.parsed == null) {
            this.parsed = this.jsonPath().jsonPath();
        }
        return this.parsed;
    }

    private JsonPathParser jsonPath() {
        return new JsonPathParser((TokenStream)new CommonTokenStream((TokenSource)new JsonPathLexer((CharStream)CharStreams.fromString((String)this.jsonPath))));
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonPathMatcher)) {
            return false;
        }
        JsonPathMatcher other = (JsonPathMatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$jsonPath = this.jsonPath;
        String other$jsonPath = other.jsonPath;
        if (this$jsonPath == null ? other$jsonPath != null : !this$jsonPath.equals(other$jsonPath)) {
            return false;
        }
        JsonPathParser.JsonPathContext this$parsed = this.parsed;
        JsonPathParser.JsonPathContext other$parsed = other.parsed;
        return !(this$parsed == null ? other$parsed != null : !((Object)((Object)this$parsed)).equals((Object)other$parsed));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof JsonPathMatcher;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $jsonPath = this.jsonPath;
        result = result * 59 + ($jsonPath == null ? 43 : $jsonPath.hashCode());
        JsonPathParser.JsonPathContext $parsed = this.parsed;
        result = result * 59 + ($parsed == null ? 43 : ((Object)((Object)$parsed)).hashCode());
        return result;
    }

    private static class JsonPathYamlVisitor
    extends JsonPathParserBaseVisitor<Object> {
        private final List<Tree> cursorPath;
        protected Object scope;
        private final JsonPathParser.ExpressionContext stop;
        private final boolean isRecursiveDescent;

        public JsonPathYamlVisitor(List<Tree> cursorPath, Object scope, JsonPathParser.ExpressionContext stop, boolean isRecursiveDescent) {
            this.cursorPath = cursorPath;
            this.scope = scope;
            this.stop = stop;
            this.isRecursiveDescent = isRecursiveDescent;
        }

        protected Object defaultResult() {
            return this.scope;
        }

        protected Object aggregateResult(Object aggregate, Object nextResult) {
            this.scope = nextResult;
            return this.scope;
        }

        protected boolean shouldVisitNextChild(RuleNode node, Object currentResult) {
            return this.scope != null;
        }

        @Override
        public Object visitJsonPath(JsonPathParser.JsonPathContext ctx) {
            block4: {
                if (ctx.ROOT() != null || ctx.start.getType() == 6) {
                    Tree first = this.cursorPath.get(0);
                    if (first instanceof Yaml.Document) {
                        this.scope = ((Yaml.Document)first).getBlock();
                    } else {
                        for (Tree tree : this.cursorPath) {
                            if (!(tree instanceof Yaml.Mapping)) continue;
                            this.scope = tree;
                            break block4;
                        }
                        this.scope = null;
                    }
                }
            }
            return super.visitJsonPath(ctx);
        }

        private JsonPathParser.ExpressionContext getExpressionContext(ParserRuleContext ctx) {
            if (ctx == null || ctx instanceof JsonPathParser.ExpressionContext) {
                return (JsonPathParser.ExpressionContext)ctx;
            }
            return this.getExpressionContext(ctx.getParent());
        }

        @Override
        public @Nullable Object visitRecursiveDecent(JsonPathParser.RecursiveDecentContext ctx) {
            if (this.scope == null) {
                return null;
            }
            Object result = null;
            List previous = ctx.getParent().getParent().children;
            ParserRuleContext current = ctx.getParent();
            if (previous.indexOf(current) - 1 < 0 || "$".equals(((ParseTree)previous.get(previous.indexOf(current) - 1)).getText())) {
                ArrayList<Object> results = new ArrayList<Object>();
                for (Tree path : this.cursorPath) {
                    JsonPathYamlVisitor v = new JsonPathYamlVisitor(this.cursorPath, path, null, false);
                    for (int i = 1; i < ctx.getChildCount(); ++i) {
                        result = v.visit(ctx.getChild(i));
                        if (result == null) continue;
                        results.add(result);
                    }
                }
                return results;
            }
            JsonPathYamlVisitor v = new JsonPathYamlVisitor(this.cursorPath, this.scope, null, true);
            for (int i = 1; i < ctx.getChildCount() && (result = v.visit(ctx.getChild(i))) == null; ++i) {
            }
            return result;
        }

        @Override
        public @Nullable Object visitBracketOperator(JsonPathParser.BracketOperatorContext ctx) {
            if (!ctx.property().isEmpty()) {
                if (ctx.property().size() == 1) {
                    return this.visitProperty(ctx.property(0));
                }
                ArrayList<Object> list = new ArrayList<Object>();
                for (JsonPathParser.PropertyContext propertyContext : ctx.property()) {
                    list.add(this.visitProperty(propertyContext));
                }
                return list;
            }
            if (ctx.slice() != null) {
                return this.visitSlice(ctx.slice());
            }
            if (ctx.indexes() != null) {
                return this.visitIndexes(ctx.indexes());
            }
            if (ctx.filter() != null) {
                return this.visitFilter(ctx.filter());
            }
            return null;
        }

        @Override
        public Object visitSlice(JsonPathParser.SliceContext ctx) {
            ArrayList<Object> results;
            if (this.scope instanceof List) {
                results = (ArrayList)this.scope;
            } else if (this.scope instanceof Yaml.Sequence) {
                Yaml.Sequence array = (Yaml.Sequence)this.scope;
                results = new ArrayList<Yaml.Sequence.Entry>(array.getEntries());
            } else {
                if (this.scope instanceof Yaml.Mapping.Entry) {
                    this.scope = ((Yaml.Mapping.Entry)this.scope).getValue();
                    return this.visitSlice(ctx);
                }
                results = new ArrayList();
            }
            int start = 0;
            int limit = results.size();
            if (ctx.PositiveNumber() != null) {
                limit = Integer.parseInt(ctx.PositiveNumber().getText());
            } else if (ctx.NegativeNumber() != null) {
                start = results.size() + Integer.parseInt(ctx.NegativeNumber().getText());
            } else if (ctx.start() != null) {
                start = ctx.start() != null ? Integer.parseInt(ctx.start().getText()) : 0;
                limit = ctx.end() != null ? Integer.parseInt(ctx.end().getText()) + 1 : limit;
            }
            return results.subList(start, Math.min(start + limit, results.size()));
        }

        @Override
        public Object visitIndexes(JsonPathParser.IndexesContext ctx) {
            ArrayList<Object> results;
            if (this.scope instanceof List) {
                results = (ArrayList)this.scope;
            } else if (this.scope instanceof Yaml.Sequence) {
                Yaml.Sequence array = (Yaml.Sequence)this.scope;
                results = new ArrayList<Yaml.Sequence.Entry>(array.getEntries());
            } else {
                if (this.scope instanceof Yaml.Mapping.Entry) {
                    this.scope = ((Yaml.Mapping.Entry)this.scope).getValue();
                    return this.visitIndexes(ctx);
                }
                results = new ArrayList();
            }
            ArrayList indexes = new ArrayList();
            for (TerminalNode terminalNode : ctx.PositiveNumber()) {
                for (int i = 0; i < results.size(); ++i) {
                    if (!terminalNode.getText().contains(String.valueOf(i))) continue;
                    indexes.add(results.get(i));
                }
            }
            return this.getResultFromList(indexes);
        }

        @Override
        public @Nullable Object visitProperty(JsonPathParser.PropertyContext ctx) {
            if (this.scope instanceof Yaml.Mapping) {
                Yaml.Mapping mapping = (Yaml.Mapping)this.scope;
                if (this.isRecursiveDescent) {
                    this.scope = mapping.getEntries();
                    Object result = this.getResultFromList(this.visitProperty(ctx));
                    return this.getResultFromList(result);
                }
                for (Yaml.Mapping.Entry entry : mapping.getEntries()) {
                    String name;
                    String key;
                    if (!(entry instanceof Yaml.Mapping.Entry) || !(key = entry.getKey().getValue()).equals(name = ctx.StringLiteral() != null ? JsonPathYamlVisitor.unquoteStringLiteral(ctx.StringLiteral().getText()) : ctx.Identifier().getText())) continue;
                    return entry;
                }
            } else {
                if (this.scope instanceof Yaml.Mapping.Entry) {
                    String name;
                    Yaml.Mapping.Entry member = (Yaml.Mapping.Entry)this.scope;
                    ArrayList<Object> matches = new ArrayList<Object>();
                    String key = member.getKey().getValue();
                    String string = name = ctx.StringLiteral() != null ? JsonPathYamlVisitor.unquoteStringLiteral(ctx.StringLiteral().getText()) : ctx.Identifier().getText();
                    if (this.isRecursiveDescent) {
                        if (key.equals(name)) {
                            matches.add(member);
                        }
                        if (!(member.getValue() instanceof Yaml.Scalar)) {
                            this.scope = member.getValue();
                            Object result = this.getResultFromList(this.visitProperty(ctx));
                            if (result != null) {
                                matches.add(result);
                            }
                        }
                        return this.getResultFromList(matches);
                    }
                    if (member.getValue() instanceof Yaml.Scalar) {
                        return key.equals(name) ? member : null;
                    }
                    this.scope = member.getValue();
                    return this.visitProperty(ctx);
                }
                if (this.scope instanceof Yaml.Sequence) {
                    ArrayList<Object> matches = new ArrayList<Object>();
                    for (Yaml.Sequence.Entry entry : ((Yaml.Sequence)this.scope).getEntries()) {
                        this.scope = entry;
                        Object result = this.visitProperty(ctx);
                        if (result == null) continue;
                        matches.add(result);
                    }
                    return this.getResultFromList(matches);
                }
                if (this.scope instanceof Yaml.Sequence.Entry) {
                    Yaml.Sequence.Entry entry = (Yaml.Sequence.Entry)this.scope;
                    this.scope = entry.getBlock();
                    return this.visitProperty(ctx);
                }
                if (this.scope instanceof List) {
                    ArrayList<Object> matches = new ArrayList<Object>();
                    for (Object object : (List)this.scope) {
                        this.scope = object;
                        Object result = this.visitProperty(ctx);
                        if (result instanceof List) {
                            matches.addAll((List)result);
                            continue;
                        }
                        if (result == null) continue;
                        matches.add(result);
                    }
                    return this.getResultFromList(matches);
                }
            }
            return null;
        }

        @Override
        public @Nullable Object visitWildcard(JsonPathParser.WildcardContext ctx) {
            if (this.scope instanceof Yaml.Mapping) {
                Yaml.Mapping mapping = (Yaml.Mapping)this.scope;
                return mapping.getEntries();
            }
            if (this.scope instanceof Yaml.Mapping.Entry) {
                Yaml.Mapping.Entry member = (Yaml.Mapping.Entry)this.scope;
                return member.getValue();
            }
            if (this.scope instanceof Yaml.Sequence) {
                ArrayList<Object> matches = new ArrayList<Object>();
                for (Yaml.Sequence.Entry entry : ((Yaml.Sequence)this.scope).getEntries()) {
                    this.scope = entry;
                    Object result = this.visitWildcard(ctx);
                    if (result == null) continue;
                    matches.add(result);
                }
                return this.getResultFromList(matches);
            }
            if (this.scope instanceof Yaml.Sequence.Entry) {
                Yaml.Sequence.Entry entry = (Yaml.Sequence.Entry)this.scope;
                return entry.getBlock();
            }
            if (this.scope instanceof List) {
                ArrayList<Object> results = new ArrayList<Object>();
                for (Object object : (List)this.scope) {
                    this.scope = object;
                    Object result = this.visitWildcard(ctx);
                    if (result == null) continue;
                    results.add(result);
                }
                ArrayList<Object> matches = new ArrayList<Object>();
                if (this.stop != null && this.stop == this.getExpressionContext(ctx)) {
                    results.forEach(o -> matches.add(this.getValue(o)));
                } else {
                    for (Object result : results) {
                        if (result instanceof List) {
                            matches.addAll((List)result);
                            continue;
                        }
                        if (result == null) continue;
                        matches.add(result);
                    }
                }
                return this.getResultFromList(matches);
            }
            return null;
        }

        @Override
        public Object visitLiteralExpression(JsonPathParser.LiteralExpressionContext ctx) {
            String s = null;
            if (ctx.StringLiteral() != null) {
                s = ctx.StringLiteral().getText();
            } else if (!ctx.children.isEmpty()) {
                s = ((ParseTree)ctx.children.get(0)).getText();
            }
            if (s != null && (s.startsWith("'") || s.startsWith("\""))) {
                return s.substring(1, s.length() - 1);
            }
            return "null".equals(s) ? null : s;
        }

        @Override
        public @Nullable Object visitUnaryExpression(JsonPathParser.UnaryExpressionContext ctx) {
            if (ctx.AT() != null) {
                if (this.scope instanceof Yaml.Scalar) {
                    if (ctx.Identifier() == null && ctx.StringLiteral() == null) {
                        return this.scope;
                    }
                } else {
                    if (this.scope instanceof Yaml.Mapping) {
                        this.scope = ((Yaml.Mapping)this.scope).getEntries();
                        return this.visitUnaryExpression(ctx);
                    }
                    if (this.scope instanceof Yaml.Mapping.Entry) {
                        Yaml.Mapping.Entry entry = (Yaml.Mapping.Entry)this.scope;
                        if (ctx.Identifier() != null || ctx.StringLiteral() != null) {
                            String name;
                            String key = entry.getKey().getValue();
                            String string = name = ctx.StringLiteral() != null ? JsonPathYamlVisitor.unquoteStringLiteral(ctx.StringLiteral().getText()) : ctx.Identifier().getText();
                            if (key.equals(name)) {
                                return entry;
                            }
                        }
                        this.scope = entry.getValue();
                        return this.getResultFromList(this.visitUnaryExpression(ctx));
                    }
                    if (this.scope instanceof Yaml.Sequence) {
                        this.scope = ((Yaml.Sequence)this.scope).getEntries();
                        return this.visitUnaryExpression(ctx);
                    }
                    if (this.scope instanceof Yaml.Sequence.Entry) {
                        Yaml.Sequence.Entry entry = (Yaml.Sequence.Entry)this.scope;
                        this.scope = entry.getBlock();
                        Object result = this.visitUnaryExpression(ctx);
                        if (result != null) {
                            return this.getResultFromList(entry.getBlock());
                        }
                    } else if (this.scope instanceof List) {
                        ArrayList<Object> matches = new ArrayList<Object>();
                        for (Object object : (List)this.scope) {
                            this.scope = object;
                            Object result = this.visitUnaryExpression(ctx);
                            if (result instanceof List) {
                                matches.addAll((List)result);
                                continue;
                            }
                            if (result == null) continue;
                            matches.add(result);
                        }
                        return this.getResultFromList(matches);
                    }
                }
            } else if (ctx.jsonPath() != null) {
                Object result = this.visit((ParseTree)ctx.jsonPath());
                return this.getResultByKey(result, ctx.stop.getText());
            }
            return null;
        }

        @Override
        public @Nullable Object visitRegexExpression(JsonPathParser.RegexExpressionContext ctx) {
            if (this.scope == null || this.scope instanceof List && ((List)this.scope).isEmpty()) {
                return null;
            }
            String rhs = ctx.REGEX().getText();
            Object lhs = this.visitUnaryExpression(ctx.unaryExpression());
            String operator = "=~";
            if (lhs instanceof List) {
                ArrayList<Yaml> matches = new ArrayList<Yaml>();
                for (Object match : (List)lhs) {
                    Yaml mappingOrEntry = this.getOperatorResult(match, operator, rhs);
                    if (mappingOrEntry == null) continue;
                    matches.add(mappingOrEntry);
                }
                return matches;
            }
            return this.getOperatorResult(lhs, operator, rhs);
        }

        @Override
        public @Nullable Object visitContainsExpression(JsonPathParser.ContainsExpressionContext ctx) {
            Object originalScope = this.scope;
            if (ctx.children.get(0) instanceof JsonPathParser.UnaryExpressionContext) {
                Object lhs = this.visitUnaryExpression(ctx.unaryExpression());
                Object rhs = this.visitLiteralExpression(ctx.literalExpression());
                if (lhs instanceof List) {
                    String key = ((ParseTree)ctx.children.get(0)).getChild(2).getText();
                    lhs = this.getResultByKey(lhs, key);
                }
                if (lhs instanceof Yaml.Mapping.Entry && rhs != null) {
                    Yaml.Scalar scalar;
                    Yaml.Mapping.Entry entry = (Yaml.Mapping.Entry)lhs;
                    if (entry.getValue() instanceof Yaml.Sequence) {
                        Yaml.Sequence sequence = (Yaml.Sequence)entry.getValue();
                        for (Yaml.Sequence.Entry o : sequence.getEntries()) {
                            Yaml.Scalar block;
                            if (!(o.getBlock() instanceof Yaml.Scalar) || !(block = (Yaml.Scalar)o.getBlock()).getValue().contains(String.valueOf(rhs))) continue;
                            return originalScope;
                        }
                    } else if (entry.getValue() instanceof Yaml.Scalar && (scalar = (Yaml.Scalar)entry.getValue()).getValue().contains(String.valueOf(rhs))) {
                        return originalScope;
                    }
                }
            } else {
                Yaml.Scalar scalar;
                Yaml.Mapping.Entry entry;
                Object lhs = this.visitLiteralExpression(ctx.literalExpression());
                Object rhs = this.visitUnaryExpression(ctx.unaryExpression());
                if (rhs instanceof List) {
                    String key = ((ParseTree)ctx.children.get(2)).getChild(2).getText();
                    rhs = this.getResultByKey(rhs, key);
                }
                if (rhs instanceof Yaml.Mapping.Entry && lhs != null && (entry = (Yaml.Mapping.Entry)rhs).getValue() instanceof Yaml.Scalar && (scalar = (Yaml.Scalar)entry.getValue()).getValue().contains(String.valueOf(lhs))) {
                    return originalScope;
                }
            }
            return null;
        }

        @Override
        public @Nullable Object visitBinaryExpression(JsonPathParser.BinaryExpressionContext ctx) {
            Object lhs = ctx.children.get(0);
            Object rhs = ctx.children.get(2);
            if (ctx.LOGICAL_OPERATOR() != null) {
                String operator;
                switch (ctx.LOGICAL_OPERATOR().getText()) {
                    case "&&": {
                        operator = "&&";
                        break;
                    }
                    case "||": {
                        operator = "||";
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                Object scopeOfLogicalOp = this.scope;
                lhs = this.getBinaryExpressionResult(lhs);
                this.scope = scopeOfLogicalOp;
                rhs = this.getBinaryExpressionResult(rhs);
                if (!(!"&&".equals(operator) || lhs == null || lhs instanceof List && ((List)lhs).isEmpty() || rhs == null || rhs instanceof List && ((List)rhs).isEmpty())) {
                    if (lhs instanceof Yaml) {
                        return rhs;
                    }
                    if (rhs instanceof Yaml) {
                        return lhs;
                    }
                    if (lhs instanceof List && rhs instanceof List && ((List)lhs).size() != ((List)rhs).size()) {
                        return ((List)lhs).size() < ((List)rhs).size() ? lhs : rhs;
                    }
                    return scopeOfLogicalOp;
                }
                if (!(!"||".equals(operator) || (lhs == null || lhs instanceof List && ((List)lhs).isEmpty()) && (rhs == null || rhs instanceof List && ((List)rhs).isEmpty()))) {
                    return scopeOfLogicalOp;
                }
            } else if (ctx.EQUALITY_OPERATOR() != null) {
                String operator;
                Object originalScope = this.scope;
                lhs = this.getBinaryExpressionResult(lhs);
                rhs = this.getBinaryExpressionResult(rhs);
                switch (ctx.EQUALITY_OPERATOR().getText()) {
                    case "==": {
                        operator = "==";
                        break;
                    }
                    case "!=": {
                        operator = "!=";
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (lhs instanceof List) {
                    ArrayList<Yaml> matches = new ArrayList<Yaml>();
                    for (Object match : (List)lhs) {
                        Yaml result = this.getOperatorResult(match, operator, rhs);
                        if (result == null) continue;
                        matches.add(result);
                    }
                    if (originalScope instanceof Yaml.Mapping.Entry && ((Yaml.Mapping.Entry)originalScope).getValue() instanceof Yaml.Mapping) {
                        return originalScope;
                    }
                    return matches;
                }
                if (originalScope instanceof Yaml.Mapping.Entry) {
                    if (this.getOperatorResult(lhs, operator, rhs) != null) {
                        return originalScope;
                    }
                } else {
                    return this.getOperatorResult(lhs, operator, rhs);
                }
            }
            return null;
        }

        private @Nullable Object getBinaryExpressionResult(Object ctx) {
            if (ctx instanceof JsonPathParser.BinaryExpressionContext) {
                ctx = this.visitBinaryExpression((JsonPathParser.BinaryExpressionContext)((Object)ctx));
            } else if (ctx instanceof JsonPathParser.RegexExpressionContext) {
                ctx = this.visitRegexExpression((JsonPathParser.RegexExpressionContext)((Object)ctx));
            } else if (ctx instanceof JsonPathParser.ContainsExpressionContext) {
                ctx = this.visitContainsExpression((JsonPathParser.ContainsExpressionContext)((Object)ctx));
            } else if (ctx instanceof JsonPathParser.UnaryExpressionContext) {
                ctx = this.visitUnaryExpression((JsonPathParser.UnaryExpressionContext)((Object)ctx));
            } else if (ctx instanceof JsonPathParser.LiteralExpressionContext) {
                ctx = this.visitLiteralExpression((JsonPathParser.LiteralExpressionContext)((Object)ctx));
            }
            return ctx;
        }

        private @Nullable Yaml getOperatorResult(Object lhs, String operator, Object rhs) {
            Yaml.Scalar scalar;
            if (lhs instanceof Yaml.Mapping) {
                Yaml.Mapping mapping = (Yaml.Mapping)lhs;
                for (Yaml.Mapping.Entry entry : mapping.getEntries()) {
                    if (!(entry.getValue() instanceof Yaml.Scalar) || !this.checkObjectEquality(((Yaml.Scalar)entry.getValue()).getValue(), operator, rhs)) continue;
                    return mapping;
                }
            } else if (lhs instanceof Yaml.Mapping.Entry) {
                Yaml.Mapping.Entry entry = (Yaml.Mapping.Entry)lhs;
                if (entry.getValue() instanceof Yaml.Scalar && this.checkObjectEquality(((Yaml.Scalar)entry.getValue()).getValue(), operator, rhs)) {
                    return entry;
                }
            } else if (lhs instanceof Yaml.Scalar && this.checkObjectEquality((scalar = (Yaml.Scalar)lhs).getValue(), operator, rhs)) {
                return scalar;
            }
            return null;
        }

        private boolean checkObjectEquality(Object lhs, String operator, Object rhs) {
            if (lhs == null || rhs == null) {
                return false;
            }
            BiPredicate<Object, Object> predicate = (lh, rh) -> {
                switch (operator) {
                    case "==": {
                        return Objects.equals(lh, rh);
                    }
                    case "!=": {
                        return !Objects.equals(lh, rh);
                    }
                    case "=~": {
                        return Pattern.compile(rh.toString()).matcher(lh.toString()).matches();
                    }
                }
                return false;
            };
            return predicate.test(lhs, rhs);
        }

        public @Nullable Object getResultByKey(Object result, String key) {
            if (result instanceof Yaml.Mapping.Entry) {
                Yaml.Mapping.Entry member = (Yaml.Mapping.Entry)result;
                if (member.getValue() instanceof Yaml.Scalar) {
                    return member.getKey().getValue().equals(key) ? member : null;
                }
            } else if (result instanceof List) {
                for (Object o : (List)result) {
                    Object r = this.getResultByKey(o, key);
                    if (r == null) continue;
                    return r;
                }
            }
            return null;
        }

        private Object getResultFromList(Object results) {
            if (results instanceof List) {
                List matches = (List)results;
                if (matches.isEmpty()) {
                    return null;
                }
                if (matches.size() == 1) {
                    return matches.get(0);
                }
            }
            return results;
        }

        private @Nullable Object getValue(Object result) {
            if (result instanceof Yaml.Mapping.Entry) {
                return this.getValue(((Yaml.Mapping.Entry)result).getValue());
            }
            if (result instanceof Yaml.Mapping) {
                return ((Yaml.Mapping)result).getEntries();
            }
            if (result instanceof List) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (Object o : (List)result) {
                    Object value = this.getValue(o);
                    if (value == null) continue;
                    list.add(value);
                }
                return list;
            }
            if (result instanceof Yaml.Sequence) {
                return ((Yaml.Sequence)result).getEntries();
            }
            if (result instanceof Yaml.Scalar) {
                return ((Yaml.Scalar)result).getValue();
            }
            if (result instanceof String) {
                return result;
            }
            return null;
        }

        private static String unquoteStringLiteral(String literal) {
            if (literal != null && (literal.startsWith("'") || literal.startsWith("\""))) {
                return literal.substring(1, literal.length() - 1);
            }
            return "null".equals(literal) ? null : literal;
        }
    }
}

