/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.util.Collections;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.AlreadyReplaced;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ChangeTagValue
extends Recipe {
    @Option(displayName="Element name", description="The name of the element whose value is to be changed. Interpreted as an XPath Expression.", example="/settings/servers/server/username")
    private final String elementName;
    @Option(displayName="Old value", description="The old value of the tag. Interpreted as pattern if regex is enabled.", required=false, example="user")
    private final @Nullable String oldValue;
    @Option(displayName="New value", description="The new value for the tag. Supports capture groups when regex is enabled. If literal $,\\ characters are needed in newValue, with regex true, then it should be escaped.", example="user")
    private final String newValue;
    @Option(displayName="Regex", description="Default false. If true, `oldValue` will be interpreted as a [Regular Expression](https://en.wikipedia.org/wiki/Regular_expression), and capture group contents will be available in `newValue`.", required=false)
    private final @Nullable Boolean regex;

    public String getDisplayName() {
        return "Change XML tag value";
    }

    public String getDescription() {
        return "Alters the value of XML tags matching the provided expression. When regex is enabled the replacement happens only for text nodes provided the pattern matches.";
    }

    public Validated<Object> validate(ExecutionContext ctx) {
        return super.validate(ctx).and(Validated.test((String)"regex", (String)"Regex usage requires an `oldValue`", (Object)this.regex, value -> value == null || this.oldValue != null && !this.oldValue.equals(this.newValue)));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new XmlVisitor<ExecutionContext>(){
            private final XPathMatcher xPathMatcher;
            {
                this.xPathMatcher = new XPathMatcher(ChangeTagValue.this.elementName);
            }

            @Override
            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.xPathMatcher.matches(this.getCursor())) {
                    if (Boolean.TRUE.equals(ChangeTagValue.this.regex) && ChangeTagValue.this.oldValue != null) {
                        this.doAfterVisit(new RegexReplaceVisitor(tag, ChangeTagValue.this.oldValue, ChangeTagValue.this.newValue));
                    } else if (ChangeTagValue.this.oldValue == null || ChangeTagValue.this.oldValue.equals(tag.getValue().orElse(null))) {
                        this.doAfterVisit(new ChangeTagValueVisitor(tag, ChangeTagValue.this.newValue));
                    }
                }
                return super.visitTag(tag, ctx);
            }
        };
    }

    @Generated
    public ChangeTagValue(String elementName, @Nullable String oldValue, String newValue, @Nullable Boolean regex) {
        this.elementName = elementName;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.regex = regex;
    }

    @Generated
    public String getElementName() {
        return this.elementName;
    }

    @Generated
    public @Nullable String getOldValue() {
        return this.oldValue;
    }

    @Generated
    public String getNewValue() {
        return this.newValue;
    }

    @Generated
    public @Nullable Boolean getRegex() {
        return this.regex;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeTagValue(elementName=" + this.getElementName() + ", oldValue=" + this.getOldValue() + ", newValue=" + this.getNewValue() + ", regex=" + this.getRegex() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeTagValue)) {
            return false;
        }
        ChangeTagValue other = (ChangeTagValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$regex = this.getRegex();
        Boolean other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !((Object)this$regex).equals(other$regex)) {
            return false;
        }
        String this$elementName = this.getElementName();
        String other$elementName = other.getElementName();
        if (this$elementName == null ? other$elementName != null : !this$elementName.equals(other$elementName)) {
            return false;
        }
        String this$oldValue = this.getOldValue();
        String other$oldValue = other.getOldValue();
        if (this$oldValue == null ? other$oldValue != null : !this$oldValue.equals(other$oldValue)) {
            return false;
        }
        String this$newValue = this.getNewValue();
        String other$newValue = other.getNewValue();
        return !(this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangeTagValue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : ((Object)$regex).hashCode());
        String $elementName = this.getElementName();
        result = result * 59 + ($elementName == null ? 43 : $elementName.hashCode());
        String $oldValue = this.getOldValue();
        result = result * 59 + ($oldValue == null ? 43 : $oldValue.hashCode());
        String $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        return result;
    }

    static final class RegexReplaceVisitor<P>
    extends XmlVisitor<P> {
        private final Xml.Tag scope;
        private final String oldValue;
        private final String newValue;

        @Override
        public Xml visitTag(Xml.Tag tag, P p) {
            Xml.Tag t = (Xml.Tag)super.visitTag(tag, p);
            if (this.scope.isScope(t) && t.getContent() != null && t.getContent().size() == 1 && t.getContent().get(0) instanceof Xml.CharData) {
                return this.updateUsingRegex(t, (Xml.CharData)t.getContent().get(0));
            }
            return t;
        }

        private Xml.Tag updateUsingRegex(Xml.Tag t, Xml.CharData content) {
            Markers oldMarkers;
            String text = content.getText();
            if (Pattern.compile(this.oldValue).matcher(text).find() && (oldMarkers = content.getMarkers()).findAll(AlreadyReplaced.class).stream().noneMatch(m -> m.getFind().equals(this.oldValue) && this.newValue.equals(m.getReplace()))) {
                return t.withContent(Collections.singletonList(content.withText(text.replaceAll(this.oldValue, this.newValue)).withMarkers(oldMarkers.add((Marker)new AlreadyReplaced(Tree.randomId(), this.oldValue, this.newValue)))));
            }
            return t;
        }

        @Generated
        public RegexReplaceVisitor(Xml.Tag scope, String oldValue, String newValue) {
            this.scope = scope;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Generated
        public Xml.Tag getScope() {
            return this.scope;
        }

        @Generated
        public String getOldValue() {
            return this.oldValue;
        }

        @Generated
        public String getNewValue() {
            return this.newValue;
        }

        @NonNull
        @Generated
        public String toString() {
            return "ChangeTagValue.RegexReplaceVisitor(scope=" + this.getScope() + ", oldValue=" + this.getOldValue() + ", newValue=" + this.getNewValue() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RegexReplaceVisitor)) {
                return false;
            }
            RegexReplaceVisitor other = (RegexReplaceVisitor)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            Xml.Tag this$scope = this.getScope();
            Xml.Tag other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope)) {
                return false;
            }
            String this$oldValue = this.getOldValue();
            String other$oldValue = other.getOldValue();
            if (this$oldValue == null ? other$oldValue != null : !this$oldValue.equals(other$oldValue)) {
                return false;
            }
            String this$newValue = this.getNewValue();
            String other$newValue = other.getNewValue();
            return !(this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof RegexReplaceVisitor;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Xml.Tag $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
            String $oldValue = this.getOldValue();
            result = result * 59 + ($oldValue == null ? 43 : $oldValue.hashCode());
            String $newValue = this.getNewValue();
            result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
            return result;
        }
    }
}

