/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.table.MavenRepositoryOrder;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.xml.tree.Xml;

public class FindRepositoryOrder
extends Recipe {
    transient MavenRepositoryOrder repositoryOrder = new MavenRepositoryOrder(this);

    public String getDisplayName() {
        return "Maven repository order";
    }

    public String getDescription() {
        return "Determine the order in which dependencies will be resolved for each `pom.xml` based on its defined repositories and effective `settings.xml`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                MavenResolutionResult mrr = this.getResolutionResult();
                LinkedHashMap<String, MavenRepository> repositories = new LinkedHashMap<String, MavenRepository>();
                for (MavenRepository repository : mrr.getPom().getRepositories()) {
                    repositories.put(repository.getUri(), repository);
                }
                for (MavenRepository repository : MavenExecutionContextView.view(ctx).getRepositories(mrr.getMavenSettings(), StreamSupport.stream(mrr.getPom().getActiveProfiles().spliterator(), false).collect(Collectors.toList()))) {
                    repositories.put(repository.getUri(), repository);
                }
                int i = 0;
                for (MavenRepository repository : repositories.values()) {
                    FindRepositoryOrder.this.repositoryOrder.insertRow(ctx, new MavenRepositoryOrder.Row(repository.getId(), repository.getUri(), repository.isKnownToExist(), i++));
                }
                return (Xml.Document)SearchResult.found((Tree)document, (String)repositories.values().stream().map(MavenRepository::getUri).collect(Collectors.joining("\n")));
            }
        };
    }
}

