/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.Plugin;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.semver.ExactVersion;
import org.openrewrite.semver.LatestIntegration;
import org.openrewrite.semver.Semver;
import org.openrewrite.xml.tree.Xml;

public final class RemoveRedundantDependencyVersions
extends Recipe {
    @Option(displayName="Group", description="Group glob expression pattern used to match dependencies that should be managed.Group is the first part of a dependency coordinate `com.google.guava:guava:VERSION`.", example="com.google.*", required=false)
    private final @Nullable String groupPattern;
    @Option(displayName="Artifact", description="Artifact glob expression pattern used to match dependencies that should be managed.Artifact is the second part of a dependency coordinate `com.google.guava:guava:VERSION`.", example="guava*", required=false)
    private final @Nullable String artifactPattern;
    @Option(displayName="Only if versions match", description="Deprecated; use `onlyIfManagedVersionIs` instead. Only remove the explicit version if it exactly matches the managed dependency version. When `false` explicit versions will be removed if they are older than or equal to the managed dependency version. Default `true`.", required=false)
    @Deprecated
    private final @Nullable Boolean onlyIfVersionsMatch;
    @Option(displayName="Only if managed version is ...", description="Only remove the explicit version if the managed version has the specified comparative relationship to the explicit version. For example, `gte` will only remove the explicit version if the managed version is the same or newer. Default `eq`.", valid={"ANY", "EQ", "LT", "LTE", "GT", "GTE"}, required=false)
    private final @Nullable Comparator onlyIfManagedVersionIs;
    @Option(displayName="Except", description="Accepts a list of GAVs. Dependencies matching a GAV will be ignored by this recipe. GAV versions are ignored if provided.", example="com.jcraft:jsch", required=false)
    private final @Nullable List<String> except;

    @Deprecated
    public RemoveRedundantDependencyVersions(@Nullable String groupPattern, @Nullable String artifactPattern, @Nullable Boolean onlyIfVersionsMatch, @Nullable List<String> except) {
        this(groupPattern, artifactPattern, onlyIfVersionsMatch, null, except);
    }

    public RemoveRedundantDependencyVersions(@Nullable String groupPattern, @Nullable String artifactPattern, @Nullable Comparator onlyIfManagedVersionIs, @Nullable List<String> except) {
        this(groupPattern, artifactPattern, null, onlyIfManagedVersionIs, except);
    }

    @JsonCreator
    @Deprecated
    public RemoveRedundantDependencyVersions(@Nullable String groupPattern, @Nullable String artifactPattern, @Nullable Boolean onlyIfVersionsMatch, @Nullable Comparator onlyIfManagedVersionIs, @Nullable List<String> except) {
        this.groupPattern = groupPattern;
        this.artifactPattern = artifactPattern;
        this.onlyIfVersionsMatch = onlyIfVersionsMatch;
        this.onlyIfManagedVersionIs = onlyIfManagedVersionIs;
        this.except = except;
    }

    public String getDisplayName() {
        return "Remove redundant explicit dependency and plugin versions";
    }

    public String getDescription() {
        return "Remove explicitly-specified dependency/plugin versions when a parent POM's `dependencyManagement`/`pluginManagement` specifies the version.";
    }

    public Validated<Object> validate() {
        Validated.None validated = Validated.none();
        if (this.except != null) {
            for (int i = 0; i < this.except.size(); ++i) {
                String retainVersion = this.except.get(i);
                validated = validated.and(Validated.test((String)String.format("except[%d]", i), (String)"did not look like a two-or-three-part GAV", (Object)retainVersion, maybeGav -> {
                    int gavParts = maybeGav.split(":").length;
                    return gavParts == 2 || gavParts == 3;
                }));
            }
        }
        if (this.onlyIfVersionsMatch != null && this.onlyIfManagedVersionIs != null) {
            validated = validated.and((Validated)Validated.invalid((String)"onlyIfVersionsMatch", (Object)this.onlyIfVersionsMatch, (String)"is deprecated in favor of onlyIfManagedVersionIs, and they cannot be used together"));
        }
        return validated;
    }

    private Comparator determineComparator() {
        if (this.onlyIfVersionsMatch != null) {
            return this.onlyIfVersionsMatch != false ? Comparator.EQ : Comparator.GTE;
        }
        if (this.onlyIfManagedVersionIs != null) {
            return this.onlyIfManagedVersionIs;
        }
        return Comparator.EQ;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final Comparator comparator = this.determineComparator();
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                Xml.Document d = super.visitDocument(document, ctx);
                if (d != document) {
                    d = (Xml.Document)new RemoveEmptyDependenciesTags().visitNonNull((Tree)d, ctx);
                    d = (Xml.Document)new RemoveEmptyPluginsTags().visitNonNull((Tree)d, ctx);
                    if (comparator != Comparator.EQ) {
                        this.maybeUpdateModel();
                    }
                }
                return d;
            }

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.isDependencyTag()) {
                    ResolvedDependency d = this.findDependency(tag);
                    if (d != null && this.matchesGroup(d) && this.matchesArtifact(d) && this.matchesVersion(d) && this.isNotExcepted(d)) {
                        Xml.Tag version = tag.getChild("version").orElse(null);
                        return tag.withContent(ListUtils.map((List)tag.getContent(), c -> c == version ? null : c));
                    }
                } else if (this.isManagedDependencyTag()) {
                    ResolvedManagedDependency managed = this.findManagedDependency(tag);
                    if (managed != null && this.matchesGroup(managed) && this.matchesArtifact(managed) && this.matchesVersion(managed, ctx)) {
                        if (tag.getChild("exclusions").isPresent()) {
                            return tag;
                        }
                        return null;
                    }
                } else if (this.isPluginTag()) {
                    if (this.isManagedPluginTag()) {
                        Xml.Tag version = tag.getChild("version").orElse(null);
                        if (version == null) {
                            return tag;
                        }
                        Plugin p = this.findManagedPlugin(tag);
                        if (p != null && this.matchesGroup(p) && this.matchesArtifact(p) && this.matchesManagedVersion(p, ctx)) {
                            HashSet<String> gavTags = new HashSet<String>(Arrays.asList("groupId", "artifactId", "version"));
                            if (tag.getChildren().stream().allMatch(t -> gavTags.contains(t.getName()))) {
                                return null;
                            }
                            return tag.withContent(ListUtils.map((List)tag.getContent(), c -> c == version ? null : c));
                        }
                    } else {
                        Plugin p = this.findPlugin(tag);
                        if (p != null && this.matchesGroup(p) && this.matchesArtifact(p) && this.matchesVersion(p)) {
                            Xml.Tag version = tag.getChild("version").orElse(null);
                            return tag.withContent(ListUtils.map((List)tag.getContent(), c -> c == version ? null : c));
                        }
                    }
                }
                return super.visitTag(tag, ctx);
            }

            private boolean matchesGroup(ResolvedManagedDependency d) {
                return StringUtils.isNullOrEmpty((String)RemoveRedundantDependencyVersions.this.groupPattern) || StringUtils.matchesGlob((String)d.getGroupId(), (String)RemoveRedundantDependencyVersions.this.groupPattern);
            }

            private boolean matchesGroup(ResolvedDependency d) {
                return StringUtils.isNullOrEmpty((String)RemoveRedundantDependencyVersions.this.groupPattern) || StringUtils.matchesGlob((String)d.getGroupId(), (String)RemoveRedundantDependencyVersions.this.groupPattern);
            }

            private boolean matchesGroup(Plugin p) {
                return StringUtils.isNullOrEmpty((String)RemoveRedundantDependencyVersions.this.groupPattern) || StringUtils.matchesGlob((String)p.getGroupId(), (String)RemoveRedundantDependencyVersions.this.groupPattern);
            }

            private boolean matchesArtifact(ResolvedManagedDependency d) {
                return StringUtils.isNullOrEmpty((String)RemoveRedundantDependencyVersions.this.artifactPattern) || StringUtils.matchesGlob((String)d.getArtifactId(), (String)RemoveRedundantDependencyVersions.this.artifactPattern);
            }

            private boolean matchesArtifact(ResolvedDependency d) {
                return StringUtils.isNullOrEmpty((String)RemoveRedundantDependencyVersions.this.artifactPattern) || StringUtils.matchesGlob((String)d.getArtifactId(), (String)RemoveRedundantDependencyVersions.this.artifactPattern);
            }

            private boolean matchesArtifact(Plugin p) {
                return StringUtils.isNullOrEmpty((String)RemoveRedundantDependencyVersions.this.artifactPattern) || StringUtils.matchesGlob((String)p.getArtifactId(), (String)RemoveRedundantDependencyVersions.this.artifactPattern);
            }

            private boolean matchesVersion(ResolvedManagedDependency d, ExecutionContext ctx) {
                MavenResolutionResult mrr = this.getResolutionResult();
                if (d.getRequested().getVersion() == null || mrr.getPom().getRequested().getParent() == null) {
                    return false;
                }
                try {
                    GroupArtifactVersion parentGav = mrr.getPom().getRequested().getParent().getGav();
                    MavenPomDownloader mpd = new MavenPomDownloader(mrr.getProjectPoms(), ctx, mrr.getMavenSettings(), mrr.getActiveProfiles());
                    ResolvedPom parentPom = mpd.download(parentGav, null, mrr.getPom(), mrr.getPom().getRepositories()).resolve(Collections.emptyList(), mpd, ctx);
                    ResolvedManagedDependency parentManagedVersion = parentPom.getDependencyManagement().stream().filter(dep -> dep.getGroupId().equals(d.getGroupId()) && dep.getArtifactId().equals(d.getArtifactId())).findFirst().orElse(null);
                    if (parentManagedVersion == null) {
                        return false;
                    }
                    String versionAccordingToParent = parentManagedVersion.getVersion();
                    if (versionAccordingToParent == null) {
                        return false;
                    }
                    return this.matchesComparator(versionAccordingToParent, d.getRequested().getVersion());
                }
                catch (Exception e) {
                    return false;
                }
            }

            private boolean matchesVersion(ResolvedDependency d) {
                if (d.getRequested().getVersion() == null) {
                    return false;
                }
                String managedVersion = this.getResolutionResult().getPom().getManagedVersion(d.getGroupId(), d.getArtifactId(), d.getRequested().getType(), d.getRequested().getClassifier());
                return this.matchesComparator(managedVersion, d.getRequested().getVersion());
            }

            private boolean matchesVersion(Plugin p) {
                if (p.getVersion() == null) {
                    return false;
                }
                String managedVersion = RemoveRedundantDependencyVersions.getManagedPluginVersion(this.getResolutionResult().getPom(), p.getGroupId(), p.getArtifactId());
                return this.matchesComparator(managedVersion, p.getVersion());
            }

            private boolean matchesManagedVersion(Plugin p, ExecutionContext ctx) {
                MavenResolutionResult mrr = this.getResolutionResult();
                if (p.getVersion() == null || mrr.getPom().getRequested().getParent() == null) {
                    return false;
                }
                try {
                    GroupArtifactVersion parentGav = mrr.getPom().getRequested().getParent().getGav();
                    MavenPomDownloader mpd = new MavenPomDownloader(mrr.getProjectPoms(), ctx, mrr.getMavenSettings(), mrr.getActiveProfiles());
                    ResolvedPom parentPom = mpd.download(parentGav, null, mrr.getPom(), mrr.getPom().getRepositories()).resolve(Collections.emptyList(), mpd, ctx);
                    return parentPom.getPluginManagement().stream().filter(plugin -> plugin.getGroupId().equals(p.getGroupId()) && plugin.getArtifactId().equals(p.getArtifactId())).findFirst().map(Plugin::getVersion).map(versionAccordingToParent -> this.matchesComparator(parentPom.getValue((String)versionAccordingToParent), p.getVersion())).orElse(false);
                }
                catch (Exception e) {
                    return false;
                }
            }

            private boolean matchesComparator(@Nullable String managedVersion, String requestedVersion) {
                if (managedVersion == null) {
                    return false;
                }
                if (comparator == Comparator.ANY) {
                    return true;
                }
                if (!this.isExact(managedVersion)) {
                    return false;
                }
                int comparison = new LatestIntegration(null).compare(null, managedVersion, Objects.requireNonNull(this.getResolutionResult().getPom().getValue(requestedVersion)));
                if (comparison < 0) {
                    return comparator == Comparator.LT || comparator == Comparator.LTE;
                }
                if (comparison > 0) {
                    return comparator == Comparator.GT || comparator == Comparator.GTE;
                }
                return comparator == Comparator.EQ || comparator == Comparator.LTE || comparator == Comparator.GTE;
            }

            private boolean isExact(String managedVersion) {
                Validated maybeVersionComparator = Semver.validate((String)managedVersion, null);
                return maybeVersionComparator.isValid() && maybeVersionComparator.getValue() instanceof ExactVersion;
            }

            private boolean isNotExcepted(ResolvedDependency d) {
                if (RemoveRedundantDependencyVersions.this.except == null) {
                    return true;
                }
                for (String gav : RemoveRedundantDependencyVersions.this.except) {
                    String[] split = gav.split(":");
                    String exceptedGroupId = split[0];
                    String exceptedArtifactId = split[1];
                    if (!StringUtils.matchesGlob((String)d.getGroupId(), (String)exceptedGroupId) || !StringUtils.matchesGlob((String)d.getArtifactId(), (String)exceptedArtifactId)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private static @Nullable String getManagedPluginVersion(ResolvedPom resolvedPom, String groupId, String artifactId) {
        for (Plugin p : ListUtils.concatAll(resolvedPom.getPluginManagement(), resolvedPom.getRequested().getPluginManagement())) {
            if (!Objects.equals(p.getGroupId(), groupId) || !Objects.equals(p.getArtifactId(), artifactId)) continue;
            return resolvedPom.getValue(p.getVersion());
        }
        return null;
    }

    @Generated
    public @Nullable String getGroupPattern() {
        return this.groupPattern;
    }

    @Generated
    public @Nullable String getArtifactPattern() {
        return this.artifactPattern;
    }

    @Deprecated
    @Generated
    public @Nullable Boolean getOnlyIfVersionsMatch() {
        return this.onlyIfVersionsMatch;
    }

    @Generated
    public @Nullable Comparator getOnlyIfManagedVersionIs() {
        return this.onlyIfManagedVersionIs;
    }

    @Generated
    public @Nullable List<String> getExcept() {
        return this.except;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveRedundantDependencyVersions(groupPattern=" + this.getGroupPattern() + ", artifactPattern=" + this.getArtifactPattern() + ", onlyIfVersionsMatch=" + this.getOnlyIfVersionsMatch() + ", onlyIfManagedVersionIs=" + (Object)((Object)this.getOnlyIfManagedVersionIs()) + ", except=" + this.getExcept() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveRedundantDependencyVersions)) {
            return false;
        }
        RemoveRedundantDependencyVersions other = (RemoveRedundantDependencyVersions)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$onlyIfVersionsMatch = this.getOnlyIfVersionsMatch();
        Boolean other$onlyIfVersionsMatch = other.getOnlyIfVersionsMatch();
        if (this$onlyIfVersionsMatch == null ? other$onlyIfVersionsMatch != null : !((Object)this$onlyIfVersionsMatch).equals(other$onlyIfVersionsMatch)) {
            return false;
        }
        String this$groupPattern = this.getGroupPattern();
        String other$groupPattern = other.getGroupPattern();
        if (this$groupPattern == null ? other$groupPattern != null : !this$groupPattern.equals(other$groupPattern)) {
            return false;
        }
        String this$artifactPattern = this.getArtifactPattern();
        String other$artifactPattern = other.getArtifactPattern();
        if (this$artifactPattern == null ? other$artifactPattern != null : !this$artifactPattern.equals(other$artifactPattern)) {
            return false;
        }
        Comparator this$onlyIfManagedVersionIs = this.getOnlyIfManagedVersionIs();
        Comparator other$onlyIfManagedVersionIs = other.getOnlyIfManagedVersionIs();
        if (this$onlyIfManagedVersionIs == null ? other$onlyIfManagedVersionIs != null : !((Object)((Object)this$onlyIfManagedVersionIs)).equals((Object)other$onlyIfManagedVersionIs)) {
            return false;
        }
        List<String> this$except = this.getExcept();
        List<String> other$except = other.getExcept();
        return !(this$except == null ? other$except != null : !((Object)this$except).equals(other$except));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof RemoveRedundantDependencyVersions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $onlyIfVersionsMatch = this.getOnlyIfVersionsMatch();
        result = result * 59 + ($onlyIfVersionsMatch == null ? 43 : ((Object)$onlyIfVersionsMatch).hashCode());
        String $groupPattern = this.getGroupPattern();
        result = result * 59 + ($groupPattern == null ? 43 : $groupPattern.hashCode());
        String $artifactPattern = this.getArtifactPattern();
        result = result * 59 + ($artifactPattern == null ? 43 : $artifactPattern.hashCode());
        Comparator $onlyIfManagedVersionIs = this.getOnlyIfManagedVersionIs();
        result = result * 59 + ($onlyIfManagedVersionIs == null ? 43 : ((Object)((Object)$onlyIfManagedVersionIs)).hashCode());
        List<String> $except = this.getExcept();
        result = result * 59 + ($except == null ? 43 : ((Object)$except).hashCode());
        return result;
    }

    public static enum Comparator {
        ANY,
        EQ,
        LT,
        LTE,
        GT,
        GTE;

    }

    private static class RemoveEmptyPluginsTags
    extends MavenIsoVisitor<ExecutionContext> {
        private RemoveEmptyPluginsTags() {
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
            Xml.Tag t = super.visitTag(tag, ctx);
            if (("pluginManagement".equals(t.getName()) || "plugins".equals(t.getName())) && (t.getContent() == null || t.getContent().isEmpty())) {
                return null;
            }
            return t;
        }
    }

    private static class RemoveEmptyDependenciesTags
    extends MavenIsoVisitor<ExecutionContext> {
        private RemoveEmptyDependenciesTags() {
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
            Xml.Tag t = super.visitTag(tag, ctx);
            if (("dependencyManagement".equals(t.getName()) || "dependencies".equals(t.getName())) && (t.getContent() == null || t.getContent().isEmpty())) {
                return null;
            }
            return t;
        }
    }
}

