/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.utilities;

import dev.failsafe.Failsafe;
import dev.failsafe.FailsafeException;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.StreamUtils;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.ipc.http.HttpUrlConnectionSender;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.cache.MavenArtifactCache;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.ResolvedDependency;

public class MavenArtifactDownloader {
    private static final RetryPolicy<Object> retryPolicy = ((RetryPolicyBuilder)((RetryPolicyBuilder)RetryPolicy.builder().handle(new Class[]{SocketTimeoutException.class, TimeoutException.class})).handleIf(throwable -> throwable instanceof UncheckedIOException && throwable.getCause() instanceof SocketTimeoutException)).withDelay(Duration.ofMillis(500L)).withJitter(0.1).withMaxRetries(5).build();
    private final MavenArtifactCache mavenArtifactCache;
    private final Map<String, MavenSettings.Server> serverIdToServer;
    private final Consumer<Throwable> onError;
    private final HttpSender httpSender;

    public MavenArtifactDownloader(MavenArtifactCache mavenArtifactCache, @Nullable MavenSettings settings, Consumer<Throwable> onError) {
        this(mavenArtifactCache, settings, (HttpSender)new HttpUrlConnectionSender(), onError);
    }

    public MavenArtifactDownloader(MavenArtifactCache mavenArtifactCache, @Nullable MavenSettings settings, HttpSender httpSender, Consumer<Throwable> onError) {
        this.httpSender = httpSender;
        this.mavenArtifactCache = mavenArtifactCache;
        this.onError = onError;
        this.serverIdToServer = settings == null || settings.getServers() == null ? new HashMap<String, MavenSettings.Server>() : settings.getServers().getServers().stream().collect(Collectors.toMap(MavenSettings.Server::getId, Function.identity()));
    }

    public @Nullable Path downloadArtifact(ResolvedDependency dependency) {
        if (dependency.getRequested().getType() != null && !"jar".equals(dependency.getRequested().getType())) {
            return null;
        }
        return this.mavenArtifactCache.computeArtifact(dependency, () -> {
            String baseUri = Objects.requireNonNull(dependency.getRepository(), String.format("Repository for dependency '%s' was null.", dependency)).getUri();
            String path = dependency.getGroupId().replace('.', '/') + '/' + dependency.getArtifactId() + '/' + dependency.getVersion() + '/' + dependency.getArtifactId() + '-' + (dependency.getDatedSnapshotVersion() == null ? dependency.getVersion() : dependency.getDatedSnapshotVersion()) + ".jar";
            String uri = baseUri + (baseUri.endsWith("/") ? "" : "/") + path;
            if (uri.startsWith("~")) {
                return Files.newInputStream(Paths.get(System.getProperty("user.home") + uri.substring(1), new String[0]), new OpenOption[0]);
            }
            if ("file".equals(URI.create(uri).getScheme())) {
                return Files.newInputStream(Paths.get(URI.create(uri)), new OpenOption[0]);
            }
            HttpSender.Request.Builder request = this.applyAuthentication(dependency.getRepository(), this.httpSender.get(uri));
            try (HttpSender.Response response = (HttpSender.Response)Failsafe.with(retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> this.httpSender.send(request.build()));
                 InputStream body = response.getBody();){
                if (!response.isSuccessful() || body == null) {
                    this.onError.accept(new MavenDownloadingException(String.format("Unable to download dependency %s:%s:%s from %s. Response was %d", dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), uri, response.getCode()), null, dependency.getRequested().getGav()));
                    InputStream inputStream = null;
                    return inputStream;
                }
                InputStream bodyStream = new ByteArrayInputStream(StreamUtils.readAllBytes((InputStream)body));
                return bodyStream;
            }
            catch (Throwable t) {
                Throwable cause = t instanceof FailsafeException && t.getCause() != null ? t.getCause() : t;
                throw new MavenDownloadingException("Unable to download dependency", cause, dependency.getRequested().getGav());
            }
        }, this.onError);
    }

    private HttpSender.Request.Builder applyAuthentication(MavenRepository repository, HttpSender.Request.Builder request) {
        MavenSettings.Server authInfo = this.serverIdToServer.get(repository.getId());
        if (authInfo != null) {
            if (authInfo.getConfiguration() != null && authInfo.getConfiguration().getHttpHeaders() != null) {
                for (MavenSettings.HttpHeader header : authInfo.getConfiguration().getHttpHeaders()) {
                    request.withHeader(header.getName(), header.getValue());
                }
            }
            return request.withBasicAuthentication(authInfo.getUsername(), authInfo.getPassword());
        }
        if (repository.getUsername() != null && repository.getPassword() != null) {
            return request.withBasicAuthentication(repository.getUsername(), repository.getPassword());
        }
        return request;
    }
}

