/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Color;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.Shape;
import guru.nidi.graphviz.attribute.Style;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ManagedDependency;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolutionEventListener;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.maven.tree.Scope;

public class GraphvizResolutionEventListener
implements ResolutionEventListener {
    public static final String GRAPH_NAME = "resolution";
    private final Map<String, MutableNode> propToNode = new HashMap<String, MutableNode>();
    private final Map<GroupArtifactVersion, MutableNode> pomToNode = new HashMap<GroupArtifactVersion, MutableNode>();
    private final Map<GroupArtifactVersion, Set<GroupArtifactVersion>> alreadySeen = new HashMap<GroupArtifactVersion, Set<GroupArtifactVersion>>();
    private MutableGraph g = Factory.mutGraph((String)"resolution").setDirected(true);
    private final Scope scope;
    private final boolean showProperties;
    private final boolean showManagedDependencies;
    private int parentLinks;
    private int dependencyLinks;
    private int managedDependencies;

    @Override
    public void clear() {
        this.g = Factory.mutGraph((String)GRAPH_NAME).setDirected(true);
        this.propToNode.clear();
        this.pomToNode.clear();
        this.alreadySeen.clear();
        this.parentLinks = 0;
        this.dependencyLinks = 0;
        this.managedDependencies = 0;
    }

    @Override
    public void parent(Pom parent, Pom containing) {
        if (this.alreadySeen.getOrDefault(this.simplifyGav(containing.getGav()), Collections.emptySet()).contains(this.simplifyGav(parent.getGav()))) {
            return;
        }
        this.alreadySeen.computeIfAbsent(this.simplifyGav(containing.getGav()), g -> new HashSet()).add(this.simplifyGav(parent.getGav()));
        Link link = Link.to((MutableNode)((MutableNode)this.gavNode(parent.getGav()).add((Attributes)Style.FILLED, (Attributes)Color.rgb((String)"deefee")))).with((Attributes)Style.DASHED);
        if (this.parentLinks++ == 0) {
            link = link.with((Attributes)Label.of((String)"parent"));
        }
        this.gavNode(containing.getGav()).addLink((LinkTarget)link);
    }

    @Override
    public void dependency(Scope scope, ResolvedDependency resolvedDependency, ResolvedPom containing) {
        if (scope != this.scope) {
            return;
        }
        Link link = Link.to((MutableNode)((MutableNode)this.gavNode(resolvedDependency.getGav()).add((Attributes)Style.FILLED, (Attributes)Color.rgb((String)"e6eaff"))));
        if (this.dependencyLinks++ == 0) {
            link = link.with((Attributes)Label.of((String)"dependency"));
        }
        this.gavNode(containing.getGav()).addLink((LinkTarget)link);
    }

    @Override
    public void property(String key, String value, Pom containing) {
        if (!this.showProperties) {
            return;
        }
        this.gavNode(containing.getGav()).addLink((LinkTarget)this.propNode(key, value));
    }

    @Override
    public void dependencyManagement(ManagedDependency dependencyManagement, Pom containing) {
        if (!this.showManagedDependencies) {
            return;
        }
        GroupArtifactVersion gav = new GroupArtifactVersion(dependencyManagement.getGroupId(), dependencyManagement.getArtifactId(), dependencyManagement.getVersion());
        if (this.alreadySeen.getOrDefault(this.simplifyGav(containing.getGav()), Collections.emptySet()).contains(gav)) {
            return;
        }
        this.alreadySeen.computeIfAbsent(this.simplifyGav(containing.getGav()), g -> new HashSet()).add(gav);
        Link link = Link.to((MutableNode)((MutableNode)this.dmNode(gav).add((Attributes)Style.FILLED, (Attributes)Color.rgb((String)"d6d6de"))));
        if (this.managedDependencies++ == 0) {
            link = link.with((Attributes)Label.of((String)"dependencyManagement"));
        }
        this.gavNode(containing.getGav()).addLink((LinkTarget)link);
    }

    @Override
    public void downloadError(GroupArtifactVersion gav, List<String> attemptedUris, @Nullable Pom containing) {
        Link link = Link.to((MutableNode)((MutableNode)this.gavNode(gav).add((Attributes)Style.FILLED, (Attributes)Color.rgb((String)"ff1947")))).with((Attributes)Label.of((String)"error"));
        if (containing != null) {
            this.gavNode(containing.getGav()).addLink((LinkTarget)link);
        }
    }

    @Override
    public void bomImport(ResolvedGroupArtifactVersion gav, Pom containing) {
        if (this.alreadySeen.getOrDefault(this.simplifyGav(containing.getGav()), Collections.emptySet()).contains(this.simplifyGav(gav))) {
            return;
        }
        this.alreadySeen.computeIfAbsent(this.simplifyGav(containing.getGav()), g -> new HashSet()).add(this.simplifyGav(gav));
        Link link = Link.to((MutableNode)((MutableNode)this.gavNode(gav).add((Attributes)Style.FILLED, (Attributes)Color.rgb((String)"e6eaff"))));
        if (this.dependencyLinks++ == 0) {
            link = link.with((Attributes)Label.of((String)"dependency"));
        }
        this.gavNode(containing.getGav()).addLink((LinkTarget)link);
    }

    public Graphviz graphviz() {
        return Graphviz.fromGraph((MutableGraph)this.g);
    }

    private GroupArtifactVersion simplifyGav(ResolvedGroupArtifactVersion gav) {
        return new GroupArtifactVersion(gav.getGroupId(), gav.getArtifactId(), gav.getDatedSnapshotVersion() == null ? gav.getVersion() : gav.getDatedSnapshotVersion());
    }

    private MutableNode gavNode(ResolvedGroupArtifactVersion gav) {
        return this.gavNode(this.simplifyGav(gav));
    }

    private MutableNode gavNode(GroupArtifactVersion gav) {
        return this.pomToNode.computeIfAbsent(gav, ignored -> {
            MutableNode node = (MutableNode)Factory.mutNode((Label)Label.lines((String[])new String[]{gav.getGroupId(), gav.getArtifactId(), gav.getVersion()})).add((Attributes)Shape.RECTANGLE, (Attributes)Style.FILLED, (Attributes)Color.rgb((String)"f9a91b"));
            String url = this.gavUrl(gav);
            if (url != null) {
                node = (MutableNode)node.add("URL", (Object)url);
            }
            this.g.add((LinkSource)node);
            return node;
        });
    }

    private MutableNode dmNode(GroupArtifactVersion gav) {
        return this.pomToNode.computeIfAbsent(gav, ignored -> {
            MutableNode node = Factory.mutNode((Label)Label.lines((String[])new String[]{gav.getGroupId(), gav.getArtifactId(), gav.getVersion()})).add((Attributes)Shape.RECTANGLE);
            String url = this.gavUrl(gav);
            if (url != null) {
                node = (MutableNode)node.add("URL", (Object)url);
            }
            this.g.add((LinkSource)node);
            return node;
        });
    }

    private MutableNode propNode(String key, String value) {
        return this.propToNode.computeIfAbsent(key + "=" + value, ignored -> {
            MutableNode node = Factory.mutNode((Label)Label.lines((String[])new String[]{key, value}));
            this.g.add((LinkSource)node);
            return node;
        });
    }

    private @Nullable String gavUrl(GroupArtifactVersion gav) {
        if (gav.getGroupId() == null || gav.getArtifactId() == null || gav.getVersion() == null) {
            return null;
        }
        try {
            return "https://repo1.maven.org/maven2/" + Arrays.stream(gav.getGroupId().split("\\.")).map(g -> {
                try {
                    return URLEncoder.encode(g, StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.joining("/")) + '/' + URLEncoder.encode(gav.getArtifactId(), StandardCharsets.UTF_8.name()) + '/' + URLEncoder.encode(gav.getVersion(), StandardCharsets.UTF_8.name()) + '/' + URLEncoder.encode(gav.getArtifactId() + '-' + gav.getVersion() + ".pom", StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public GraphvizResolutionEventListener(Scope scope, boolean showProperties, boolean showManagedDependencies) {
        this.scope = scope;
        this.showProperties = showProperties;
        this.showManagedDependencies = showManagedDependencies;
    }
}

