/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.trait;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.trait.MavenTraitMatcher;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.semver.ExactVersion;
import org.openrewrite.semver.LatestPatch;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.trait.Trait;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class MavenDependency
implements Trait<Xml.Tag> {
    private static final XPathMatcher DEPENDENCY_MATCHER = new XPathMatcher("/project/dependencies/dependency");
    private static final XPathMatcher PROFILE_DEPENDENCY_MATCHER = new XPathMatcher("/project/profiles/profile/dependencies/dependency");
    private final Cursor cursor;
    private final ResolvedDependency resolvedDependency;

    public static @Nullable String findNewerVersion(String groupId, String artifactId, @Nullable String currentVersion, MavenResolutionResult mrr, MavenMetadataFailures metadataFailures, VersionComparator versionComparator, ExecutionContext ctx) throws MavenDownloadingException {
        String finalVersion;
        String string = finalVersion = !Semver.isVersion((String)currentVersion) ? "0.0.0" : currentVersion;
        if (versionComparator instanceof LatestPatch && !versionComparator.isValid(finalVersion, finalVersion)) {
            return null;
        }
        try {
            String exactVersion;
            MavenExecutionContextView mctx = MavenExecutionContextView.view(ctx);
            MavenMetadata mavenMetadata = metadataFailures.insertRows(ctx, () -> new MavenPomDownloader(Collections.emptyMap(), ctx, Optional.ofNullable(mctx.getSettings()).orElse(mrr.getMavenSettings()), Optional.ofNullable(mctx.getSettings()).map(MavenSettings::getActiveProfiles).map(MavenSettings.ActiveProfiles::getActiveProfiles).orElse(mrr.getActiveProfiles())).downloadMetadata(new GroupArtifact(groupId, artifactId), null, mrr.getPom().getRepositories()));
            ArrayList<String> versions = new ArrayList<String>();
            for (String v : mavenMetadata.getVersioning().getVersions()) {
                if (!versionComparator.isValid(finalVersion, v)) continue;
                versions.add(v);
            }
            if (versionComparator instanceof ExactVersion && !versions.contains(exactVersion = ((ExactVersion)versionComparator).getVersion())) {
                try {
                    Pom pom = new MavenPomDownloader(Collections.emptyMap(), ctx, mrr.getMavenSettings(), mrr.getActiveProfiles()).download(new GroupArtifactVersion(groupId, artifactId, ((ExactVersion)versionComparator).getVersion()), null, null, mrr.getPom().getRepositories());
                    if (pom.getGav().getVersion().equals(exactVersion)) {
                        return exactVersion;
                    }
                }
                catch (MavenDownloadingException e) {
                    return null;
                }
            }
            if (!Semver.isVersion((String)finalVersion) && !versions.isEmpty()) {
                versions.sort((Comparator<String>)versionComparator);
                return (String)versions.get(versions.size() - 1);
            }
            return versionComparator.upgrade(finalVersion, versions).orElse(null);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    @Generated
    public MavenDependency(Cursor cursor, ResolvedDependency resolvedDependency) {
        this.cursor = cursor;
        this.resolvedDependency = resolvedDependency;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenDependency)) {
            return false;
        }
        MavenDependency other = (MavenDependency)o;
        Cursor this$cursor = this.getCursor();
        Cursor other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
            return false;
        }
        ResolvedDependency this$resolvedDependency = this.getResolvedDependency();
        ResolvedDependency other$resolvedDependency = other.getResolvedDependency();
        return !(this$resolvedDependency == null ? other$resolvedDependency != null : !((Object)this$resolvedDependency).equals(other$resolvedDependency));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Cursor $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        ResolvedDependency $resolvedDependency = this.getResolvedDependency();
        result = result * 59 + ($resolvedDependency == null ? 43 : ((Object)$resolvedDependency).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "MavenDependency(cursor=" + this.getCursor() + ", resolvedDependency=" + this.getResolvedDependency() + ")";
    }

    @Generated
    public ResolvedDependency getResolvedDependency() {
        return this.resolvedDependency;
    }

    public static class Matcher
    extends MavenTraitMatcher<MavenDependency> {
        protected @Nullable String groupId;
        protected @Nullable String artifactId;

        public Matcher groupId(@Nullable String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Matcher artifactId(@Nullable String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        protected @Nullable MavenDependency test(Cursor cursor) {
            Object value = cursor.getValue();
            if (value instanceof Xml.Tag) {
                Xml.Tag tag = (Xml.Tag)value;
                if (!"dependency".equals(tag.getName()) || !DEPENDENCY_MATCHER.matches(cursor) && !PROFILE_DEPENDENCY_MATCHER.matches(cursor)) {
                    return null;
                }
                Map<Scope, List<ResolvedDependency>> dependencies = this.getResolutionResult(cursor).getDependencies();
                for (Scope scope : Scope.values()) {
                    if (!dependencies.containsKey((Object)scope)) continue;
                    for (ResolvedDependency resolvedDependency : dependencies.get((Object)scope)) {
                        Dependency req;
                        String reqGroup;
                        Scope tagScope;
                        if (this.groupId != null && !StringUtils.matchesGlob((String)resolvedDependency.getGroupId(), (String)this.groupId) || this.artifactId != null && !StringUtils.matchesGlob((String)resolvedDependency.getArtifactId(), (String)this.artifactId)) continue;
                        String scopeName = tag.getChildValue("scope").orElse(null);
                        Scope scope2 = tagScope = scopeName != null ? Scope.fromName(scopeName) : null;
                        if (tagScope == null && this.artifactId != null) {
                            tagScope = this.getResolutionResult(cursor).getPom().getManagedScope(this.groupId, this.artifactId, tag.getChildValue("type").orElse(null), tag.getChildValue("classifier").orElse(null));
                        }
                        if (tagScope == null) {
                            tagScope = Scope.Compile;
                        }
                        if ((reqGroup = (req = resolvedDependency.getRequested()).getGroupId()) != null && !reqGroup.equals(tag.getChildValue("groupId").orElse(null)) || !req.getArtifactId().equals(tag.getChildValue("artifactId").orElse(null)) || scope != tagScope) continue;
                        return new MavenDependency(cursor, resolvedDependency);
                    }
                }
            }
            return null;
        }
    }
}

