/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.io.Serializable;
import java.util.List;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.License;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public final class ResolvedDependency
implements Serializable {
    @Nullable
    private final MavenRepository repository;
    private final ResolvedGroupArtifactVersion gav;
    private final Dependency requested;
    private List<ResolvedDependency> dependencies;
    private final List<License> licenses;
    @Nullable
    private final String type;
    @Nullable
    private final String classifier;
    @Nullable
    private final Boolean optional;
    private final int depth;
    private List<GroupArtifact> effectiveExclusions;

    void unsafeSetDependencies(List<ResolvedDependency> dependencies) {
        this.dependencies = dependencies;
    }

    void unsafeSetEffectiveExclusions(List<GroupArtifact> effectiveExclusions) {
        this.effectiveExclusions = effectiveExclusions;
    }

    public ResolvedGroupArtifactVersion getGav() {
        return this.gav;
    }

    public String getGroupId() {
        return this.gav.getGroupId();
    }

    public String getArtifactId() {
        return this.gav.getArtifactId();
    }

    public String getVersion() {
        return this.gav.getVersion();
    }

    public String getType() {
        return this.type == null ? "jar" : this.type;
    }

    public boolean isDirect() {
        return this.depth == 0;
    }

    public boolean isTransitive() {
        return this.depth != 0;
    }

    @Nullable
    public String getDatedSnapshotVersion() {
        return this.gav.getDatedSnapshotVersion();
    }

    @Nullable
    public ResolvedDependency findDependency(String groupId, String artifactId) {
        if (StringUtils.matchesGlob((String)this.getGroupId(), (String)groupId) && StringUtils.matchesGlob((String)this.getArtifactId(), (String)artifactId)) {
            return this;
        }
        block0: for (ResolvedDependency dependency : this.dependencies) {
            ResolvedDependency found = dependency.findDependency(groupId, artifactId);
            if (found == null) continue;
            if (this.getRequested().getExclusions() != null) {
                for (GroupArtifact exclusion : this.getRequested().getExclusions()) {
                    if (!StringUtils.matchesGlob((String)found.getGroupId(), (String)exclusion.getGroupId()) || !StringUtils.matchesGlob((String)found.getArtifactId(), (String)exclusion.getArtifactId())) continue;
                    continue block0;
                }
            }
            return found;
        }
        return null;
    }

    public String toString() {
        return (this.repository == null ? "" : this.repository.getUri() + "/") + this.gav.getGroupId().replace('.', '/') + "/" + this.gav.getArtifactId() + "/" + this.gav.getVersion() + "/" + this.gav.getArtifactId() + "-" + this.gav.getVersion() + ".pom";
    }

    @NonNull
    public static ResolvedDependencyBuilder builder() {
        return new ResolvedDependencyBuilder();
    }

    @Nullable
    public MavenRepository getRepository() {
        return this.repository;
    }

    public Dependency getRequested() {
        return this.requested;
    }

    public List<ResolvedDependency> getDependencies() {
        return this.dependencies;
    }

    public List<License> getLicenses() {
        return this.licenses;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    @Nullable
    public Boolean getOptional() {
        return this.optional;
    }

    public int getDepth() {
        return this.depth;
    }

    public List<GroupArtifact> getEffectiveExclusions() {
        return this.effectiveExclusions;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResolvedDependency)) {
            return false;
        }
        ResolvedDependency other = (ResolvedDependency)o;
        if (this.getDepth() != other.getDepth()) {
            return false;
        }
        Boolean this$optional = this.getOptional();
        Boolean other$optional = other.getOptional();
        if (this$optional == null ? other$optional != null : !((Object)this$optional).equals(other$optional)) {
            return false;
        }
        MavenRepository this$repository = this.getRepository();
        MavenRepository other$repository = other.getRepository();
        if (this$repository == null ? other$repository != null : !((Object)this$repository).equals(other$repository)) {
            return false;
        }
        ResolvedGroupArtifactVersion this$gav = this.getGav();
        ResolvedGroupArtifactVersion other$gav = other.getGav();
        if (this$gav == null ? other$gav != null : !((Object)this$gav).equals(other$gav)) {
            return false;
        }
        Dependency this$requested = this.getRequested();
        Dependency other$requested = other.getRequested();
        if (this$requested == null ? other$requested != null : !((Object)this$requested).equals(other$requested)) {
            return false;
        }
        List<ResolvedDependency> this$dependencies = this.getDependencies();
        List<ResolvedDependency> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        List<License> this$licenses = this.getLicenses();
        List<License> other$licenses = other.getLicenses();
        if (this$licenses == null ? other$licenses != null : !((Object)this$licenses).equals(other$licenses)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$classifier = this.getClassifier();
        String other$classifier = other.getClassifier();
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        List<GroupArtifact> this$effectiveExclusions = this.getEffectiveExclusions();
        List<GroupArtifact> other$effectiveExclusions = other.getEffectiveExclusions();
        return !(this$effectiveExclusions == null ? other$effectiveExclusions != null : !((Object)this$effectiveExclusions).equals(other$effectiveExclusions));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDepth();
        Boolean $optional = this.getOptional();
        result = result * 59 + ($optional == null ? 43 : ((Object)$optional).hashCode());
        MavenRepository $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : ((Object)$repository).hashCode());
        ResolvedGroupArtifactVersion $gav = this.getGav();
        result = result * 59 + ($gav == null ? 43 : ((Object)$gav).hashCode());
        Dependency $requested = this.getRequested();
        result = result * 59 + ($requested == null ? 43 : ((Object)$requested).hashCode());
        List<ResolvedDependency> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        List<License> $licenses = this.getLicenses();
        result = result * 59 + ($licenses == null ? 43 : ((Object)$licenses).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $classifier = this.getClassifier();
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        List<GroupArtifact> $effectiveExclusions = this.getEffectiveExclusions();
        result = result * 59 + ($effectiveExclusions == null ? 43 : ((Object)$effectiveExclusions).hashCode());
        return result;
    }

    @NonNull
    public ResolvedDependency withRepository(@Nullable MavenRepository repository) {
        return this.repository == repository ? this : new ResolvedDependency(repository, this.gav, this.requested, this.dependencies, this.licenses, this.type, this.classifier, this.optional, this.depth, this.effectiveExclusions);
    }

    @NonNull
    public ResolvedDependency withGav(ResolvedGroupArtifactVersion gav) {
        return this.gav == gav ? this : new ResolvedDependency(this.repository, gav, this.requested, this.dependencies, this.licenses, this.type, this.classifier, this.optional, this.depth, this.effectiveExclusions);
    }

    @NonNull
    public ResolvedDependency withRequested(Dependency requested) {
        return this.requested == requested ? this : new ResolvedDependency(this.repository, this.gav, requested, this.dependencies, this.licenses, this.type, this.classifier, this.optional, this.depth, this.effectiveExclusions);
    }

    @NonNull
    public ResolvedDependency withDependencies(List<ResolvedDependency> dependencies) {
        return this.dependencies == dependencies ? this : new ResolvedDependency(this.repository, this.gav, this.requested, dependencies, this.licenses, this.type, this.classifier, this.optional, this.depth, this.effectiveExclusions);
    }

    @NonNull
    public ResolvedDependency withLicenses(List<License> licenses) {
        return this.licenses == licenses ? this : new ResolvedDependency(this.repository, this.gav, this.requested, this.dependencies, licenses, this.type, this.classifier, this.optional, this.depth, this.effectiveExclusions);
    }

    @NonNull
    public ResolvedDependency withType(@Nullable String type) {
        return this.type == type ? this : new ResolvedDependency(this.repository, this.gav, this.requested, this.dependencies, this.licenses, type, this.classifier, this.optional, this.depth, this.effectiveExclusions);
    }

    @NonNull
    public ResolvedDependency withClassifier(@Nullable String classifier) {
        return this.classifier == classifier ? this : new ResolvedDependency(this.repository, this.gav, this.requested, this.dependencies, this.licenses, this.type, classifier, this.optional, this.depth, this.effectiveExclusions);
    }

    @NonNull
    public ResolvedDependency withOptional(@Nullable Boolean optional) {
        return this.optional == optional ? this : new ResolvedDependency(this.repository, this.gav, this.requested, this.dependencies, this.licenses, this.type, this.classifier, optional, this.depth, this.effectiveExclusions);
    }

    @NonNull
    public ResolvedDependency withDepth(int depth) {
        return this.depth == depth ? this : new ResolvedDependency(this.repository, this.gav, this.requested, this.dependencies, this.licenses, this.type, this.classifier, this.optional, depth, this.effectiveExclusions);
    }

    @NonNull
    public ResolvedDependency withEffectiveExclusions(List<GroupArtifact> effectiveExclusions) {
        return this.effectiveExclusions == effectiveExclusions ? this : new ResolvedDependency(this.repository, this.gav, this.requested, this.dependencies, this.licenses, this.type, this.classifier, this.optional, this.depth, effectiveExclusions);
    }

    public ResolvedDependency(@Nullable MavenRepository repository, ResolvedGroupArtifactVersion gav, Dependency requested, List<ResolvedDependency> dependencies, List<License> licenses, @Nullable String type, @Nullable String classifier, @Nullable Boolean optional, int depth, List<GroupArtifact> effectiveExclusions) {
        this.repository = repository;
        this.gav = gav;
        this.requested = requested;
        this.dependencies = dependencies;
        this.licenses = licenses;
        this.type = type;
        this.classifier = classifier;
        this.optional = optional;
        this.depth = depth;
        this.effectiveExclusions = effectiveExclusions;
    }

    public static class ResolvedDependencyBuilder {
        private MavenRepository repository;
        private ResolvedGroupArtifactVersion gav;
        private Dependency requested;
        private List<ResolvedDependency> dependencies;
        private List<License> licenses;
        private String type;
        private String classifier;
        private Boolean optional;
        private int depth;
        private List<GroupArtifact> effectiveExclusions;

        ResolvedDependencyBuilder() {
        }

        @NonNull
        public ResolvedDependencyBuilder repository(@Nullable MavenRepository repository) {
            this.repository = repository;
            return this;
        }

        @NonNull
        public ResolvedDependencyBuilder gav(ResolvedGroupArtifactVersion gav) {
            this.gav = gav;
            return this;
        }

        @NonNull
        public ResolvedDependencyBuilder requested(Dependency requested) {
            this.requested = requested;
            return this;
        }

        @NonNull
        public ResolvedDependencyBuilder dependencies(List<ResolvedDependency> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        @NonNull
        public ResolvedDependencyBuilder licenses(List<License> licenses) {
            this.licenses = licenses;
            return this;
        }

        @NonNull
        public ResolvedDependencyBuilder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        @NonNull
        public ResolvedDependencyBuilder classifier(@Nullable String classifier) {
            this.classifier = classifier;
            return this;
        }

        @NonNull
        public ResolvedDependencyBuilder optional(@Nullable Boolean optional) {
            this.optional = optional;
            return this;
        }

        @NonNull
        public ResolvedDependencyBuilder depth(int depth) {
            this.depth = depth;
            return this;
        }

        @NonNull
        public ResolvedDependencyBuilder effectiveExclusions(List<GroupArtifact> effectiveExclusions) {
            this.effectiveExclusions = effectiveExclusions;
            return this;
        }

        @NonNull
        public ResolvedDependency build() {
            return new ResolvedDependency(this.repository, this.gav, this.requested, this.dependencies, this.licenses, this.type, this.classifier, this.optional, this.depth, this.effectiveExclusions);
        }

        @NonNull
        public String toString() {
            return "ResolvedDependency.ResolvedDependencyBuilder(repository=" + this.repository + ", gav=" + this.gav + ", requested=" + this.requested + ", dependencies=" + this.dependencies + ", licenses=" + this.licenses + ", type=" + this.type + ", classifier=" + this.classifier + ", optional=" + this.optional + ", depth=" + this.depth + ", effectiveExclusions=" + this.effectiveExclusions + ")";
        }
    }
}

