/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import io.vavr.CheckedFunction1;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HttpSenderExecutionContextView;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.MavenClientSideException;
import org.openrewrite.maven.internal.MavenDownloadingException;
import org.openrewrite.maven.internal.RawPom;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.MavenRepositoryCredentials;
import org.openrewrite.maven.tree.MavenRepositoryMirror;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedPom;

public class MavenPomDownloader {
    private static final RetryConfig retryConfig = RetryConfig.custom().retryOnException(throwable -> throwable instanceof SocketTimeoutException || throwable instanceof TimeoutException).build();
    private static final RetryRegistry retryRegistry = RetryRegistry.of((RetryConfig)retryConfig);
    private static final Retry mavenDownloaderRetry = retryRegistry.retry("MavenDownloader");
    private final MavenPomCache mavenCache;
    private final Map<Path, Pom> projectPoms;
    private final MavenExecutionContextView ctx;
    private final HttpSender httpSender;
    private final CheckedFunction1<HttpSender.Request, byte[]> sendRequest;

    public MavenPomDownloader(Map<Path, Pom> projectPoms, ExecutionContext ctx) {
        this(projectPoms, HttpSenderExecutionContextView.view((ExecutionContext)ctx).getHttpSender(), ctx);
    }

    @Deprecated
    public MavenPomDownloader(Map<Path, Pom> projectPoms, HttpSender httpSender, ExecutionContext ctx) {
        this.projectPoms = projectPoms;
        this.httpSender = httpSender;
        this.sendRequest = Retry.decorateCheckedFunction((Retry)mavenDownloaderRetry, (CheckedFunction1 & Serializable)request -> {
            try (HttpSender.Response response = httpSender.send(request);){
                if (response.isSuccessful()) {
                    byte[] byArray = response.getBodyAsBytes();
                    return byArray;
                }
                if (response.getCode() >= 400 && response.getCode() <= 404) {
                    throw new MavenClientSideException("Failed to download " + request.getUrl(), response.getCode());
                }
                throw new MavenDownloadingException("Failed to download " + request.getUrl() + ": " + response.getCode());
            }
        });
        this.ctx = MavenExecutionContextView.view(ctx);
        this.mavenCache = this.ctx.getPomCache();
    }

    public MavenMetadata downloadMetadata(GroupArtifact groupArtifact, @Nullable ResolvedPom containingPom, List<MavenRepository> repositories) {
        return this.downloadMetadata(new GroupArtifactVersion(groupArtifact.getGroupId(), groupArtifact.getArtifactId(), null), containingPom, repositories);
    }

    public MavenMetadata downloadMetadata(GroupArtifactVersion gav, @Nullable ResolvedPom containingPom, List<MavenRepository> repositories) {
        if (gav.getGroupId() == null) {
            throw new MavenDownloadingException("Unable to download maven metadata because of a missing groupId.");
        }
        Timer.Sample sample = Timer.start();
        Timer.Builder timer = Timer.builder((String)"rewrite.maven.download").tag("group.id", gav.getGroupId()).tag("artifact.id", gav.getArtifactId()).tag("type", "metadata");
        MavenMetadata mavenMetadata = null;
        Collection<MavenRepository> normalizedRepos = this.distinctNormalizedRepositories(repositories, containingPom, null);
        HashMap<String, String> repoDownloadFailures = new HashMap<String, String>();
        for (MavenRepository repo : normalizedRepos) {
            Optional<MavenMetadata> result;
            String version = gav.getVersion();
            if (version != null) {
                if (version.endsWith("-SNAPSHOT") && !repo.isSnapshots()) {
                    repoDownloadFailures.put(repo.getUri(), "Version is a snapshot but the repository does not support snapshots.");
                    continue;
                }
                if (!version.endsWith("-SNAPSHOT") && !repo.isReleases()) {
                    repoDownloadFailures.put(repo.getUri(), "Version is a release but the repository does not support releases.");
                    continue;
                }
            }
            if ((result = this.mavenCache.getMavenMetadata(URI.create(repo.getUri()), gav)) == null) {
                boolean cacheEmptyResult;
                block21: {
                    cacheEmptyResult = false;
                    try {
                        String scheme = URI.create(repo.getUri()).getScheme();
                        String uri = repo.getUri() + (repo.getUri().endsWith("/") ? "" : "/") + gav.getGroupId().replace('.', '/') + '/' + gav.getArtifactId() + '/' + (gav.getVersion() == null ? "" : gav.getVersion() + '/') + "maven-metadata.xml";
                        if ("file".equals(scheme)) {
                            Path path = Paths.get(URI.create(uri));
                            if (Files.exists(path, new LinkOption[0])) {
                                result = Optional.of(MavenMetadata.parse(Files.readAllBytes(path)));
                            }
                        } else {
                            byte[] responseBody = this.requestAsAuthenticatedOrAnonymous(repo, uri);
                            result = Optional.of(MavenMetadata.parse(responseBody));
                        }
                    }
                    catch (Throwable exception) {
                        repoDownloadFailures.put(repo.getUri(), "Unable to download metadata. " + exception.getMessage());
                        if (!(exception instanceof MavenClientSideException)) break block21;
                        cacheEmptyResult = true;
                    }
                }
                if (result == null) {
                    try {
                        MavenMetadata derivedMeta = this.deriveMetadata(gav, repo);
                        if (derivedMeta != null) {
                            Counter.builder((String)"rewrite.maven.derived.metatdata").tag("repositoryUri", repo.getUri()).tag("group", gav.getGroupId()).tag("artifact", gav.getArtifactId()).register((MeterRegistry)Metrics.globalRegistry);
                            result = Optional.of(derivedMeta);
                        }
                    }
                    catch (Throwable exception) {
                        String repoFailure = "Unable to derive metadata. " + exception.getMessage();
                        String existingFailure = (String)repoDownloadFailures.get(repo.getUri());
                        if (existingFailure != null) {
                            repoFailure = existingFailure + " (" + repoFailure + ")";
                        }
                        repoDownloadFailures.put(repo.getUri(), repoFailure);
                    }
                }
                if (result == null && cacheEmptyResult) {
                    this.mavenCache.putMavenMetadata(URI.create(repo.getUri()), gav, null);
                }
            } else if (!result.isPresent()) {
                repoDownloadFailures.put(repo.getUri(), "Cached empty result");
            }
            if (result == null || !result.isPresent()) continue;
            mavenMetadata = mavenMetadata == null ? result.get() : this.mergeMetadata(mavenMetadata, result.get());
            this.mavenCache.putMavenMetadata(URI.create(repo.getUri()), gav, result.get());
        }
        if (mavenMetadata == null) {
            sample.stop(timer.tags(new String[]{"outcome", "unavailable"}).register((MeterRegistry)Metrics.globalRegistry));
            StringBuilder message = new StringBuilder("Unable to Download metadata for [").append(gav).append("] from the following repositories :");
            for (MavenRepository repository : normalizedRepos) {
                message.append("\n  ").append(repository.getUri());
                String repoFailure = (String)repoDownloadFailures.get(repository.getUri());
                if (repoFailure == null) continue;
                message.append(" - ").append(repoFailure);
            }
            throw new MavenDownloadingException(message.toString());
        }
        sample.stop(timer.tags(new String[]{"outcome", "success"}).register((MeterRegistry)Metrics.globalRegistry));
        return mavenMetadata;
    }

    @Nullable
    private MavenMetadata deriveMetadata(GroupArtifactVersion gav, MavenRepository repo) throws Throwable {
        if (repo.getDeriveMetadataIfMissing() != null && !repo.getDeriveMetadataIfMissing().booleanValue() || gav.getVersion() != null) {
            return null;
        }
        String scheme = URI.create(repo.getUri()).getScheme();
        String uri = repo.getUri() + (repo.getUri().endsWith("/") ? "" : "/") + gav.getGroupId().replace('.', '/') + '/' + gav.getArtifactId();
        try {
            MavenMetadata.Versioning versioning;
            if ("file".equals(scheme)) {
                versioning = this.directoryToVersioning(uri);
            } else {
                String responseBody = new String(this.requestAsAuthenticatedOrAnonymous(repo, uri));
                versioning = this.htmlIndexToVersioning(responseBody, uri);
            }
            if (versioning == null) {
                return null;
            }
            return new MavenMetadata(versioning);
        }
        catch (MavenClientSideException exception) {
            if (exception.getResponseCode() != null && exception.getResponseCode() != 404) {
                repo.setDeriveMetadataIfMissing(false);
            }
            throw exception;
        }
    }

    @Nullable
    private MavenMetadata.Versioning directoryToVersioning(String uri) {
        Path dir = Paths.get(URI.create(uri));
        if (Files.exists(dir, new LinkOption[0])) {
            MavenMetadata.Versioning versioning;
            block10: {
                DirectoryStream<Path> stream = Files.newDirectoryStream(dir);
                try {
                    ArrayList<String> versions = new ArrayList<String>();
                    for (Path path : stream) {
                        if (!Files.isDirectory(path, new LinkOption[0])) continue;
                        versions.add(path.getFileName().toString());
                    }
                    versioning = new MavenMetadata.Versioning(versions, null, null);
                    if (stream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new MavenDownloadingException("Unable to derive metadata from file repository. " + e.getMessage());
                    }
                }
                stream.close();
            }
            return versioning;
        }
        return null;
    }

    @Nullable
    private MavenMetadata.Versioning htmlIndexToVersioning(String responseBody, String uri) {
        int end;
        ArrayList<String> versions = new ArrayList<String>();
        int start = responseBody.indexOf("<a href=\"");
        while (start > 0 && (end = responseBody.indexOf("\">", start += 9)) >= 0) {
            String href = responseBody.substring(start, end).trim();
            if (href.endsWith("/")) {
                versions.add(this.hrefToVersion(href, uri));
            }
            start = responseBody.indexOf("<a href=\"", end);
        }
        if (versions.isEmpty()) {
            return null;
        }
        return new MavenMetadata.Versioning(versions, null, null);
    }

    String hrefToVersion(String href, String rootUri) {
        String version = href.startsWith(rootUri) ? href.substring(rootUri.length()) : href;
        if (version.endsWith("/")) {
            return version.substring(0, version.length() - 1);
        }
        return version;
    }

    @NonNull
    protected MavenMetadata mergeMetadata(MavenMetadata m1, MavenMetadata m2) {
        return new MavenMetadata(new MavenMetadata.Versioning(this.mergeVersions(m1.getVersioning().getVersions(), m2.getVersioning().getVersions()), Stream.concat(m1.getVersioning().getSnapshotVersions() == null ? Stream.empty() : m1.getVersioning().getSnapshotVersions().stream(), m2.getVersioning().getSnapshotVersions() == null ? Stream.empty() : m2.getVersioning().getSnapshotVersions().stream()).collect(Collectors.toList()), this.maxSnapshot(m1.getVersioning().getSnapshot(), m2.getVersioning().getSnapshot())));
    }

    private List<String> mergeVersions(List<String> versions1, List<String> versions2) {
        HashSet<String> merged = new HashSet<String>(versions1);
        merged.addAll(versions2);
        return new ArrayList<String>(merged);
    }

    @Nullable
    private MavenMetadata.Snapshot maxSnapshot(@Nullable MavenMetadata.Snapshot s1, @Nullable MavenMetadata.Snapshot s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        return s1.getTimestamp().compareTo(s2.getTimestamp()) >= 0 ? s1 : s2;
    }

    public Pom download(GroupArtifactVersion gav, @Nullable String relativePath, @Nullable ResolvedPom containingPom, List<MavenRepository> repositories) throws MavenDownloadingException {
        Pom maybeLocalPom;
        Path folderContainingPom;
        if (gav.getGroupId() == null || gav.getArtifactId() == null || gav.getVersion() == null) {
            String errorText = "Unable to download dependency " + gav;
            if (containingPom != null) {
                this.ctx.getResolutionListener().downloadError(gav, containingPom.getRequested());
            }
            throw new MavenDownloadingException(errorText);
        }
        for (Pom projectPom : this.projectPoms.values()) {
            if (!gav.getGroupId().equals(projectPom.getGroupId()) || !gav.getArtifactId().equals(projectPom.getArtifactId()) || !Objects.equals(projectPom.getValue(projectPom.getVersion()), projectPom.getValue(gav.getVersion()))) continue;
            return projectPom;
        }
        if (containingPom != null && containingPom.getRequested().getSourcePath() != null && !StringUtils.isBlank((String)relativePath) && (folderContainingPom = containingPom.getRequested().getSourcePath().getParent()) != null && (maybeLocalPom = this.projectPoms.get(folderContainingPom.resolve(Paths.get(relativePath, "pom.xml")).normalize())) != null && gav.getGroupId().equals(maybeLocalPom.getGroupId()) && gav.getArtifactId().equals(maybeLocalPom.getArtifactId()) && gav.getVersion().equals(maybeLocalPom.getVersion())) {
            return maybeLocalPom;
        }
        Collection<MavenRepository> normalizedRepos = this.distinctNormalizedRepositories(repositories, containingPom, gav.getVersion());
        Timer.Sample sample = Timer.start();
        Timer.Builder timer = Timer.builder((String)"rewrite.maven.download").tag("group.id", gav.getGroupId()).tag("artifact.id", gav.getArtifactId()).tag("type", "pom");
        HashMap<String, String> repoDownloadFailures = new HashMap<String, String>();
        String versionMaybeDatedSnapshot = this.datedSnapshotVersion(gav, containingPom, repositories, (ExecutionContext)this.ctx);
        for (MavenRepository repo : normalizedRepos) {
            String version = gav.getVersion();
            if (version.endsWith("-SNAPSHOT") && !repo.isSnapshots()) {
                repoDownloadFailures.put(repo.getUri(), "Version is a snapshot but the repository does not support snapshots.");
                continue;
            }
            if (!version.endsWith("-SNAPSHOT") && !repo.isReleases()) {
                repoDownloadFailures.put(repo.getUri(), "Version is a release but the repository does not support releases.");
                continue;
            }
            ResolvedGroupArtifactVersion resolvedGav = new ResolvedGroupArtifactVersion(repo.getUri(), gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), versionMaybeDatedSnapshot);
            Optional<Pom> result = this.mavenCache.getPom(resolvedGav);
            if (result == null) {
                URI uri = URI.create(repo.getUri() + (repo.getUri().endsWith("/") ? "" : "/") + gav.getGroupId().replace('.', '/') + '/' + gav.getArtifactId() + '/' + gav.getVersion() + '/' + gav.getArtifactId() + '-' + versionMaybeDatedSnapshot + ".pom");
                if ("file".equals(uri.getScheme())) {
                    Pom pom;
                    Path inputPath = Paths.get(gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
                    File f = new File(uri);
                    if (!f.exists()) continue;
                    FileInputStream fis = new FileInputStream(f);
                    try {
                        RawPom rawPom = RawPom.parse(fis, Objects.equals(versionMaybeDatedSnapshot, gav.getVersion()) ? null : versionMaybeDatedSnapshot);
                        Pom pom2 = rawPom.toPom(inputPath, repo).withGav(resolvedGav);
                        pom2 = pom2.withRepository(MavenRepository.MAVEN_LOCAL_USER_NEUTRAL);
                        if (!Objects.equals(versionMaybeDatedSnapshot, pom2.getVersion())) {
                            pom2 = pom2.withGav(pom2.getGav().withDatedSnapshotVersion(versionMaybeDatedSnapshot));
                        }
                        this.mavenCache.putPom(resolvedGav, pom2);
                        this.ctx.getResolutionListener().downloadSuccess(resolvedGav, containingPom);
                        sample.stop(timer.tags(new String[]{"outcome", "from maven local"}).register((MeterRegistry)Metrics.globalRegistry));
                        pom = pom2;
                    }
                    catch (Throwable rawPom) {
                        try {
                            try {
                                fis.close();
                            }
                            catch (Throwable throwable) {
                                rawPom.addSuppressed(throwable);
                            }
                            throw rawPom;
                        }
                        catch (IOException e) {
                            repoDownloadFailures.put(repo.getUri(), "Unable to download dependency. " + e.getMessage());
                        }
                    }
                    fis.close();
                    return pom;
                    continue;
                }
                try {
                    byte[] responseBody = this.requestAsAuthenticatedOrAnonymous(repo, uri.toString());
                    Path inputPath = Paths.get(gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
                    RawPom rawPom = RawPom.parse(new ByteArrayInputStream(responseBody), Objects.equals(versionMaybeDatedSnapshot, gav.getVersion()) ? null : versionMaybeDatedSnapshot);
                    Pom pom = rawPom.toPom(inputPath, repo).withGav(resolvedGav);
                    if (!Objects.equals(versionMaybeDatedSnapshot, pom.getVersion())) {
                        pom = pom.withGav(pom.getGav().withDatedSnapshotVersion(versionMaybeDatedSnapshot));
                    }
                    this.mavenCache.putPom(resolvedGav, pom);
                    this.ctx.getResolutionListener().downloadSuccess(resolvedGav, containingPom);
                    sample.stop(timer.tags(new String[]{"outcome", "downloaded"}).register((MeterRegistry)Metrics.globalRegistry));
                    return pom;
                }
                catch (Throwable exception) {
                    repoDownloadFailures.put(repo.getUri(), "Unable to download dependency. " + exception.getMessage());
                    if (!(exception instanceof MavenClientSideException)) continue;
                    this.mavenCache.putPom(resolvedGav, null);
                    continue;
                }
            }
            if (result.isPresent()) {
                sample.stop(timer.tags(new String[]{"outcome", "cached"}).register((MeterRegistry)Metrics.globalRegistry));
                return result.get();
            }
            repoDownloadFailures.put(repo.getUri(), "Cached empty result.");
        }
        sample.stop(timer.tags(new String[]{"outcome", "unavailable"}).register((MeterRegistry)Metrics.globalRegistry));
        if (containingPom != null) {
            this.ctx.getResolutionListener().downloadError(gav, containingPom.getRequested());
        }
        StringBuilder message = new StringBuilder("Unable to download dependency [" + gav + "] from the following repositories :");
        for (MavenRepository repository : normalizedRepos) {
            message.append("\n  ").append(repository.getUri());
            String repoFailure = (String)repoDownloadFailures.get(repository.getUri());
            if (repoFailure == null) continue;
            message.append(" - ").append(repoFailure);
        }
        throw new MavenDownloadingException(message.toString());
    }

    @Nullable
    private String datedSnapshotVersion(GroupArtifactVersion gav, @Nullable ResolvedPom containingPom, List<MavenRepository> repositories, ExecutionContext ctx) {
        if (gav.getVersion() != null && gav.getVersion().endsWith("-SNAPSHOT")) {
            MavenMetadata mavenMetadata;
            for (ResolvedGroupArtifactVersion pinnedSnapshotVersion : new MavenExecutionContextView(ctx).getPinnedSnapshotVersions()) {
                if (pinnedSnapshotVersion.getDatedSnapshotVersion() == null || !pinnedSnapshotVersion.getGroupId().equals(gav.getGroupId()) || !pinnedSnapshotVersion.getArtifactId().equals(gav.getArtifactId()) || !pinnedSnapshotVersion.getVersion().equals(gav.getVersion())) continue;
                return pinnedSnapshotVersion.getDatedSnapshotVersion();
            }
            try {
                mavenMetadata = this.downloadMetadata(gav, containingPom, repositories);
            }
            catch (MavenDownloadingException e) {
                return gav.getVersion();
            }
            MavenMetadata.Snapshot snapshot = mavenMetadata.getVersioning().getSnapshot();
            if (snapshot != null) {
                return gav.getVersion().replaceFirst("SNAPSHOT$", snapshot.getTimestamp() + "-" + snapshot.getBuildNumber());
            }
        }
        return gav.getVersion();
    }

    private Collection<MavenRepository> distinctNormalizedRepositories(List<MavenRepository> repositories, @Nullable ResolvedPom containingPom, @Nullable String acceptsVersion) {
        MavenRepository normalizedRepo;
        LinkedHashSet<MavenRepository> normalizedRepositories = new LinkedHashSet<MavenRepository>();
        normalizedRepositories.add(this.ctx.getLocalRepository());
        for (MavenRepository repo : repositories) {
            normalizedRepo = this.normalizeRepository(repo, containingPom);
            if (normalizedRepo == null || acceptsVersion != null && !normalizedRepo.acceptsVersion(acceptsVersion)) continue;
            normalizedRepositories.add(normalizedRepo);
        }
        for (MavenRepository repo : this.ctx.getRepositories()) {
            normalizedRepo = this.normalizeRepository(repo, containingPom);
            if (normalizedRepo == null || acceptsVersion != null && !normalizedRepo.acceptsVersion(acceptsVersion)) continue;
            normalizedRepositories.add(normalizedRepo);
        }
        normalizedRepositories.add(this.normalizeRepository(MavenRepository.MAVEN_CENTRAL, containingPom));
        return normalizedRepositories;
    }

    @Nullable
    protected MavenRepository normalizeRepository(MavenRepository originalRepository, @Nullable ResolvedPom containingPom) {
        Optional<MavenRepository> result;
        block12: {
            result = null;
            MavenRepository repository = this.applyAuthenticationToRepository(this.applyMirrors(originalRepository));
            if (containingPom != null) {
                repository = repository.withUri(containingPom.getValue(repository.getUri()));
            }
            try {
                MavenRepository normalized;
                block13: {
                    if (repository.isKnownToExist()) {
                        return repository;
                    }
                    String originalUrl = repository.getUri();
                    if ("file".equals(URI.create(originalUrl).getScheme())) {
                        return repository;
                    }
                    result = this.mavenCache.getNormalizedRepository(repository);
                    if (result != null) break block12;
                    if (!repository.getUri().toLowerCase().startsWith("http")) {
                        return null;
                    }
                    String httpsUri = repository.getUri().toLowerCase().startsWith("http:") ? repository.getUri().replaceFirst("[hH][tT][tT][pP]://", "https://") : repository.getUri();
                    HttpSender.Request.Builder request = this.applyAuthenticationToRequest(repository, this.httpSender.get(httpsUri));
                    normalized = null;
                    try {
                        this.sendRequest.apply((Object)request.build());
                        normalized = repository.withUri(httpsUri);
                    }
                    catch (MavenDownloadingException exception) {
                        normalized = repository.withUri(httpsUri);
                    }
                    catch (Throwable t) {
                        if (httpsUri.equals(originalUrl)) break block13;
                        try {
                            this.sendRequest.apply((Object)request.url(originalUrl).build());
                            normalized = new MavenRepository(repository.getId(), originalUrl, repository.isReleases(), repository.isSnapshots(), repository.getUsername(), repository.getPassword());
                        }
                        catch (MavenDownloadingException exception) {
                            normalized = new MavenRepository(repository.getId(), originalUrl, repository.isReleases(), repository.isSnapshots(), repository.getUsername(), repository.getPassword());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                this.mavenCache.putNormalizedRepository(repository, normalized);
                result = Optional.ofNullable(normalized);
            }
            catch (Exception e) {
                this.ctx.getOnError().accept(e);
                this.mavenCache.putNormalizedRepository(repository, null);
            }
        }
        return result == null || !result.isPresent() ? null : this.applyAuthenticationToRepository(result.get());
    }

    private byte[] requestAsAuthenticatedOrAnonymous(MavenRepository repo, String uriString) throws Throwable {
        try {
            return (byte[])this.sendRequest.apply((Object)this.applyAuthenticationToRequest(repo, this.httpSender.get(uriString)).build());
        }
        catch (MavenClientSideException e) {
            return (byte[])this.sendRequest.apply((Object)this.httpSender.get(uriString).build());
        }
    }

    private MavenRepository applyAuthenticationToRepository(MavenRepository repository) {
        return MavenRepositoryCredentials.apply(this.ctx.getCredentials(), repository);
    }

    private HttpSender.Request.Builder applyAuthenticationToRequest(MavenRepository repository, HttpSender.Request.Builder request) {
        if (repository.getUsername() != null && repository.getPassword() != null) {
            return request.withBasicAuthentication(repository.getUsername(), repository.getPassword());
        }
        return request;
    }

    private MavenRepository applyMirrors(MavenRepository repository) {
        return MavenRepositoryMirror.apply(this.ctx.getMirrors(), repository);
    }
}

