/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.ChangePropertyValue;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.RemoveRedundantDependencyVersions;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public final class UpgradeDependencyVersion
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number.", example="29.X")
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;
    @Option(displayName="Override managed version", description="This flag can be set to explicitly override a managed dependency's version. The default for this flag is `false`.", example="false", required=false)
    @Nullable
    private final Boolean overrideManagedVersion;

    public Validated validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    public String getDisplayName() {
        return "Upgrade Maven dependency version";
    }

    public String getDescription() {
        return "Upgrade the version of a dependency by specifying a group or group and artifact using Node Semver advanced range selectors, allowing more precise control over version updates to patch or minor releases.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final VersionComparator versionComparator = (VersionComparator)Semver.validate((String)this.newVersion, (String)this.versionPattern).getValue();
        assert (versionComparator != null);
        return new MavenIsoVisitor<ExecutionContext>(){
            private final Map<GroupArtifact, List<String>> availableVersions = new HashMap<GroupArtifact, List<String>>();

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                Xml.Document d = super.visitDocument(document, ctx);
                if (d != document) {
                    this.maybeUpdateModel();
                    this.doAfterVisit(new RemoveRedundantDependencyVersions(null, null, true));
                }
                return d;
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t;
                block9: {
                    block11: {
                        block8: {
                            String newerVersion;
                            block10: {
                                String requestedVersion;
                                t = super.visitTag(tag, ctx);
                                if (!this.isDependencyTag(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId)) break block8;
                                ResolvedDependency d = this.findDependency(tag);
                                if (d == null || (newerVersion = this.findNewerVersion(d.getGroupId(), d.getArtifactId(), d.getVersion(), ctx)) == null) break block9;
                                ResolvedManagedDependency dm = this.findManagedDependency(t);
                                if (dm != null && (requestedVersion = dm.getRequested().getVersion()).startsWith("${")) {
                                    this.doAfterVisit(new ChangePropertyValue(requestedVersion.substring(2, requestedVersion.length() - 1), newerVersion, UpgradeDependencyVersion.this.overrideManagedVersion));
                                    return t;
                                }
                                Optional version = t.getChild("version");
                                if (!version.isPresent()) break block10;
                                String requestedVersion2 = d.getRequested().getVersion();
                                if (requestedVersion2 != null && requestedVersion2.startsWith("${")) {
                                    this.doAfterVisit(new ChangePropertyValue(requestedVersion2.substring(2, requestedVersion2.length() - 1), newerVersion, UpgradeDependencyVersion.this.overrideManagedVersion));
                                    return t;
                                }
                                t = (Xml.Tag)new ChangeTagValueVisitor((Xml.Tag)version.get(), newerVersion).visitNonNull((Tree)t, (Object)0, this.getCursor());
                                break block9;
                            }
                            if (!Boolean.TRUE.equals(UpgradeDependencyVersion.this.overrideManagedVersion)) break block9;
                            Xml.Tag versionTag = Xml.Tag.build((String)("<version>" + newerVersion + "</version>"));
                            t = (Xml.Tag)new AddToTagVisitor(t, versionTag, (Comparator)new MavenTagInsertionComparator(t.getChildren())).visitNonNull((Tree)t, (Object)ctx, this.getCursor().getParent());
                            break block9;
                        }
                        if (!this.isManagedDependencyTag(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId)) break block9;
                        ResolvedManagedDependency matchedManagedDependency = this.findManagedDependency(t);
                        if (matchedManagedDependency == null) break block11;
                        if (!StringUtils.matchesGlob((String)matchedManagedDependency.getGroupId(), (String)UpgradeDependencyVersion.this.groupId) || !StringUtils.matchesGlob((String)matchedManagedDependency.getArtifactId(), (String)UpgradeDependencyVersion.this.artifactId)) break block9;
                        String requestedVersion = matchedManagedDependency.getRequested().getVersion();
                        assert (matchedManagedDependency.getVersion() != null);
                        String newerVersion = this.findNewerVersion(matchedManagedDependency.getGroupId(), matchedManagedDependency.getArtifactId(), matchedManagedDependency.getVersion(), ctx);
                        if (newerVersion != null) {
                            if (requestedVersion.startsWith("${")) {
                                this.doAfterVisit(new ChangePropertyValue(requestedVersion.substring(2, requestedVersion.length() - 1), newerVersion, UpgradeDependencyVersion.this.overrideManagedVersion));
                                return t;
                            }
                            Xml.Tag childVersionTag = t.getChild("version").orElse(null);
                            if (childVersionTag != null) {
                                t = (Xml.Tag)new ChangeTagValueVisitor(childVersionTag, newerVersion).visitNonNull((Tree)t, (Object)0, this.getCursor());
                            }
                        }
                        break block9;
                    }
                    for (ResolvedManagedDependency dm : this.getResolutionResult().getPom().getDependencyManagement()) {
                        if (dm.getBomGav() == null) continue;
                        ResolvedGroupArtifactVersion bom = dm.getBomGav();
                        String tagGroup = this.getResolutionResult().getPom().getValue(tag.getChildValue("groupId").orElse(this.getResolutionResult().getPom().getGroupId()));
                        String tagArtifactId = this.getResolutionResult().getPom().getValue(tag.getChildValue("artifactId").orElse(""));
                        if (tagGroup == null || tagArtifactId == null || !tagGroup.equals(bom.getGroupId()) || !tagArtifactId.equals(bom.getArtifactId())) continue;
                        String requestedVersion = dm.getRequestedBom().getVersion();
                        String newerVersion = this.findNewerVersion(bom.getGroupId(), bom.getArtifactId(), bom.getVersion(), ctx);
                        if (newerVersion == null) break;
                        if (requestedVersion.startsWith("${")) {
                            this.doAfterVisit(new ChangePropertyValue(requestedVersion.substring(2, requestedVersion.length() - 1), newerVersion, UpgradeDependencyVersion.this.overrideManagedVersion));
                            return t;
                        }
                        Xml.Tag childVersionTag = t.getChild("version").orElse(null);
                        if (childVersionTag == null) break;
                        t = (Xml.Tag)new ChangeTagValueVisitor(childVersionTag, newerVersion).visitNonNull((Tree)t, (Object)0, this.getCursor());
                        break;
                    }
                }
                return t;
            }

            @Nullable
            private String findNewerVersion(String groupId, String artifactId, String version, ExecutionContext ctx) {
                GroupArtifact ga = new GroupArtifact(groupId, artifactId);
                try {
                    List artifactVersions = this.availableVersions.computeIfAbsent(ga, k -> {
                        MavenMetadata mavenMetadata = this.downloadMetadata(groupId, artifactId, ctx);
                        ArrayList<String> versions = new ArrayList<String>();
                        for (String v : mavenMetadata.getVersioning().getVersions()) {
                            if (!versionComparator.isValid(version, v)) continue;
                            versions.add(v);
                        }
                        return versions;
                    });
                    return versionComparator.upgrade(version, (Collection)artifactVersions).orElse(null);
                }
                catch (Exception e) {
                    ctx.getOnError().accept(e);
                    return null;
                }
            }
        };
    }

    public UpgradeDependencyVersion(String groupId, String artifactId, String newVersion, @Nullable String versionPattern, @Nullable Boolean overrideManagedVersion) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
        this.overrideManagedVersion = overrideManagedVersion;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @Nullable
    public Boolean getOverrideManagedVersion() {
        return this.overrideManagedVersion;
    }

    @NonNull
    public String toString() {
        return "UpgradeDependencyVersion(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ", overrideManagedVersion=" + this.getOverrideManagedVersion() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeDependencyVersion)) {
            return false;
        }
        UpgradeDependencyVersion other = (UpgradeDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$overrideManagedVersion = this.getOverrideManagedVersion();
        Boolean other$overrideManagedVersion = other.getOverrideManagedVersion();
        if (this$overrideManagedVersion == null ? other$overrideManagedVersion != null : !((Object)this$overrideManagedVersion).equals(other$overrideManagedVersion)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeDependencyVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $overrideManagedVersion = this.getOverrideManagedVersion();
        result = result * 59 + ($overrideManagedVersion == null ? 43 : ((Object)$overrideManagedVersion).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

