/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.utilities;

import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.License;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.tree.Xml;

public final class PrintMavenAsCycloneDxBom {
    private PrintMavenAsCycloneDxBom() {
    }

    public static String print(Xml.Document maven) {
        MavenResolutionResult resolutionResult = (MavenResolutionResult)maven.getMarkers().findFirst(MavenResolutionResult.class).orElseThrow(() -> new IllegalStateException("Expected to find a maven resolution marker"));
        ResolvedPom pom = resolutionResult.getPom();
        StringBuilder bom = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        bom.append("<bom xmlns=\"http://cyclonedx.org/schema/bom/1.2\" serialNumber=\"urn:uuid:").append(maven.getId().toString()).append("\" version=\"1\">\n");
        PrintMavenAsCycloneDxBom.writeMetadata(pom, bom);
        List<ResolvedDependency> compileScopeDependencies = resolutionResult.getDependencies().get((Object)Scope.Compile);
        List<ResolvedDependency> providedScopeDependencies = resolutionResult.getDependencies().get((Object)Scope.Provided);
        if (providedScopeDependencies != null && !providedScopeDependencies.isEmpty()) {
            Set artifacts = compileScopeDependencies.stream().map(PrintMavenAsCycloneDxBom::dependencyToGroupArtifact).collect(Collectors.toSet());
            providedScopeDependencies = providedScopeDependencies.stream().filter(d -> !artifacts.contains(PrintMavenAsCycloneDxBom.dependencyToGroupArtifact(d))).collect(Collectors.toList());
        }
        PrintMavenAsCycloneDxBom.writeComponents(compileScopeDependencies, providedScopeDependencies, bom);
        PrintMavenAsCycloneDxBom.writeDependencies(ListUtils.concatAll(compileScopeDependencies, providedScopeDependencies), bom);
        bom.append("</bom>\n");
        return bom.toString();
    }

    private static GroupArtifact dependencyToGroupArtifact(ResolvedDependency dependency) {
        return new GroupArtifact(dependency.getGroupId(), dependency.getArtifactId());
    }

    private static void writeMetadata(ResolvedPom pom, StringBuilder bom) {
        bom.append("    <metadata>\n");
        bom.append("        <timestamp>").append(Instant.now().toString()).append("</timestamp>\n");
        bom.append("        <tools>\n");
        bom.append("            <tool>\n");
        bom.append("                <vendor>OpenRewrite</vendor>\n");
        bom.append("                <name>OpenRewrite CycloneDX</name>\n");
        bom.append("                <version>7.18.0</version>\n");
        bom.append("            </tool>\n");
        bom.append("        </tools>\n");
        String packaging = "war".equals(pom.getPackaging()) || "ear".equals(pom.getPackaging()) ? "application" : "library";
        PrintMavenAsCycloneDxBom.writeComponent(Scope.Compile, pom.getValue(pom.getGroupId()), pom.getArtifactId(), pom.getValue(pom.getVersion()), packaging, pom.getRequested().getLicenses(), bom);
        bom.append("    </metadata>\n");
    }

    private static void writeComponents(List<ResolvedDependency> dependencies, List<ResolvedDependency> provided, StringBuilder bom) {
        if (dependencies.isEmpty()) {
            return;
        }
        bom.append("    <components>\n");
        for (ResolvedDependency dependency : dependencies) {
            PrintMavenAsCycloneDxBom.writeComponent(Scope.Compile, dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), "library", dependency.getLicenses(), bom);
        }
        for (ResolvedDependency dependency : provided) {
            PrintMavenAsCycloneDxBom.writeComponent(Scope.Provided, dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), "library", dependency.getLicenses(), bom);
        }
        bom.append("    </components>\n");
    }

    private static void writeDependencies(List<ResolvedDependency> dependencies, StringBuilder bom) {
        if (dependencies.isEmpty()) {
            return;
        }
        bom.append("    <dependencies>\n");
        for (ResolvedDependency dependency : dependencies) {
            PrintMavenAsCycloneDxBom.writeDependency(dependency, bom);
        }
        bom.append("    </dependencies>\n");
    }

    private static void writeDependency(ResolvedDependency dependency, StringBuilder bom) {
        String bomReference = PrintMavenAsCycloneDxBom.getBomReference(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
        bom.append("        <dependency ref=\"").append(bomReference).append("\">\n");
        if (dependency.getDependencies() != null) {
            for (ResolvedDependency nested : dependency.getDependencies()) {
                bom.append("            <dependency ref=\"").append(PrintMavenAsCycloneDxBom.getBomReference(nested.getGroupId(), nested.getArtifactId(), nested.getVersion())).append("\"/>\n");
            }
        }
        bom.append("        </dependency>\n");
    }

    private static void writeComponent(Scope scope, String groupId, String artifactId, String version, String packaging, List<License> licenses, StringBuilder bom) {
        String indent = "        ";
        String bomReference = PrintMavenAsCycloneDxBom.getBomReference(groupId, artifactId, version);
        bom.append(indent).append("<component bom-ref=\"").append(bomReference).append("\" type=\"").append(packaging).append("\">\n");
        bom.append(indent).append("    <group>").append(groupId).append("</group>\n");
        bom.append(indent).append("    <name>").append(artifactId).append("</name>\n");
        bom.append(indent).append("    <version>").append(version).append("</version>\n");
        if (scope != null) {
            String cycloneScope;
            switch (scope) {
                case Compile: 
                case System: {
                    cycloneScope = "required";
                    break;
                }
                case None: 
                case Invalid: 
                case Test: {
                    cycloneScope = "excluded";
                    break;
                }
                default: {
                    cycloneScope = "optional";
                }
            }
            bom.append(indent).append("    <scope>").append(cycloneScope).append("</scope>\n");
        }
        PrintMavenAsCycloneDxBom.writeLicenses(licenses, bom, indent);
        bom.append(indent).append("    <purl>").append(bomReference).append("</purl>\n");
        bom.append(indent).append("</component>\n");
    }

    private static void writeLicenses(List<License> licenses, StringBuilder bom, String indent) {
        if (!licenses.isEmpty()) {
            bom.append(indent).append("    <licenses>\n");
            for (License license : licenses) {
                bom.append(indent).append("        <license>\n");
                String spdxId = null;
                if (license.getType() == License.Type.Apache2) {
                    spdxId = "Apache-2.0";
                }
                if (spdxId != null) {
                    bom.append(indent).append("            <id>").append(spdxId).append("</id>\n");
                }
                bom.append(indent).append("            <name>").append(license.getName()).append("</name>\n");
                bom.append(indent).append("        </license>\n");
            }
            bom.append(indent).append("      </licenses>\n");
        }
    }

    private static String getBomReference(String group, String artifactId, String version) {
        return "pkg:maven/" + group + "/" + artifactId + "@" + version + "?type=jar";
    }
}

