/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.AddManagedDependencyVisitor;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.maven.tree.Version;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

@Incubating(since="7.19.0")
public final class ManageDependencies
extends Recipe {
    private static final XPathMatcher MANAGED_DEPENDENCIES_MATCHER = new XPathMatcher("/project/dependencyManagement/dependencies");
    @Option(displayName="Group", description="Group glob expression pattern used to match dependencies that should be managed.Group is the the first part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="com.google.*")
    private final String groupPattern;
    @Option(displayName="Artifact", description="Artifact glob expression pattern used to match dependencies that should be managed.Artifact is the second part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="guava*", required=false)
    @Nullable
    private final String artifactPattern;
    @Option(displayName="Version", description="Version to use for the dependency in dependency management. Defaults to the existing version found on the matching dependency, or the max version if multiple dependencies match the glob expression patterns.", example="1.0.0", required=false)
    @Nullable
    private final String version;
    @Option(displayName="Add to the root pom", description="Add to the root pom where root is the eldest parent of the pom within the source set.", example="true", required=false)
    @Nullable
    private final Boolean addToRootPom;

    public String getDisplayName() {
        return "Manage dependencies";
    }

    public String getDescription() {
        return "Make existing dependencies managed by moving their version to be specified in the dependencyManagement section of the POM.";
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        final HashMap rootGavToDependencies = new HashMap();
        if (Boolean.TRUE.equals(this.addToRootPom)) {
            for (SourceFile source : before) {
                new MavenIsoVisitor<ExecutionContext>(){

                    @Override
                    public Xml.Document visitDocument(Xml.Document document, ExecutionContext executionContext) {
                        Xml.Document doc = super.visitDocument(document, executionContext);
                        List<ResolvedDependency> manageableDependencies = this.findDependencies(ManageDependencies.this.groupPattern, ManageDependencies.this.artifactPattern != null ? ManageDependencies.this.artifactPattern : "*");
                        ResolvedGroupArtifactVersion root = ManageDependencies.this.findRootPom(this.getResolutionResult()).getPom().getGav();
                        rootGavToDependencies.computeIfAbsent(new GroupArtifactVersion(root.getGroupId(), root.getArtifactId(), root.getVersion()), v -> new ArrayList()).addAll(manageableDependencies);
                        return doc;
                    }
                }.visit((Tree)source, ctx);
            }
        }
        return ListUtils.map(before, s -> s.getMarkers().findFirst(MavenResolutionResult.class).map(javaProject -> new MavenVisitor<ExecutionContext>(){

            public Xml visitDocument(Xml.Document document, ExecutionContext executionContext) {
                Collection<ResolvedDependency> manageableDependencies;
                Xml maven = super.visitDocument(document, (Object)executionContext);
                if (Boolean.TRUE.equals(ManageDependencies.this.addToRootPom)) {
                    ResolvedPom pom = this.getResolutionResult().getPom();
                    GroupArtifactVersion gav = new GroupArtifactVersion(pom.getGav().getGroupId(), pom.getGav().getArtifactId(), pom.getGav().getVersion());
                    manageableDependencies = (Collection)rootGavToDependencies.get(gav);
                } else {
                    manageableDependencies = this.findDependencies(ManageDependencies.this.groupPattern, ManageDependencies.this.artifactPattern != null ? ManageDependencies.this.artifactPattern : "*");
                }
                if (manageableDependencies != null) {
                    HashMap<GroupArtifact, GroupArtifactVersion> dependenciesToManage = new HashMap<GroupArtifact, GroupArtifactVersion>();
                    String selectedVersion = ManageDependencies.this.version;
                    for (ResolvedDependency rmd : manageableDependencies) {
                        if (ManageDependencies.this.version != null) {
                            dependenciesToManage.putIfAbsent(new GroupArtifact(rmd.getGroupId(), rmd.getArtifactId()), new GroupArtifactVersion(rmd.getGroupId(), rmd.getArtifactId(), ManageDependencies.this.version));
                            continue;
                        }
                        if (selectedVersion == null) {
                            selectedVersion = rmd.getVersion();
                        } else if (new Version(rmd.getVersion()).compareTo(new Version(selectedVersion)) > 0) {
                            selectedVersion = rmd.getVersion();
                        }
                        dependenciesToManage.put(new GroupArtifact(rmd.getGroupId(), rmd.getArtifactId()), new GroupArtifactVersion(rmd.getGroupId(), rmd.getArtifactId(), selectedVersion));
                    }
                    for (GroupArtifactVersion gav : dependenciesToManage.values()) {
                        this.doAfterVisit((TreeVisitor)new AddManagedDependencyVisitor(gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), null, null, null, null, null));
                    }
                }
                this.doAfterVisit((TreeVisitor)new RemoveVersionTagVisitor(ManageDependencies.this.groupPattern, ManageDependencies.this.artifactPattern != null ? ManageDependencies.this.artifactPattern : "*"));
                return maven;
            }
        }.visit((Tree)s, ctx)).map(SourceFile.class::cast).orElse((SourceFile)s));
    }

    private MavenResolutionResult findRootPom(MavenResolutionResult pom) {
        if (pom.getParent() == null) {
            return pom;
        }
        return this.findRootPom(pom.getParent());
    }

    public ManageDependencies(String groupPattern, @Nullable String artifactPattern, @Nullable String version, @Nullable Boolean addToRootPom) {
        this.groupPattern = groupPattern;
        this.artifactPattern = artifactPattern;
        this.version = version;
        this.addToRootPom = addToRootPom;
    }

    public String getGroupPattern() {
        return this.groupPattern;
    }

    @Nullable
    public String getArtifactPattern() {
        return this.artifactPattern;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public Boolean getAddToRootPom() {
        return this.addToRootPom;
    }

    @NonNull
    public String toString() {
        return "ManageDependencies(groupPattern=" + this.getGroupPattern() + ", artifactPattern=" + this.getArtifactPattern() + ", version=" + this.getVersion() + ", addToRootPom=" + this.getAddToRootPom() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ManageDependencies)) {
            return false;
        }
        ManageDependencies other = (ManageDependencies)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$addToRootPom = this.getAddToRootPom();
        Boolean other$addToRootPom = other.getAddToRootPom();
        if (this$addToRootPom == null ? other$addToRootPom != null : !((Object)this$addToRootPom).equals(other$addToRootPom)) {
            return false;
        }
        String this$groupPattern = this.getGroupPattern();
        String other$groupPattern = other.getGroupPattern();
        if (this$groupPattern == null ? other$groupPattern != null : !this$groupPattern.equals(other$groupPattern)) {
            return false;
        }
        String this$artifactPattern = this.getArtifactPattern();
        String other$artifactPattern = other.getArtifactPattern();
        if (this$artifactPattern == null ? other$artifactPattern != null : !this$artifactPattern.equals(other$artifactPattern)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ManageDependencies;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $addToRootPom = this.getAddToRootPom();
        result = result * 59 + ($addToRootPom == null ? 43 : ((Object)$addToRootPom).hashCode());
        String $groupPattern = this.getGroupPattern();
        result = result * 59 + ($groupPattern == null ? 43 : $groupPattern.hashCode());
        String $artifactPattern = this.getArtifactPattern();
        result = result * 59 + ($artifactPattern == null ? 43 : $artifactPattern.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    private static class RemoveVersionTagVisitor
    extends MavenIsoVisitor<ExecutionContext> {
        private final String groupPattern;
        private final String artifactPattern;

        public RemoveVersionTagVisitor(String groupPattern, String artifactPattern) {
            this.groupPattern = groupPattern;
            this.artifactPattern = artifactPattern;
        }

        @Override
        public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (this.isDependencyTag() && this.isDependencyTag(this.groupPattern, this.artifactPattern)) {
                tag.getChild("version").ifPresent(versionTag -> this.doAfterVisit((TreeVisitor)new RemoveContentVisitor((Content)versionTag, false)));
                return tag;
            }
            return super.visitTag(tag, ctx);
        }
    }
}

