/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.annotation.AnnotationTarget;
import kotlin.jvm.functions.Function1;
import org.jetbrains.kotlin.backend.common.extensions.IrGenerationExtension;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.cli.jvm.JvmArgumentsKt;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompilerKt;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.VfsBasedProjectEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.SingleRootFileViewProvider;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.constant.EvaluatedConstTracker;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporterFactory;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.Fir2IrConfiguration;
import org.jetbrains.kotlin.fir.backend.Fir2IrExtensions;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.java.FirProjectSessionProvider;
import org.jetbrains.kotlin.fir.pipeline.AnalyseKt;
import org.jetbrains.kotlin.fir.pipeline.ConvertToIrKt;
import org.jetbrains.kotlin.fir.pipeline.Fir2IrActualizedResult;
import org.jetbrains.kotlin.fir.pipeline.FirResult;
import org.jetbrains.kotlin.fir.pipeline.FirUtilsKt;
import org.jetbrains.kotlin.fir.pipeline.ModuleCompilerAnalyzedOutput;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.session.FirSessionFactoryHelper;
import org.jetbrains.kotlin.fir.session.environment.AbstractProjectEnvironment;
import org.jetbrains.kotlin.fir.session.environment.AbstractProjectFileSearchScope;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.incremental.IncrementalFirJvmCompilerRunnerKt;
import org.jetbrains.kotlin.incremental.components.EnumWhenTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatformAnalyzerServices;
import org.jetbrains.kotlin.utils.PathUtil;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.kotlin.KotlinTypeMapping;
import org.openrewrite.kotlin.internal.CompiledSource;
import org.openrewrite.kotlin.internal.KotlinParserVisitor;
import org.openrewrite.kotlin.internal.KotlinSource;
import org.openrewrite.kotlin.internal.KotlinTreeParserVisitor;
import org.openrewrite.kotlin.internal.PsiElementAssociations;
import org.openrewrite.kotlin.internal.PsiTreePrinter;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class KotlinParser
implements Parser {
    public static final String SKIP_SOURCE_SET_TYPE_GENERATION = "org.openrewrite.kotlin.skipSourceSetTypeGeneration";
    private String sourceSet = "main";
    @Nullable
    private transient JavaSourceSet sourceSetProvenance;
    @Nullable
    private final Collection<Path> classpath;
    private final List<NamedStyles> styles;
    private final boolean logCompilationWarningsAndErrors;
    private final JavaTypeCache typeCache;
    private final String moduleName;
    private final KotlinLanguageLevel languageLevel;
    private final boolean isKotlinScript;

    public Stream<SourceFile> parse(String ... sources) {
        Pattern packagePattern = Pattern.compile("^package\\s+([^;]+);");
        Pattern classPattern = Pattern.compile("(class|interface|enum)\\s*(<[^>]*>)?\\s+(\\w+)");
        Function<String, String> simpleName = sourceStr -> {
            Matcher classMatcher = classPattern.matcher((CharSequence)sourceStr);
            return classMatcher.find() ? classMatcher.group(3) : null;
        };
        return this.parseInputs(Arrays.stream(sources).map(sourceFile -> {
            Matcher packageMatcher = packagePattern.matcher((CharSequence)sourceFile);
            String pkg = packageMatcher.find() ? packageMatcher.group(1).replace('.', '/') + "/" : "";
            String className = Optional.ofNullable((String)simpleName.apply((String)sourceFile)).orElse(Long.toString(System.nanoTime())) + ".kt";
            Path path = Paths.get(pkg + className, new String[0]);
            return new Parser.Input(path, null, () -> new ByteArrayInputStream(sourceFile.getBytes(StandardCharsets.UTF_8)), true);
        }).collect(Collectors.toList()), null, (ExecutionContext)new InMemoryExecutionContext());
    }

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        CompiledSource compilerCus;
        ParsingExecutionContextView pctx = ParsingExecutionContextView.view((ExecutionContext)ctx);
        ParsingEventListener parsingListener = pctx.getParsingListener();
        Disposable disposable = Disposer.newDisposable();
        try {
            compilerCus = this.parse(this.acceptedInputs(sources).collect(Collectors.toList()), disposable, (ExecutionContext)pctx);
        }
        catch (Exception e) {
            return this.acceptedInputs(sources).map(input -> ParseError.build((Parser)this, (Parser.Input)input, (Path)relativeTo, (ExecutionContext)ctx, (Throwable)e));
        }
        FirSession firSession = compilerCus.getFirSession();
        return Stream.concat(compilerCus.getSources().stream().map(kotlinSource -> {
            try {
                SourceFile kcuFir;
                KotlinParserVisitor firParserVisitor = new KotlinParserVisitor((KotlinSource)kotlinSource, relativeTo, (List<? extends NamedStyles>)this.styles, this.typeCache, firSession, ctx);
                assert (kotlinSource.getFirFile() != null);
                SourceFile kcu = kcuFir = (SourceFile)firParserVisitor.visitFile(kotlinSource.getFirFile(), ctx);
                boolean switchToPsiParser = false;
                if (switchToPsiParser) {
                    K.CompilationUnit kcuPsi = null;
                    KotlinTypeMapping typeMapping = new KotlinTypeMapping(new JavaTypeCache(), firSession, kotlinSource.getFirFile().getSymbol());
                    PsiElementAssociations associations = new PsiElementAssociations(typeMapping, kotlinSource.getFirFile());
                    associations.initialize();
                    KotlinTreeParserVisitor psiParser = new KotlinTreeParserVisitor((KotlinSource)kotlinSource, associations, this.styles, relativeTo, ctx);
                    kcuPsi = psiParser.parse();
                    if (kcuPsi == null) {
                        kcuPsi = kcuFir;
                        System.out.println("=========\n LST and types from FIR-based-parser");
                        System.out.println(PsiTreePrinter.print((Tree)kcuFir));
                    } else {
                        String treeFir = PsiTreePrinter.print((Tree)kcuFir);
                        String treePsi = PsiTreePrinter.print((Tree)kcuPsi);
                        System.out.println("=========\n LST and types from FIR-based-parser");
                        System.out.println(treeFir);
                        System.out.println("=========\n LST and types from PSI-based-parser");
                        System.out.println(treePsi);
                    }
                    kcu = kcuPsi;
                }
                parsingListener.parsed(kotlinSource.getInput(), kcu);
                return this.requirePrintEqualsInput(kcu, kotlinSource.getInput(), relativeTo, ctx);
            }
            catch (Throwable t) {
                ctx.getOnError().accept(t);
                return ParseError.build((Parser)this, (Parser.Input)kotlinSource.getInput(), (Path)relativeTo, (ExecutionContext)ctx, (Throwable)t);
            }
        }), Stream.generate(() -> {
            Disposer.dispose((Disposable)disposable);
            return null;
        }).limit(1L)).filter(Objects::nonNull);
    }

    public boolean accept(Path path) {
        String p = path.toString();
        return p.endsWith(".kt") || p.endsWith(".kts");
    }

    public KotlinParser reset() {
        this.typeCache.clear();
        return this;
    }

    @Deprecated
    public void setSourceSet(String sourceSet) {
        this.sourceSetProvenance = null;
        this.sourceSet = sourceSet;
    }

    @Deprecated
    public JavaSourceSet getSourceSet(ExecutionContext ctx) {
        if (this.sourceSetProvenance == null) {
            this.sourceSetProvenance = (Boolean)ctx.getMessage(SKIP_SOURCE_SET_TYPE_GENERATION, (Object)false) != false ? new JavaSourceSet(Tree.randomId(), this.sourceSet, Collections.emptyList()) : JavaSourceSet.build((String)this.sourceSet, this.classpath == null ? Collections.emptyList() : this.classpath, (JavaTypeCache)this.typeCache, (boolean)false);
        }
        return this.sourceSetProvenance;
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve(this.isKotlinScript ? "openRewriteFile.kts" : "openRewriteFile.kt");
    }

    public static Builder builder() {
        return new Builder();
    }

    public CompiledSource parse(List<Parser.Input> sources, Disposable disposable, ExecutionContext ctx) {
        CompilerConfiguration compilerConfiguration = this.compilerConfiguration();
        if (this.classpath != null) {
            for (Path path : this.classpath) {
                File file;
                try {
                    file = path.toFile();
                }
                catch (UnsupportedOperationException ex) {
                    continue;
                }
                JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)compilerConfiguration, (File)file);
            }
        }
        JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)compilerConfiguration, (File)PathUtil.getResourcePathForClass(AnnotationTarget.class));
        K2JVMCompilerArguments arguments = new K2JVMCompilerArguments();
        JvmArgumentsKt.configureJdkHome((CompilerConfiguration)compilerConfiguration, (K2JVMCompilerArguments)arguments);
        JvmArgumentsKt.configureJavaModulesContentRoots((CompilerConfiguration)compilerConfiguration, (K2JVMCompilerArguments)arguments);
        JvmArgumentsKt.configureAdvancedJvmOptions((CompilerConfiguration)compilerConfiguration, (K2JVMCompilerArguments)arguments);
        JvmArgumentsKt.configureKlibPaths((CompilerConfiguration)compilerConfiguration, (K2JVMCompilerArguments)arguments);
        JvmArgumentsKt.configureContentRootsFromClassPath((CompilerConfiguration)compilerConfiguration, (K2JVMCompilerArguments)arguments);
        JvmContentRootsKt.configureJdkClasspathRoots((CompilerConfiguration)compilerConfiguration);
        IncrementalFirJvmCompilerRunnerKt.configureBaseRoots((CompilerConfiguration)compilerConfiguration, (K2JVMCompilerArguments)arguments);
        Module module = (Module)K2JVMCompilerKt.configureModuleChunk((CompilerConfiguration)compilerConfiguration, (K2JVMCompilerArguments)arguments, null).getModules().get(0);
        KotlinCoreEnvironment environment = KotlinCoreEnvironment.createForProduction((Disposable)disposable, (CompilerConfiguration)compilerConfiguration, (EnvironmentConfigFiles)EnvironmentConfigFiles.JVM_CONFIG_FILES);
        ArrayList<KtFile> ktFiles = new ArrayList<KtFile>(sources.size());
        ArrayList<KotlinSource> kotlinSources = new ArrayList<KotlinSource>(sources.size());
        for (int i = 0; i < sources.size(); ++i) {
            Parser.Input source = sources.get(i);
            String fileName = "openRewriteFile.kt".equals(source.getPath().toString()) ? "openRewriteFile" + i + ".kt" : ("openRewriteFile.kts".equals(source.getPath().toString()) ? "openRewriteFile" + i + ".kts" : source.getPath().toString());
            LightVirtualFile vFile = new LightVirtualFile(fileName, (FileType)KotlinFileType.INSTANCE, (CharSequence)StringUtilRt.convertLineSeparators((String)source.getSource(ctx).readFully()));
            SingleRootFileViewProvider fileViewProvider = new SingleRootFileViewProvider(PsiManager.getInstance((Project)environment.getProject()), (VirtualFile)vFile);
            KtFile file = (KtFile)fileViewProvider.getPsi((Language)KotlinLanguage.INSTANCE);
            assert (file != null);
            ktFiles.add(file);
            kotlinSources.add(new KotlinSource(source, file));
        }
        BaseDiagnosticsCollector diagnosticsReporter = DiagnosticReporterFactory.INSTANCE.createReporter(false);
        Function1 providerFunction1 = arg_0 -> ((KotlinCoreEnvironment)environment).createPackagePartProvider(arg_0);
        VfsBasedProjectEnvironment projectEnvironment = new VfsBasedProjectEnvironment(environment.getProject(), VirtualFileManager.getInstance().getFileSystem("file"), providerFunction1);
        AbstractProjectFileSearchScope sourceScope = projectEnvironment.getSearchScopeByPsiFiles(ktFiles, false);
        sourceScope.plus(projectEnvironment.getSearchScopeForProjectJavaSources());
        AbstractProjectFileSearchScope libraryScope = projectEnvironment.getSearchScopeForProjectLibraries();
        LanguageVersionSettings languageVersionSettings = (LanguageVersionSettings)compilerConfiguration.getNotNull(CommonConfigurationKeys.LANGUAGE_VERSION_SETTINGS);
        FirProjectSessionProvider sessionProvider = new FirProjectSessionProvider();
        Function1 dependencyListBuilderProvider = builder -> {
            List jvmContentFiles = JvmContentRootsKt.getJvmClasspathRoots((CompilerConfiguration)compilerConfiguration);
            ArrayList<Path> jvmContentPaths = new ArrayList<Path>(jvmContentFiles.size());
            for (File jvmContentFile : jvmContentFiles) {
                jvmContentPaths.add(jvmContentFile.toPath());
            }
            builder.dependencies(jvmContentPaths);
            List jvmModularFiles = JvmContentRootsKt.getJvmModularRoots((CompilerConfiguration)compilerConfiguration);
            ArrayList<Path> jvmModularPaths = new ArrayList<Path>(jvmModularFiles.size());
            for (File jvmModularFile : jvmModularFiles) {
                jvmModularPaths.add(jvmModularFile.toPath());
            }
            builder.dependencies(jvmModularPaths);
            return Unit.INSTANCE;
        };
        Function1 sessionConfigurator = session -> Unit.INSTANCE;
        FirSession firSession = FirSessionFactoryHelper.INSTANCE.createSessionWithDependencies(Name.identifier((String)module.getModuleName()), JvmPlatforms.INSTANCE.getUnspecifiedJvmPlatform(), (PlatformDependentAnalyzerServices)JvmPlatformAnalyzerServices.INSTANCE, sessionProvider, (AbstractProjectEnvironment)projectEnvironment, languageVersionSettings, sourceScope, libraryScope, (LookupTracker)compilerConfiguration.get(CommonConfigurationKeys.LOOKUP_TRACKER), (EnumWhenTracker)compilerConfiguration.get(CommonConfigurationKeys.ENUM_WHEN_TRACKER), null, Collections.emptyList(), true, dependencyListBuilderProvider, sessionConfigurator);
        List rawFir = FirUtilsKt.buildFirFromKtFiles((FirSession)firSession, ktFiles);
        Pair result = AnalyseKt.runResolution((FirSession)firSession, (List)rawFir);
        assert (kotlinSources.size() == ((List)result.getSecond()).size());
        AnalyseKt.runCheckers((FirSession)firSession, (ScopeSession)((ScopeSession)result.getFirst()), (List)((List)result.getSecond()), (DiagnosticReporter)diagnosticsReporter);
        ModuleCompilerAnalyzedOutput analyzedOutput = new ModuleCompilerAnalyzedOutput(firSession, (ScopeSession)result.getFirst(), (List)result.getSecond());
        FirResult firResult = new FirResult(Collections.singletonList(analyzedOutput));
        Fir2IrExtensions.Default extensions = Fir2IrExtensions.Default.INSTANCE;
        Fir2IrConfiguration irConfiguration = new Fir2IrConfiguration(languageVersionSettings, compilerConfiguration.getBoolean(JVMConfigurationKeys.LINK_VIA_SIGNATURES), (EvaluatedConstTracker)compilerConfiguration.putIfAbsent(CommonConfigurationKeys.EVALUATED_CONST_TRACKER, (Object)EvaluatedConstTracker.Companion.create()));
        List irGenerationExtensions = IrGenerationExtension.Companion.getInstances(projectEnvironment.getProject());
        Fir2IrActualizedResult actualizedResult = null;
        try {
            actualizedResult = ConvertToIrKt.convertToIrAndActualizeForJvm((FirResult)firResult, (Fir2IrExtensions)extensions, (Fir2IrConfiguration)irConfiguration, (Collection)irGenerationExtensions, (DiagnosticReporter)diagnosticsReporter);
            assert (kotlinSources.size() == actualizedResult.getIrModuleFragment().getFiles().size());
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < kotlinSources.size(); ++i) {
            ((KotlinSource)kotlinSources.get(i)).setFirFile((FirFile)((List)result.getSecond()).get(i));
            if (actualizedResult == null) continue;
            ((KotlinSource)kotlinSources.get(i)).setIrFile((IrFile)actualizedResult.getIrModuleFragment().getFiles().get(i));
        }
        return new CompiledSource(firSession, kotlinSources);
    }

    private CompilerConfiguration compilerConfiguration() {
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.put(CommonConfigurationKeys.MODULE_NAME, (Object)this.moduleName);
        compilerConfiguration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, this.logCompilationWarningsAndErrors ? new PrintingMessageCollector(System.err, MessageRenderer.PLAIN_FULL_PATHS, true) : MessageCollector.Companion.getNONE());
        compilerConfiguration.put(CommonConfigurationKeys.LANGUAGE_VERSION_SETTINGS, (Object)new LanguageVersionSettingsImpl(this.getLanguageVersion(this.languageLevel), this.getApiVersion(this.languageLevel)));
        compilerConfiguration.put(CommonConfigurationKeys.USE_FIR, (Object)true);
        compilerConfiguration.put(JVMConfigurationKeys.DO_NOT_CLEAR_BINDING_CONTEXT, (Object)true);
        compilerConfiguration.put(CommonConfigurationKeys.ALLOW_ANY_SCRIPTS_IN_SOURCE_ROOTS, (Object)true);
        compilerConfiguration.put(CommonConfigurationKeys.INCREMENTAL_COMPILATION, (Object)true);
        compilerConfiguration.put(JVMConfigurationKeys.LINK_VIA_SIGNATURES, (Object)true);
        JvmContentRootsKt.addJvmSdkRoots((CompilerConfiguration)compilerConfiguration, (List)PathUtil.getJdkClassesRootsFromCurrentJre());
        return compilerConfiguration;
    }

    private LanguageVersion getLanguageVersion(KotlinLanguageLevel languageLevel) {
        switch (languageLevel) {
            case KOTLIN_1_0: {
                return LanguageVersion.KOTLIN_1_0;
            }
            case KOTLIN_1_1: {
                return LanguageVersion.KOTLIN_1_1;
            }
            case KOTLIN_1_2: {
                return LanguageVersion.KOTLIN_1_2;
            }
            case KOTLIN_1_3: {
                return LanguageVersion.KOTLIN_1_3;
            }
            case KOTLIN_1_4: {
                return LanguageVersion.KOTLIN_1_4;
            }
            case KOTLIN_1_5: {
                return LanguageVersion.KOTLIN_1_5;
            }
            case KOTLIN_1_6: {
                return LanguageVersion.KOTLIN_1_6;
            }
            case KOTLIN_1_7: {
                return LanguageVersion.KOTLIN_1_7;
            }
            case KOTLIN_1_8: {
                return LanguageVersion.KOTLIN_1_8;
            }
            case KOTLIN_1_9: {
                return LanguageVersion.KOTLIN_1_9;
            }
        }
        throw new IllegalArgumentException("Unknown language level: " + (Object)((Object)languageLevel));
    }

    private ApiVersion getApiVersion(KotlinLanguageLevel languageLevel) {
        switch (languageLevel) {
            case KOTLIN_1_0: {
                return ApiVersion.KOTLIN_1_0;
            }
            case KOTLIN_1_1: {
                return ApiVersion.KOTLIN_1_1;
            }
            case KOTLIN_1_2: {
                return ApiVersion.KOTLIN_1_2;
            }
            case KOTLIN_1_3: {
                return ApiVersion.KOTLIN_1_3;
            }
            case KOTLIN_1_4: {
                return ApiVersion.KOTLIN_1_4;
            }
            case KOTLIN_1_5: {
                return ApiVersion.KOTLIN_1_5;
            }
            case KOTLIN_1_6: {
                return ApiVersion.KOTLIN_1_6;
            }
            case KOTLIN_1_7: {
                return ApiVersion.KOTLIN_1_7;
            }
            case KOTLIN_1_8: {
                return ApiVersion.KOTLIN_1_8;
            }
            case KOTLIN_1_9: {
                return ApiVersion.KOTLIN_1_9;
            }
        }
        throw new IllegalArgumentException("Unknown language level: " + (Object)((Object)languageLevel));
    }

    private KotlinParser(Collection<Path> classpath, List<NamedStyles> styles, boolean logCompilationWarningsAndErrors, JavaTypeCache typeCache, String moduleName, KotlinLanguageLevel languageLevel, boolean isKotlinScript) {
        this.classpath = classpath;
        this.styles = styles;
        this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
        this.typeCache = typeCache;
        this.moduleName = moduleName;
        this.languageLevel = languageLevel;
        this.isKotlinScript = isKotlinScript;
    }

    public static enum KotlinLanguageLevel {
        KOTLIN_1_0,
        KOTLIN_1_1,
        KOTLIN_1_2,
        KOTLIN_1_3,
        KOTLIN_1_4,
        KOTLIN_1_5,
        KOTLIN_1_6,
        KOTLIN_1_7,
        KOTLIN_1_8,
        KOTLIN_1_9;

    }

    public static class Builder
    extends Parser.Builder {
        @Nullable
        private Collection<String> artifactNames = Collections.emptyList();
        @Nullable
        private Collection<Path> classpath = Collections.emptyList();
        private JavaTypeCache typeCache = new JavaTypeCache();
        private boolean logCompilationWarningsAndErrors;
        private final List<NamedStyles> styles = new ArrayList<NamedStyles>();
        private String moduleName = "main";
        private KotlinLanguageLevel languageLevel = KotlinLanguageLevel.KOTLIN_1_9;
        private boolean isKotlinScript = false;

        public Builder() {
            super(K.CompilationUnit.class);
        }

        public Builder logCompilationWarningsAndErrors(boolean logCompilationWarningsAndErrors) {
            this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
            return this;
        }

        public Builder isKotlinScript(boolean isKotlinScript) {
            this.isKotlinScript = isKotlinScript;
            return this;
        }

        public Builder classpath(Collection<Path> classpath) {
            this.artifactNames = null;
            this.classpath = classpath;
            return this;
        }

        public Builder classpath(String ... artifactNames) {
            this.artifactNames = Arrays.asList(artifactNames);
            this.classpath = null;
            return this;
        }

        public Builder classpathFromResources(ExecutionContext ctx, String ... classpath) {
            this.artifactNames = null;
            this.classpath = JavaParser.dependenciesFromResources((ExecutionContext)ctx, (String[])classpath);
            return this;
        }

        public Builder typeCache(JavaTypeCache typeCache) {
            this.typeCache = typeCache;
            return this;
        }

        public Builder styles(Iterable<? extends NamedStyles> styles) {
            for (NamedStyles namedStyles : styles) {
                this.styles.add(namedStyles);
            }
            return this;
        }

        public Builder moduleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public Builder languageLevel(KotlinLanguageLevel languageLevel) {
            this.languageLevel = languageLevel;
            return this;
        }

        @Nullable
        private Collection<Path> resolvedClasspath() {
            if (this.artifactNames != null && !this.artifactNames.isEmpty()) {
                this.classpath = JavaParser.dependenciesFromClasspath((String[])this.artifactNames.toArray(new String[0]));
                this.artifactNames = null;
            }
            return this.classpath;
        }

        public KotlinParser build() {
            return new KotlinParser(this.resolvedClasspath(), this.styles, this.logCompilationWarningsAndErrors, this.typeCache, this.moduleName, this.languageLevel, this.isKotlinScript);
        }

        public String getDslName() {
            return "kotlin";
        }

        public Builder clone() {
            Builder clone = (Builder)super.clone();
            clone.typeCache = this.typeCache.clone();
            return clone;
        }
    }
}

