/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.format;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.style.ImportLayoutStyle;
import org.openrewrite.kotlin.style.IntelliJ;
import org.openrewrite.kotlin.tree.K;

public class ImportReorderingVisitor<P>
extends KotlinIsoVisitor<P> {
    @Override
    public K.CompilationUnit visitCompilationUnit(K.CompilationUnit cu, P p) {
        ImportLayoutStyle layoutStyle;
        List<JRightPadded<J.Import>> ordered;
        List<JRightPadded<J.Import>> importList = cu.getPadding().getImports();
        if (this.referentialIdentical(importList, ordered = (layoutStyle = Optional.ofNullable((ImportLayoutStyle)cu.getStyle(ImportLayoutStyle.class)).orElse(IntelliJ.importLayout())).orderImports(importList, new HashSet<JavaType.FullyQualified>()))) {
            return cu;
        }
        return cu.getPadding().withImports((List)ordered);
    }

    private <T> boolean referentialIdentical(List<T> l1, List<T> l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (l1.get(i) == l2.get(i)) continue;
            return false;
        }
        return true;
    }
}

