/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.json.tree.Comment;
import org.openrewrite.json.tree.Json;
import org.openrewrite.marker.Markers;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public class Space {
    public static final Space EMPTY = new Space("", Collections.emptyList());
    public static final Space SINGLE_SPACE = new Space(" ", Collections.emptyList());
    private final List<Comment> comments;
    private final @Nullable String whitespace;
    private static final Map<String, Space> flyweights = Collections.synchronizedMap(new WeakHashMap());
    private static final String[] spaces = new String[]{"\u00b7\u2081", "\u00b7\u2082", "\u00b7\u2083", "\u00b7\u2084", "\u00b7\u2085", "\u00b7\u2086", "\u00b7\u2087", "\u00b7\u2088", "\u00b7\u2089", "\u00b7\u208a"};
    private static final String[] tabs = new String[]{"-\u2081", "-\u2082", "-\u2083", "-\u2084", "-\u2085", "-\u2086", "-\u2087", "-\u2088", "-\u2089", "-\u208a"};

    private Space(@Nullable String whitespace, List<Comment> comments) {
        this.comments = comments;
        this.whitespace = whitespace == null || whitespace.isEmpty() ? null : whitespace;
    }

    @JsonCreator
    public static Space build(@Nullable String whitespace, List<Comment> comments) {
        if (comments.isEmpty()) {
            if (whitespace == null || whitespace.isEmpty()) {
                return EMPTY;
            }
            if (whitespace.length() <= 100) {
                return flyweights.computeIfAbsent(whitespace, k -> new Space(new String(whitespace), comments));
            }
        }
        return new Space(whitespace, comments);
    }

    public String getIndent() {
        if (!this.comments.isEmpty()) {
            return Space.getWhitespaceIndent(this.comments.get(this.comments.size() - 1).getSuffix());
        }
        return Space.getWhitespaceIndent(this.whitespace);
    }

    public String getLastWhitespace() {
        if (!this.comments.isEmpty()) {
            return this.comments.get(this.comments.size() - 1).getSuffix();
        }
        return this.whitespace == null ? "" : this.whitespace;
    }

    public String getWhitespaceIndent() {
        return Space.getWhitespaceIndent(this.whitespace);
    }

    private static String getWhitespaceIndent(@Nullable String whitespace) {
        if (whitespace == null) {
            return "";
        }
        int lastNewline = whitespace.lastIndexOf(10);
        if (lastNewline >= 0) {
            return whitespace.substring(lastNewline + 1);
        }
        if (lastNewline == whitespace.length() - 1) {
            return "";
        }
        return whitespace;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public String getWhitespace() {
        return this.whitespace == null ? "" : this.whitespace;
    }

    public boolean hasComment(String comment) {
        for (Comment c : this.comments) {
            if (!c.getText().equals(comment)) continue;
            return true;
        }
        return false;
    }

    public Space withComments(List<Comment> comments) {
        if (comments == this.comments) {
            return this;
        }
        if (comments.isEmpty() && (this.whitespace == null || this.whitespace.isEmpty())) {
            return EMPTY;
        }
        return Space.build(this.whitespace, comments);
    }

    public Space withWhitespace(String whitespace) {
        if (this.comments.isEmpty() && whitespace.isEmpty()) {
            return EMPTY;
        }
        if (whitespace.isEmpty() && this.whitespace == null || whitespace.equals(this.whitespace)) {
            return this;
        }
        return Space.build(whitespace, this.comments);
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public static Space firstPrefix(@Nullable List<? extends Json> trees) {
        return trees == null || trees.isEmpty() ? EMPTY : trees.iterator().next().getPrefix();
    }

    public static Space format(String formatting) {
        return Space.format(formatting, 0, formatting.length());
    }

    public static Space format(String formatting, int beginIndex, int toIndex) {
        if (beginIndex == toIndex) {
            return EMPTY;
        }
        if (toIndex == beginIndex + 1 && ' ' == formatting.charAt(beginIndex)) {
            return SINGLE_SPACE;
        }
        Space.rangeCheck(formatting.length(), beginIndex, toIndex);
        StringBuilder prefix = new StringBuilder();
        StringBuilder comment = new StringBuilder();
        ArrayList<Comment> comments = new ArrayList<Comment>(1);
        boolean inSingleLineComment = false;
        boolean inMultiLineComment = false;
        int last = 0;
        block5: for (int i = beginIndex; i < toIndex; ++i) {
            char c = formatting.charAt(i);
            switch (c) {
                case '/': {
                    if (inSingleLineComment) {
                        comment.append(c);
                        break;
                    }
                    if (last == 47 && !inMultiLineComment) {
                        inSingleLineComment = true;
                        comment.setLength(0);
                        prefix.setLength(prefix.length() - 1);
                        break;
                    }
                    if (last == 42 && inMultiLineComment && comment.length() > 0) {
                        inMultiLineComment = false;
                        comment.setLength(comment.length() - 1);
                        comments.add(new Comment(true, comment.toString(), prefix.substring(0, prefix.length() - 1), Markers.EMPTY));
                        prefix.setLength(0);
                        comment.setLength(0);
                        continue block5;
                    }
                    if (inMultiLineComment) {
                        comment.append(c);
                        break;
                    }
                    prefix.append(c);
                    break;
                }
                case '\n': 
                case '\r': {
                    if (inSingleLineComment) {
                        inSingleLineComment = false;
                        comments.add(new Comment(false, comment.toString(), prefix.toString(), Markers.EMPTY));
                        prefix.setLength(0);
                        comment.setLength(0);
                        prefix.append(c);
                        break;
                    }
                    if (!inMultiLineComment) {
                        prefix.append(c);
                        break;
                    }
                    comment.append(c);
                    break;
                }
                case '*': {
                    if (inSingleLineComment) {
                        comment.append(c);
                        break;
                    }
                    if (last == 47 && !inMultiLineComment) {
                        inMultiLineComment = true;
                        comment.setLength(0);
                        break;
                    }
                    comment.append(c);
                    break;
                }
                default: {
                    if (inSingleLineComment || inMultiLineComment) {
                        comment.append(c);
                        break;
                    }
                    prefix.append(c);
                }
            }
            last = c;
        }
        if (comment.length() > 0 || inSingleLineComment) {
            comments.add(new Comment(false, comment.toString(), prefix.toString(), Markers.EMPTY));
            prefix.setLength(0);
        }
        String whitespace = prefix.toString();
        if (!comments.isEmpty()) {
            for (int i = comments.size() - 1; i >= 0; --i) {
                Comment c = (Comment)comments.get(i);
                String next = c.getSuffix();
                comments.set(i, c.withSuffix(whitespace));
                whitespace = next;
            }
        }
        return Space.build(whitespace, comments);
    }

    static void rangeCheck(int arrayLength, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new StringIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLength) {
            throw new StringIndexOutOfBoundsException(toIndex);
        }
    }

    public static <H extends Json> List<H> formatFirstPrefix(List<H> trees, Space prefix) {
        if (!trees.isEmpty() && !((Json)trees.get(0)).getPrefix().equals(prefix)) {
            ArrayList<H> formattedTrees = new ArrayList<H>(trees);
            formattedTrees.set(0, ((Json)formattedTrees.get(0)).withPrefix(prefix));
            return formattedTrees;
        }
        return trees;
    }

    public String toString() {
        StringBuilder printedWs = new StringBuilder();
        int lastNewline = 0;
        if (this.whitespace != null) {
            char[] charArray = this.whitespace.toCharArray();
            for (int i = 0; i < charArray.length; ++i) {
                char c = charArray[i];
                if (c == '\n') {
                    printedWs.append("\\n");
                    lastNewline = i + 1;
                    continue;
                }
                if (c == '\r') {
                    printedWs.append("\\r");
                    lastNewline = i + 1;
                    continue;
                }
                if (c == ' ') {
                    printedWs.append(spaces[(i - lastNewline) % 10]);
                    continue;
                }
                if (c != '\t') continue;
                printedWs.append(tabs[(i - lastNewline) % 10]);
            }
        }
        return "Space(comments=<" + (this.comments.size() == 1 ? "1 comment" : this.comments.size() + " comments") + ">, whitespace='" + printedWs + "')";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Space)) {
            return false;
        }
        Space other = (Space)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Comment> this$comments = this.getComments();
        List<Comment> other$comments = other.getComments();
        if (this$comments == null ? other$comments != null : !((Object)this$comments).equals(other$comments)) {
            return false;
        }
        String this$whitespace = this.getWhitespace();
        String other$whitespace = other.getWhitespace();
        return !(this$whitespace == null ? other$whitespace != null : !this$whitespace.equals(other$whitespace));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof Space;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Comment> $comments = this.getComments();
        result = result * 59 + ($comments == null ? 43 : ((Object)$comments).hashCode());
        String $whitespace = this.getWhitespace();
        result = result * 59 + ($whitespace == null ? 43 : $whitespace.hashCode());
        return result;
    }
}

