/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplateSemanticallyEqual;
import org.openrewrite.java.ParenthesizeVisitor;
import org.openrewrite.java.internal.template.JavaTemplateJavaExtension;
import org.openrewrite.java.internal.template.JavaTemplateParser;
import org.openrewrite.java.internal.template.Substitutions;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.template.SourceTemplate;

public class JavaTemplate
implements SourceTemplate<J, JavaCoordinates> {
    private static @Nullable Path TEMPLATE_CLASSPATH_DIR;
    private final String code;
    private final Set<String> genericTypes;
    private final Consumer<String> onAfterVariableSubstitution;
    private final JavaTemplateParser templateParser;

    protected static Path getTemplateClasspathDir() {
        if (TEMPLATE_CLASSPATH_DIR == null) {
            try {
                TEMPLATE_CLASSPATH_DIR = Files.createTempDirectory("java-template", new FileAttribute[0]);
                Path templateDir = Files.createDirectories(TEMPLATE_CLASSPATH_DIR.resolve("org/openrewrite/java/internal/template"), new FileAttribute[0]);
                Path mClass = templateDir.resolve("__M__.class");
                Path pClass = templateDir.resolve("__P__.class");
                for (Path path : new Path[]{TEMPLATE_CLASSPATH_DIR, TEMPLATE_CLASSPATH_DIR.resolve("org"), TEMPLATE_CLASSPATH_DIR.resolve("org/openrewrite"), TEMPLATE_CLASSPATH_DIR.resolve("org/openrewrite/java"), TEMPLATE_CLASSPATH_DIR.resolve("org/openrewrite/java/internal"), templateDir, mClass, pClass}) {
                    path.toFile().deleteOnExit();
                }
                try (InputStream in = JavaTemplateParser.class.getClassLoader().getResourceAsStream("org/openrewrite/java/internal/template/__M__.class");){
                    assert (in != null);
                    Files.copy(in, mClass, new CopyOption[0]);
                }
                in = JavaTemplateParser.class.getClassLoader().getResourceAsStream("org/openrewrite/java/internal/template/__P__.class");
                try {
                    assert (in != null);
                    Files.copy(in, pClass, new CopyOption[0]);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return TEMPLATE_CLASSPATH_DIR;
    }

    private JavaTemplate(boolean contextSensitive, JavaParser.Builder<?, ?> parser, String code, String bindType, Set<String> imports, Set<String> genericTypes, Consumer<String> onAfterVariableSubstitution, Consumer<String> onBeforeParseTemplate) {
        this(code, genericTypes, onAfterVariableSubstitution, new JavaTemplateParser(contextSensitive, JavaTemplate.augmentClasspath(parser), onAfterVariableSubstitution, onBeforeParseTemplate, imports, bindType));
    }

    private static JavaParser.Builder<?, ?> augmentClasspath(JavaParser.Builder<?, ?> parserBuilder) {
        return parserBuilder.addClasspathEntry(JavaTemplate.getTemplateClasspathDir());
    }

    protected JavaTemplate(String code, Set<String> genericTypes, Consumer<String> onAfterVariableSubstitution, JavaTemplateParser templateParser) {
        this.code = code;
        this.genericTypes = genericTypes;
        this.onAfterVariableSubstitution = onAfterVariableSubstitution;
        this.templateParser = templateParser;
    }

    public <J2 extends J> J2 apply(Cursor scope, JavaCoordinates coordinates, Object ... parameters) {
        if (!(scope.getValue() instanceof J)) {
            throw new IllegalArgumentException("`scope` must point to a J instance.");
        }
        Substitutions substitutions = this.substitutions(parameters);
        String substitutedTemplate = substitutions.substitute();
        this.onAfterVariableSubstitution.accept(substitutedTemplate);
        J result = (J)new JavaTemplateJavaExtension(this.templateParser, substitutions, substitutedTemplate, coordinates).getMixin().visit((Tree)scope.getValue(), (Object)0, scope.getParentOrThrow());
        return (J2)(result != scope.getValue() && result instanceof Expression ? ParenthesizeVisitor.maybeParenthesize((Expression)result, scope) : result);
    }

    protected Substitutions substitutions(Object[] parameters) {
        return new Substitutions(this.code, this.genericTypes, parameters);
    }

    @Incubating(since="8.0.0")
    public static boolean matches(String template, Cursor cursor) {
        return JavaTemplate.builder(template).build().matches(cursor);
    }

    @Incubating(since="7.38.0")
    public boolean matches(Cursor cursor) {
        return this.matcher(cursor).find();
    }

    @Incubating(since="7.38.0")
    public Matcher matcher(Cursor cursor) {
        return new Matcher(cursor);
    }

    public static <J2 extends J> J2 apply(String template, Cursor scope, JavaCoordinates coordinates, Object ... parameters) {
        return JavaTemplate.builder(template).build().apply(scope, coordinates, parameters);
    }

    public static Builder builder(String code) {
        return new Builder(code);
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public Set<String> getGenericTypes() {
        return this.genericTypes;
    }

    public static class Builder {
        protected final String code;
        protected final Set<String> imports = new HashSet<String>();
        private final Set<String> genericTypes = new HashSet<String>();
        private boolean contextSensitive;
        private String bindType = "Object";
        private JavaParser.Builder<?, ?> parser = JavaParser.fromJavaVersion();
        protected Consumer<String> onAfterVariableSubstitution = s -> {};
        protected Consumer<String> onBeforeParseTemplate = s -> {};

        protected Builder(String code) {
            this.code = code.trim();
        }

        public Builder contextSensitive() {
            this.contextSensitive = true;
            return this;
        }

        public Builder bindType(String bindType) {
            if (StringUtils.isBlank((String)bindType)) {
                throw new IllegalArgumentException("Type must not be blank");
            }
            this.bindType = bindType;
            return this;
        }

        public Builder imports(String ... fullyQualifiedTypeNames) {
            for (String typeName : fullyQualifiedTypeNames) {
                this.validateImport(typeName);
                this.imports.add("import " + typeName + ";\n");
            }
            return this;
        }

        public Builder staticImports(String ... fullyQualifiedMemberTypeNames) {
            for (String typeName : fullyQualifiedMemberTypeNames) {
                this.validateImport(typeName);
                this.imports.add("import static " + typeName + ";\n");
            }
            return this;
        }

        public Builder genericTypes(String ... genericTypes) {
            Collections.addAll(this.genericTypes, genericTypes);
            return this;
        }

        protected void validateImport(String typeName) {
            if (StringUtils.isBlank((String)typeName)) {
                throw new IllegalArgumentException("Imports must not be blank");
            }
            if (typeName.startsWith("import ") || typeName.startsWith("static ")) {
                throw new IllegalArgumentException("Imports are expressed as fully-qualified names and should not include an \"import \" or \"static \" prefix");
            }
            if (typeName.endsWith(";") || typeName.endsWith("\n")) {
                throw new IllegalArgumentException("Imports are expressed as fully-qualified names and should not include a suffixed terminator");
            }
        }

        public Builder javaParser(JavaParser.Builder<?, ?> parser) {
            this.parser = parser;
            return this;
        }

        public Builder doAfterVariableSubstitution(Consumer<String> afterVariableSubstitution) {
            this.onAfterVariableSubstitution = afterVariableSubstitution;
            return this;
        }

        public Builder doBeforeParseTemplate(Consumer<String> beforeParseTemplate) {
            this.onBeforeParseTemplate = beforeParseTemplate;
            return this;
        }

        public JavaTemplate build() {
            return new JavaTemplate(this.contextSensitive, (JavaParser.Builder)this.parser.clone(), this.code, this.bindType, this.imports, this.genericTypes, this.onAfterVariableSubstitution, this.onBeforeParseTemplate);
        }
    }

    @Incubating(since="7.38.0")
    public final class Matcher {
        private final Cursor cursor;
        private JavaTemplateSemanticallyEqual.TemplateMatchResult matchResult;

        Matcher(Cursor cursor) {
            this.cursor = cursor;
        }

        public boolean find() {
            this.matchResult = JavaTemplateSemanticallyEqual.matchesTemplate(JavaTemplate.this, this.cursor);
            return this.matchResult.isMatch();
        }

        public J parameter(int i) {
            return this.matchResult.getMatchedParameters().get(i);
        }

        @Generated
        public Cursor getCursor() {
            return this.cursor;
        }

        @Generated
        public JavaTemplateSemanticallyEqual.TemplateMatchResult getMatchResult() {
            return this.matchResult;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Matcher)) {
                return false;
            }
            Matcher other = (Matcher)o;
            Cursor this$cursor = this.getCursor();
            Cursor other$cursor = other.getCursor();
            if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
                return false;
            }
            JavaTemplateSemanticallyEqual.TemplateMatchResult this$matchResult = this.getMatchResult();
            JavaTemplateSemanticallyEqual.TemplateMatchResult other$matchResult = other.getMatchResult();
            return !(this$matchResult == null ? other$matchResult != null : !((Object)this$matchResult).equals(other$matchResult));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Cursor $cursor = this.getCursor();
            result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
            JavaTemplateSemanticallyEqual.TemplateMatchResult $matchResult = this.getMatchResult();
            result = result * 59 + ($matchResult == null ? 43 : ((Object)$matchResult).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "JavaTemplate.Matcher(cursor=" + this.getCursor() + ", matchResult=" + this.getMatchResult() + ")";
        }
    }
}

