/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.TypeVisitor;
import org.openrewrite.java.internal.grammar.MethodSignatureParser;
import org.openrewrite.java.internal.grammar.MethodSignatureParserBaseVisitor;

class FormalParameterVisitor
extends MethodSignatureParserBaseVisitor<String> {
    private final List<Argument> arguments = new ArrayList<Argument>();

    FormalParameterVisitor() {
    }

    public String visitTerminal(TerminalNode node) {
        if ("...".equals(node.getText())) {
            ((Argument.FormalType)this.arguments.get(this.arguments.size() - 1)).setVariableArgs(true);
        }
        return (String)super.visitTerminal(node);
    }

    @Override
    public String visitDotDot(MethodSignatureParser.DotDotContext ctx) {
        this.arguments.add(Argument.DOT_DOT);
        return (String)super.visitDotDot(ctx);
    }

    @Override
    public String visitWildcard(MethodSignatureParser.WildcardContext ctx) {
        this.arguments.add(Argument.WILDCARD);
        return (String)super.visitWildcard(ctx);
    }

    @Override
    public String visitFormalTypePattern(MethodSignatureParser.FormalTypePatternContext ctx) {
        this.arguments.add(new Argument.FormalType(ctx));
        return (String)super.visitFormalTypePattern(ctx);
    }

    @Override
    public String visitFormalParametersPattern(MethodSignatureParser.FormalParametersPatternContext ctx) {
        super.visitFormalParametersPattern(ctx);
        ArrayList<String> argumentPatterns = new ArrayList<String>();
        for (int i = 0; i < this.arguments.size(); ++i) {
            Argument argument = this.arguments.get(i);
            if (argument == Argument.DOT_DOT) {
                if (this.arguments.size() == 1) {
                    argumentPatterns.add("(" + argument.getRegex() + ")?");
                    continue;
                }
                if (i > 0) {
                    argumentPatterns.add("(," + argument.getRegex() + ")?");
                    continue;
                }
                argumentPatterns.add("(" + argument.getRegex() + ",)?");
                continue;
            }
            if (i == 1 && this.arguments.get(0) == Argument.DOT_DOT) {
                argumentPatterns.add(argument.getRegex());
                continue;
            }
            if (i > 0) {
                argumentPatterns.add("," + argument.getRegex());
                continue;
            }
            argumentPatterns.add(argument.getRegex());
        }
        return String.join((CharSequence)"", argumentPatterns).replace("...", "\\[\\]");
    }

    private static abstract class Argument {
        private static final Argument DOT_DOT = new Argument(){

            @Override
            String getRegex() {
                return "([^,]+,)*([^,]+)";
            }
        };
        private static final Argument WILDCARD = new Argument(){

            @Override
            String getRegex() {
                return "([^,]+)";
            }
        };

        private Argument() {
        }

        abstract String getRegex();

        private static class FormalType
        extends Argument {
            private final MethodSignatureParser.FormalTypePatternContext ctx;
            private boolean variableArgs = false;

            public FormalType(MethodSignatureParser.FormalTypePatternContext ctx) {
                this.ctx = ctx;
            }

            @Override
            String getRegex() {
                String baseType = (String)new TypeVisitor().visitFormalTypePattern(this.ctx);
                return StringUtils.aspectjNameToPattern((String)baseType) + (this.variableArgs ? "\\[\\]" : "");
            }

            @Generated
            public void setVariableArgs(boolean variableArgs) {
                this.variableArgs = variableArgs;
            }
        }
    }
}

