/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.coding;

import org.openrewrite.tools.checkstyle.StatelessCheck;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.utils.CommonUtil;
import org.openrewrite.tools.checkstyle.utils.JavadocUtil;
import org.openrewrite.tools.checkstyle.utils.TokenUtil;

@StatelessCheck
public class IllegalTokenCheck
extends AbstractCheck {
    public static final String MSG_KEY = "illegal.token";

    @Override
    public int[] getDefaultTokens() {
        return new int[]{22};
    }

    @Override
    public int[] getAcceptableTokens() {
        return TokenUtil.getAllTokenIds();
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public void visitToken(DetailAST ast) {
        this.log(ast, MSG_KEY, IllegalTokenCheck.convertToString(ast));
    }

    private static String convertToString(DetailAST ast) {
        String tokenText;
        switch (ast.getType()) {
            case 22: {
                tokenText = ast.getFirstChild().getText() + ast.getText();
                break;
            }
            case 183: {
                tokenText = JavadocUtil.escapeAllControlChars(ast.getText());
                break;
            }
            default: {
                tokenText = ast.getText();
            }
        }
        return tokenText;
    }
}

