/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.lang.reflect.Field;
import java.util.Objects;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypeUtils;

public final class ReplaceStringLiteralWithConstant
extends Recipe {
    private static final String CONSTANT_FQN_PARAM = "fullyQualifiedConstantName";
    @Option(displayName="String literal value to replace", description="The literal that is to be replaced. If not configured, the value of the specified constant will be used by default.", example="application/json", required=false)
    private @Nullable String literalValue;
    @Option(displayName="Fully qualified name of the constant to use in place of String literal", example="org.springframework.http.MediaType.APPLICATION_JSON_VALUE")
    private final String fullyQualifiedConstantName;

    public ReplaceStringLiteralWithConstant(String fullyQualifiedConstantName) {
        this.literalValue = null;
        this.fullyQualifiedConstantName = fullyQualifiedConstantName;
    }

    @JsonCreator
    public ReplaceStringLiteralWithConstant(String literalValue, String fullyQualifiedConstantName) {
        this.literalValue = literalValue;
        this.fullyQualifiedConstantName = fullyQualifiedConstantName;
    }

    public String getDisplayName() {
        return "Replace String literal with constant";
    }

    public String getDescription() {
        return "Replace String literal with constant, adding import on class if needed.";
    }

    public @Nullable String getLiteralValue() {
        if (this.literalValue == null && this.fullyQualifiedConstantName != null) {
            try {
                this.literalValue = (String)ReplaceStringLiteralWithConstant.getConstantValueByFullyQualifiedName(this.fullyQualifiedConstantName);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                return null;
            }
        }
        return this.literalValue;
    }

    public Validated validate() {
        Validated result = super.validate();
        if (StringUtils.isBlank((String)this.fullyQualifiedConstantName)) {
            return result.and((Validated)Validated.invalid((String)CONSTANT_FQN_PARAM, (Object)this.fullyQualifiedConstantName, (String)"The constant's fully qualified name may not be empty or blank."));
        }
        try {
            Object constantValue = ReplaceStringLiteralWithConstant.getConstantValueByFullyQualifiedName(this.fullyQualifiedConstantName);
            if (constantValue == null) {
                return result.and((Validated)Validated.invalid((String)CONSTANT_FQN_PARAM, (Object)this.fullyQualifiedConstantName, (String)"Provided constant should not be null."));
            }
            if (!(constantValue instanceof String)) {
                return result.and((Validated)Validated.invalid((String)CONSTANT_FQN_PARAM, (Object)this.fullyQualifiedConstantName, (String)"Unsupported type of constant provided. Only literals can be replaced."));
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            return result.and((Validated)Validated.invalid((String)CONSTANT_FQN_PARAM, (Object)this.fullyQualifiedConstantName, (String)"No class for specified name was found."));
        }
        catch (NoSuchFieldException e) {
            return result.and((Validated)Validated.invalid((String)CONSTANT_FQN_PARAM, (Object)this.fullyQualifiedConstantName, (String)"No field with specified name was found."));
        }
        catch (IllegalAccessException e) {
            return result.and((Validated)Validated.invalid((String)CONSTANT_FQN_PARAM, (Object)this.fullyQualifiedConstantName, (String)"Unable to access specified field."));
        }
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        String value = this.getLiteralValue();
        return value == null ? TreeVisitor.noop() : new ReplaceStringLiteralVisitor(value, this.fullyQualifiedConstantName);
    }

    private static @Nullable Object getConstantValueByFullyQualifiedName(String fullyQualifiedConstantName) throws ClassNotFoundException, IllegalAccessException, NoSuchFieldException {
        String owningType = fullyQualifiedConstantName.substring(0, fullyQualifiedConstantName.lastIndexOf(46));
        String constantName = fullyQualifiedConstantName.substring(fullyQualifiedConstantName.lastIndexOf(46) + 1);
        Field constantField = Class.forName(owningType).getField(constantName);
        return constantField.get(null);
    }

    @Generated
    public String getFullyQualifiedConstantName() {
        return this.fullyQualifiedConstantName;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ReplaceStringLiteralWithConstant(literalValue=" + this.getLiteralValue() + ", fullyQualifiedConstantName=" + this.getFullyQualifiedConstantName() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceStringLiteralWithConstant)) {
            return false;
        }
        ReplaceStringLiteralWithConstant other = (ReplaceStringLiteralWithConstant)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$literalValue = this.getLiteralValue();
        String other$literalValue = other.getLiteralValue();
        if (this$literalValue == null ? other$literalValue != null : !this$literalValue.equals(other$literalValue)) {
            return false;
        }
        String this$fullyQualifiedConstantName = this.getFullyQualifiedConstantName();
        String other$fullyQualifiedConstantName = other.getFullyQualifiedConstantName();
        return !(this$fullyQualifiedConstantName == null ? other$fullyQualifiedConstantName != null : !this$fullyQualifiedConstantName.equals(other$fullyQualifiedConstantName));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ReplaceStringLiteralWithConstant;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $literalValue = this.getLiteralValue();
        result = result * 59 + ($literalValue == null ? 43 : $literalValue.hashCode());
        String $fullyQualifiedConstantName = this.getFullyQualifiedConstantName();
        result = result * 59 + ($fullyQualifiedConstantName == null ? 43 : $fullyQualifiedConstantName.hashCode());
        return result;
    }

    private static class ReplaceStringLiteralVisitor
    extends JavaVisitor<ExecutionContext> {
        private final String literalValue;
        private final String owningType;
        private final String template;

        public ReplaceStringLiteralVisitor(String literalValue, String fullyQualifiedConstantName) {
            this.literalValue = literalValue;
            this.owningType = fullyQualifiedConstantName.substring(0, fullyQualifiedConstantName.lastIndexOf(46));
            this.template = fullyQualifiedConstantName.substring(this.owningType.lastIndexOf(46) + 1);
        }

        @Override
        public J visitLiteral(J.Literal literal, ExecutionContext ctx) {
            if (!TypeUtils.isString(literal.getType()) || !Objects.equals(this.literalValue, literal.getValue())) {
                return super.visitLiteral(literal, ctx);
            }
            J.ClassDeclaration classDeclaration = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
            if (classDeclaration != null && classDeclaration.getType() != null && this.owningType.equals(classDeclaration.getType().getFullyQualifiedName())) {
                return super.visitLiteral(literal, ctx);
            }
            this.maybeAddImport(this.owningType, false);
            return JavaTemplate.builder(this.template).contextSensitive().imports(this.owningType).build().apply(this.getCursor(), literal.getCoordinates().replace(), new Object[0]).withPrefix(literal.getPrefix());
        }
    }
}

