/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.internal.grammar.AnnotationSignatureLexer;
import org.openrewrite.java.internal.grammar.AnnotationSignatureParser;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class AnnotationMatcher {
    private final AnnotationSignatureParser.AnnotationContext match;
    private final Pattern matcher;
    private final boolean matchMetaAnnotations;

    public AnnotationMatcher(String signature, @Nullable Boolean matchesMetaAnnotations) {
        this.match = new AnnotationSignatureParser((TokenStream)new CommonTokenStream((TokenSource)new AnnotationSignatureLexer((CharStream)CharStreams.fromString((String)signature)))).annotation();
        this.matcher = Pattern.compile(StringUtils.aspectjNameToPattern((String)this.match.annotationName().getText()));
        this.matchMetaAnnotations = Boolean.TRUE.equals(matchesMetaAnnotations);
    }

    public AnnotationMatcher(String signature) {
        this(signature, false);
    }

    public boolean matches(J.Annotation annotation) {
        return this.matchesAnnotationName(annotation) && this.matchesSingleParameter(annotation) && this.matchesNamedParameters(annotation);
    }

    private boolean matchesAnnotationName(J.Annotation annotation) {
        return this.matchesAnnotationOrMetaAnnotation(TypeUtils.asFullyQualified(annotation.getType()), null);
    }

    public boolean matchesAnnotationOrMetaAnnotation(@Nullable JavaType.FullyQualified fqn) {
        return this.matchesAnnotationOrMetaAnnotation(fqn, null);
    }

    private boolean matchesAnnotationOrMetaAnnotation(@Nullable JavaType.FullyQualified fqn, @Nullable Set<String> seenAnnotations) {
        if (fqn != null) {
            if (this.matcher.matcher(fqn.getFullyQualifiedName()).matches()) {
                return true;
            }
            if (this.matchMetaAnnotations) {
                for (JavaType.FullyQualified annotation : fqn.getAnnotations()) {
                    if (seenAnnotations == null) {
                        seenAnnotations = new HashSet<String>();
                    }
                    if (!seenAnnotations.add(annotation.getFullyQualifiedName()) || !this.matchesAnnotationOrMetaAnnotation(annotation, seenAnnotations)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean matchesNamedParameters(J.Annotation annotation) {
        AnnotationSignatureParser.ElementValuePairsContext pairs = this.match.elementValuePairs();
        if (pairs == null || pairs.elementValuePair() == null) {
            return true;
        }
        if (annotation.getArguments() == null) {
            return false;
        }
        for (AnnotationSignatureParser.ElementValuePairContext elementValuePair : pairs.elementValuePair()) {
            String argumentName = elementValuePair.Identifier().getText();
            String matchText = elementValuePair.elementValue().getText();
            if (!annotation.getArguments().stream().noneMatch(arg -> this.argumentValueMatches(argumentName, (Expression)arg, matchText))) continue;
            return false;
        }
        return true;
    }

    private boolean matchesSingleParameter(J.Annotation annotation) {
        if (this.match.elementValue() == null) {
            return true;
        }
        return annotation.getArguments() == null || annotation.getArguments().stream().findAny().map(arg -> this.argumentValueMatches("value", (Expression)arg, this.match.elementValue().getText())).orElse(true) != false;
    }

    private boolean argumentValueMatches(String matchOnArgumentName, Expression arg, String matchText) {
        if ("value".equals(matchOnArgumentName)) {
            if (arg instanceof J.Literal) {
                String valueSource = ((J.Literal)arg).getValueSource();
                return valueSource != null && valueSource.equals(matchText);
            }
            if (arg instanceof J.FieldAccess) {
                JavaType.FullyQualified owner;
                J.FieldAccess fa = (J.FieldAccess)arg;
                if ("class".equals(fa.getSimpleName()) && matchText.endsWith(".class")) {
                    JavaType argType = fa.getTarget().getType();
                    if (argType instanceof JavaType.FullyQualified) {
                        String queryTypeFqn = JavaType.ShallowClass.build(matchText.substring(0, matchText.length() - 6)).getFullyQualifiedName();
                        String targetTypeFqn = ((JavaType.FullyQualified)argType).getFullyQualifiedName();
                        return TypeUtils.fullyQualifiedNamesAreEqual(queryTypeFqn, targetTypeFqn);
                    }
                    return false;
                }
                JavaType.Variable varType = fa.getName().getFieldType();
                if (varType != null && (owner = TypeUtils.asFullyQualified(varType.getOwner())) != null && matchText.equals(owner.getFullyQualifiedName() + "." + varType.getName())) {
                    return true;
                }
            }
            if (arg instanceof J.NewArray) {
                J.NewArray na = (J.NewArray)arg;
                if (na.getInitializer() == null || na.getInitializer().size() != 1) {
                    return false;
                }
                return this.argumentValueMatches("value", na.getInitializer().get(0), matchText);
            }
        }
        if (!(arg instanceof J.Assignment)) {
            return false;
        }
        J.Assignment assignment = (J.Assignment)arg;
        if (!assignment.getVariable().printTrimmed(new JavaPrinter()).equals(matchOnArgumentName)) {
            return false;
        }
        return this.argumentValueMatches("value", assignment.getAssignment(), matchText);
    }
}

