/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.openrewrite.Incubating;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.internal.DefaultJavaTypeSignatureBuilder;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.TypeUtils;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@c")
@JsonIgnoreProperties(ignoreUnknown=true)
public interface JavaType {
    public static final FullyQualified[] EMPTY_FULLY_QUALIFIED_ARRAY = new FullyQualified[0];
    public static final Variable[] EMPTY_VARIABLE_ARRAY = new Variable[0];
    public static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final JavaType[] EMPTY_JAVA_TYPE_ARRAY = new JavaType[0];

    @JsonProperty(value="@c")
    default public String getJacksonPolymorphicTypeTag() {
        return this.getClass().getName();
    }

    @Nullable
    default public Integer getManagedReference() {
        return null;
    }

    default public JavaType withManagedReference(Integer id) {
        return this;
    }

    default public JavaType unsafeSetManagedReference(Integer id) {
        return this;
    }

    public static JavaType buildType(String typeName) {
        Primitive primitive = Primitive.fromKeyword(typeName);
        if (primitive != null) {
            return primitive;
        }
        return ShallowClass.build(typeName);
    }

    default public boolean isAssignableFrom(Pattern pattern) {
        if (this instanceof FullyQualified) {
            FullyQualified fq = (FullyQualified)this;
            if (pattern.matcher(fq.getFullyQualifiedName()).matches()) {
                return true;
            }
            if (fq.getSupertype() != null && fq.getSupertype().isAssignableFrom(pattern)) {
                return true;
            }
            for (FullyQualified anInterface : fq.getInterfaces()) {
                if (!anInterface.isAssignableFrom(pattern)) continue;
                return true;
            }
            return false;
        }
        if (this instanceof GenericTypeVariable) {
            GenericTypeVariable generic = (GenericTypeVariable)this;
            for (JavaType bound : generic.getBounds()) {
                if (!bound.isAssignableFrom(pattern)) continue;
                return true;
            }
        }
        return false;
    }

    public static enum Primitive implements JavaType
    {
        Boolean,
        Byte,
        Char,
        Double,
        Float,
        Int,
        Long,
        Short,
        Void,
        String,
        None,
        Null;


        @Nullable
        public static Primitive fromKeyword(String keyword) {
            switch (keyword) {
                case "boolean": {
                    return Boolean;
                }
                case "byte": {
                    return Byte;
                }
                case "char": {
                    return Char;
                }
                case "double": {
                    return Double;
                }
                case "float": {
                    return Float;
                }
                case "int": {
                    return Int;
                }
                case "long": {
                    return Long;
                }
                case "short": {
                    return Short;
                }
                case "void": {
                    return Void;
                }
                case "String": {
                    return String;
                }
                case "null": {
                    return Null;
                }
                case "": {
                    return None;
                }
            }
            return null;
        }

        public String getKeyword() {
            switch (this) {
                case Boolean: {
                    return "boolean";
                }
                case Byte: {
                    return "byte";
                }
                case Char: {
                    return "char";
                }
                case Double: {
                    return "double";
                }
                case Float: {
                    return "float";
                }
                case Int: {
                    return "int";
                }
                case Long: {
                    return "long";
                }
                case Short: {
                    return "short";
                }
                case Void: {
                    return "void";
                }
                case String: {
                    return "String";
                }
                case Null: {
                    return "null";
                }
            }
            return "";
        }

        public String getClassName() {
            switch (this) {
                case Boolean: {
                    return "java.lang.Boolean";
                }
                case Byte: {
                    return "java.lang.Byte";
                }
                case Char: {
                    return "java.lang.Character";
                }
                case Double: {
                    return "java.lang.Double";
                }
                case Float: {
                    return "java.lang.Float";
                }
                case Int: {
                    return "java.lang.Integer";
                }
                case Long: {
                    return "java.lang.Long";
                }
                case Short: {
                    return "java.lang.Short";
                }
                case Void: {
                    return "java.lang.Void";
                }
                case String: {
                    return "java.lang.String";
                }
                case Null: {
                    return "null";
                }
            }
            return "";
        }

        public String toString() {
            return this.getKeyword();
        }

        public boolean isNumeric() {
            return this == Double || this == Int || this == Float || this == Long || this == Short;
        }
    }

    public static class ShallowClass
    extends Class {
        public ShallowClass(@Nullable Integer managedReference, long flagsBitMap, String fullyQualifiedName, FullyQualified.Kind kind, @Nullable List<JavaType> typeParameters, @Nullable FullyQualified supertype, @Nullable FullyQualified owningClass, @Nullable List<FullyQualified> annotations, @Nullable List<FullyQualified> interfaces, @Nullable List<Variable> members, @Nullable List<Method> methods) {
            super(managedReference, flagsBitMap, fullyQualifiedName, kind, (List<JavaType>)null, null, owningClass, null, null, null, null);
        }

        public static ShallowClass build(String fullyQualifiedName) {
            ShallowClass owningClass = null;
            int firstClassNameIndex = 0;
            int lastDot = 0;
            char[] fullyQualifiedNameChars = fullyQualifiedName.replace('$', '.').toCharArray();
            int prev = 32;
            for (int i = 0; i < fullyQualifiedNameChars.length; ++i) {
                int c = fullyQualifiedNameChars[i];
                if (firstClassNameIndex == 0 && prev == 46 && Character.isUpperCase((char)c)) {
                    firstClassNameIndex = i;
                } else if (c == 46) {
                    lastDot = i;
                }
                prev = c;
            }
            if (lastDot > firstClassNameIndex) {
                owningClass = ShallowClass.build(fullyQualifiedName.substring(0, lastDot));
            }
            return new ShallowClass(null, 1L, fullyQualifiedName, FullyQualified.Kind.Class, Collections.emptyList(), null, (FullyQualified)owningClass, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
    }

    public static abstract class FullyQualified
    implements JavaType {
        public abstract String getFullyQualifiedName();

        public abstract FullyQualified withFullyQualifiedName(String var1);

        public abstract List<FullyQualified> getAnnotations();

        public abstract boolean hasFlags(Flag ... var1);

        public abstract Set<Flag> getFlags();

        public abstract List<FullyQualified> getInterfaces();

        public abstract Kind getKind();

        public abstract List<Variable> getMembers();

        public abstract List<Method> getMethods();

        public abstract List<JavaType> getTypeParameters();

        public Iterator<Method> getVisibleMethods() {
            return this.getVisibleMethods(this.getPackageName());
        }

        private Iterator<Method> getVisibleMethods(String packageName) {
            return new FullyQualifiedIterator<Method>(this, packageName, Method::getFlagsBitMap, FullyQualified::getMethods, fq -> fq.getVisibleMethods(packageName));
        }

        public Iterator<Variable> getVisibleMembers() {
            return this.getVisibleMembers(this.getPackageName());
        }

        private Iterator<Variable> getVisibleMembers(String packageName) {
            return new FullyQualifiedIterator<Variable>(this, packageName, Variable::getFlagsBitMap, FullyQualified::getMembers, fq -> fq.getVisibleMembers(packageName));
        }

        @Nullable
        public abstract FullyQualified getOwningClass();

        @Nullable
        public abstract FullyQualified getSupertype();

        public String getClassName() {
            String fqn = this.getFullyQualifiedName();
            String className = fqn.substring(fqn.lastIndexOf(46) + 1);
            return className.replace('$', '.');
        }

        public String getPackageName() {
            String fqn = this.getFullyQualifiedName();
            int endPackage = fqn.lastIndexOf(46);
            return endPackage < 0 ? "" : fqn.substring(0, endPackage);
        }

        public boolean isAssignableTo(String fullyQualifiedName) {
            return TypeUtils.fullyQualifiedNamesAreEqual(this.getFullyQualifiedName(), fullyQualifiedName) || this.getInterfaces().stream().anyMatch(anInterface -> anInterface.isAssignableTo(fullyQualifiedName)) || this.getSupertype() != null && this.getSupertype().isAssignableTo(fullyQualifiedName);
        }

        public boolean isAssignableFrom(@Nullable JavaType type) {
            if (type instanceof FullyQualified) {
                FullyQualified clazz = (FullyQualified)type;
                return TypeUtils.fullyQualifiedNamesAreEqual(this.getFullyQualifiedName(), clazz.getFullyQualifiedName()) || this.isAssignableFrom(clazz.getSupertype()) || clazz.getInterfaces().stream().anyMatch(this::isAssignableFrom);
            }
            if (type instanceof GenericTypeVariable) {
                GenericTypeVariable generic = (GenericTypeVariable)type;
                for (JavaType bound : generic.getBounds()) {
                    if (!this.isAssignableFrom(bound)) continue;
                    return true;
                }
            }
            return false;
        }

        private static class FullyQualifiedIterator<E>
        implements Iterator<E> {
            private final FullyQualified fq;
            private final String visibleFromPackage;
            private final Function<E, Long> flags;
            private final Function<FullyQualified, Iterator<E>> recursive;
            private FullyQualified rec;
            private E peek;
            private Iterator<E> current;
            @Nullable
            private Iterator<E> supertype;
            @Nullable
            private Iterator<FullyQualified> interfaces;
            @Nullable
            private Iterator<E> interfaceE;

            private FullyQualifiedIterator(FullyQualified fq, String visibleFromPackage, Function<E, Long> flags, Function<FullyQualified, List<E>> base, Function<FullyQualified, Iterator<E>> recursive) {
                this.fq = fq;
                this.rec = fq;
                this.visibleFromPackage = visibleFromPackage;
                this.flags = flags;
                this.recursive = recursive;
                this.current = base.apply(fq).iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.current.hasNext()) {
                    this.peek = this.current.next();
                    long peekFlags = this.flags.apply(this.peek);
                    if (((Flag.Public.getBitMask() | Flag.Protected.getBitMask()) & peekFlags) != 0L) {
                        return true;
                    }
                    if ((Flag.Private.getBitMask() & peekFlags) == 0L && this.rec.getPackageName().equals(this.visibleFromPackage)) {
                        return true;
                    }
                    return true;
                }
                if (this.supertype == null) {
                    this.supertype = this.fq.getSupertype() == null ? Collections.emptyIterator() : this.recursive.apply(this.fq.getSupertype());
                    this.current = this.supertype;
                    this.rec = this.fq.getSupertype();
                    return this.hasNext();
                }
                if (this.interfaces == null) {
                    this.interfaces = this.fq.getInterfaces().iterator();
                    return this.hasNext();
                }
                if (this.interfaces.hasNext()) {
                    this.rec = this.interfaces.next();
                    this.current = this.recursive.apply(this.rec);
                    return this.hasNext();
                }
                return false;
            }

            @Override
            public E next() {
                return this.peek;
            }
        }

        public static enum Kind {
            Class,
            Enum,
            Interface,
            Annotation,
            Record;

        }
    }

    public static class GenericTypeVariable
    implements JavaType {
        @Nullable
        private Integer managedReference;
        private String name;
        private Variance variance;
        @Nullable
        private JavaType[] bounds;

        public GenericTypeVariable(@Nullable Integer managedReference, String name, Variance variance, @Nullable List<JavaType> bounds) {
            this(managedReference, name, variance, (JavaType[])ListUtils.arrayOrNullIfEmpty(bounds, (Object[])EMPTY_JAVA_TYPE_ARRAY));
        }

        @JsonCreator
        GenericTypeVariable(@Nullable Integer managedReference, String name, Variance variance, @Nullable JavaType[] bounds) {
            this.managedReference = managedReference;
            this.name = name;
            this.variance = variance;
            this.bounds = (JavaType[])ListUtils.nullIfEmpty((Object[])bounds);
        }

        public List<JavaType> getBounds() {
            return this.bounds == null ? Collections.emptyList() : Arrays.asList(this.bounds);
        }

        public GenericTypeVariable withBounds(@Nullable List<JavaType> bounds) {
            Object[] boundsArray = (JavaType[])ListUtils.arrayOrNullIfEmpty(bounds, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            if (Arrays.equals(boundsArray, this.bounds)) {
                return this;
            }
            return new GenericTypeVariable(this.managedReference, this.name, this.variance, (JavaType[])boundsArray);
        }

        @Override
        public GenericTypeVariable unsafeSetManagedReference(@Nullable Integer id) {
            this.managedReference = id;
            return this;
        }

        public GenericTypeVariable unsafeSet(String name, Variance variance, @Nullable List<JavaType> bounds) {
            this.name = name;
            this.variance = variance;
            this.bounds = (JavaType[])ListUtils.arrayOrNullIfEmpty(bounds, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            return this;
        }

        public GenericTypeVariable unsafeSet(String name, Variance variance, @Nullable JavaType[] bounds) {
            this.name = name;
            this.variance = variance;
            this.bounds = (JavaType[])ListUtils.nullIfEmpty((Object[])bounds);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GenericTypeVariable that = (GenericTypeVariable)o;
            return this.name.equals(that.name) && this.variance == that.variance && (this.variance == Variance.INVARIANT && this.bounds == null && that.bounds == null || this.bounds != null && Arrays.equals(this.bounds, that.bounds));
        }

        public String toString() {
            return new DefaultJavaTypeSignatureBuilder().signature(this);
        }

        @Override
        @NonNull
        public GenericTypeVariable withManagedReference(@Nullable Integer managedReference) {
            return this.managedReference == managedReference ? this : new GenericTypeVariable(managedReference, this.name, this.variance, this.bounds);
        }

        @Override
        @Nullable
        public Integer getManagedReference() {
            return this.managedReference;
        }

        @NonNull
        public GenericTypeVariable withName(String name) {
            return this.name == name ? this : new GenericTypeVariable(this.managedReference, name, this.variance, this.bounds);
        }

        public String getName() {
            return this.name;
        }

        @NonNull
        public GenericTypeVariable withVariance(Variance variance) {
            return this.variance == variance ? this : new GenericTypeVariable(this.managedReference, this.name, variance, this.bounds);
        }

        public Variance getVariance() {
            return this.variance;
        }

        public static enum Variance {
            INVARIANT,
            COVARIANT,
            CONTRAVARIANT;

        }
    }

    public static class Variable
    implements JavaType {
        @Nullable
        private Integer managedReference;
        private final long flagsBitMap;
        private final String name;
        @Nullable
        private JavaType owner;
        private JavaType type;
        @Nullable
        private FullyQualified[] annotations;

        public Variable(@Nullable Integer managedReference, long flagsBitMap, String name, @Nullable JavaType owner, @Nullable JavaType type, @Nullable List<FullyQualified> annotations) {
            this(managedReference, flagsBitMap, name, owner, type, (FullyQualified[])ListUtils.arrayOrNullIfEmpty(annotations, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY));
        }

        @JsonCreator
        Variable(@Nullable Integer managedReference, long flagsBitMap, String name, @Nullable JavaType owner, @Nullable JavaType type, @Nullable FullyQualified[] annotations) {
            this.managedReference = managedReference;
            this.flagsBitMap = flagsBitMap & Flag.VALID_FLAGS;
            this.name = name;
            this.owner = owner;
            this.type = TypeUtils.unknownIfNull(type);
            this.annotations = (FullyQualified[])ListUtils.nullIfEmpty((Object[])annotations);
        }

        @Nullable
        public JavaType getOwner() {
            return this.owner;
        }

        public List<FullyQualified> getAnnotations() {
            return this.annotations == null ? Collections.emptyList() : Arrays.asList(this.annotations);
        }

        public Variable withAnnotations(@Nullable List<FullyQualified> annotations) {
            Object[] annotationsArray = (FullyQualified[])ListUtils.arrayOrNullIfEmpty(annotations, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY);
            if (Arrays.equals(annotationsArray, this.annotations)) {
                return this;
            }
            return new Variable(this.managedReference, this.flagsBitMap, this.name, this.owner, this.type, (FullyQualified[])annotationsArray);
        }

        public boolean hasFlags(Flag ... test) {
            return Flag.hasFlags(this.flagsBitMap, test);
        }

        public Set<Flag> getFlags() {
            return Flag.bitMapToFlags(this.flagsBitMap);
        }

        public Variable withFlags(Set<Flag> flags) {
            return this.withFlagsBitMap(Flag.flagsToBitMap(flags));
        }

        @Override
        public Variable unsafeSetManagedReference(Integer id) {
            this.managedReference = id;
            return this;
        }

        public Variable unsafeSet(JavaType owner, @Nullable JavaType type, @Nullable List<FullyQualified> annotations) {
            this.owner = owner;
            this.type = TypeUtils.unknownIfNull(type);
            this.annotations = (FullyQualified[])ListUtils.arrayOrNullIfEmpty(annotations, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY);
            return this;
        }

        public Variable unsafeSet(JavaType owner, @Nullable JavaType type, FullyQualified @Nullable [] annotations) {
            this.owner = owner;
            this.type = TypeUtils.unknownIfNull(type);
            this.annotations = (FullyQualified[])ListUtils.nullIfEmpty((Object[])annotations);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable variable = (Variable)o;
            return Objects.equals(this.name, variable.name) && Objects.equals(this.owner, variable.owner);
        }

        public String toString() {
            return new DefaultJavaTypeSignatureBuilder().variableSignature(this);
        }

        @Override
        @Nullable
        public Integer getManagedReference() {
            return this.managedReference;
        }

        public long getFlagsBitMap() {
            return this.flagsBitMap;
        }

        public String getName() {
            return this.name;
        }

        public JavaType getType() {
            return this.type;
        }

        @Override
        @NonNull
        public Variable withManagedReference(@Nullable Integer managedReference) {
            return this.managedReference == managedReference ? this : new Variable(managedReference, this.flagsBitMap, this.name, this.owner, this.type, this.annotations);
        }

        @NonNull
        private Variable withFlagsBitMap(long flagsBitMap) {
            return this.flagsBitMap == flagsBitMap ? this : new Variable(this.managedReference, flagsBitMap, this.name, this.owner, this.type, this.annotations);
        }

        @NonNull
        public Variable withName(String name) {
            return this.name == name ? this : new Variable(this.managedReference, this.flagsBitMap, name, this.owner, this.type, this.annotations);
        }

        @NonNull
        public Variable withOwner(@Nullable JavaType owner) {
            return this.owner == owner ? this : new Variable(this.managedReference, this.flagsBitMap, this.name, owner, this.type, this.annotations);
        }

        @NonNull
        public Variable withType(JavaType type) {
            return this.type == type ? this : new Variable(this.managedReference, this.flagsBitMap, this.name, this.owner, type, this.annotations);
        }
    }

    public static class Method
    implements JavaType {
        @Nullable
        private Integer managedReference;
        private final long flagsBitMap;
        private FullyQualified declaringType;
        private final String name;
        private JavaType returnType;
        @Nullable
        private final String[] parameterNames;
        @Nullable
        private JavaType[] parameterTypes;
        @Nullable
        private FullyQualified[] thrownExceptions;
        @Nullable
        private FullyQualified[] annotations;
        @Nullable
        @Incubating(since="7.34.0")
        private final List<String> defaultValue;

        public Method(@Nullable Integer managedReference, long flagsBitMap, @Nullable FullyQualified declaringType, String name, @Nullable JavaType returnType, @Nullable List<String> parameterNames, @Nullable List<JavaType> parameterTypes, @Nullable List<FullyQualified> thrownExceptions, @Nullable List<FullyQualified> annotations) {
            this(managedReference, flagsBitMap, declaringType, name, returnType, parameterNames, parameterTypes, thrownExceptions, annotations, null);
        }

        public Method(@Nullable Integer managedReference, long flagsBitMap, @Nullable FullyQualified declaringType, String name, @Nullable JavaType returnType, @Nullable List<String> parameterNames, @Nullable List<JavaType> parameterTypes, @Nullable List<FullyQualified> thrownExceptions, @Nullable List<FullyQualified> annotations, @Nullable List<String> defaultValue) {
            this(managedReference, flagsBitMap, declaringType, name, returnType, (String[])ListUtils.arrayOrNullIfEmpty(parameterNames, (Object[])EMPTY_STRING_ARRAY), (JavaType[])ListUtils.arrayOrNullIfEmpty(parameterTypes, (Object[])EMPTY_JAVA_TYPE_ARRAY), (FullyQualified[])ListUtils.arrayOrNullIfEmpty(thrownExceptions, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY), (FullyQualified[])ListUtils.arrayOrNullIfEmpty(annotations, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY), defaultValue);
        }

        @JsonCreator
        public Method(@Nullable Integer managedReference, long flagsBitMap, @Nullable FullyQualified declaringType, String name, @Nullable JavaType returnType, @Nullable String[] parameterNames, @Nullable JavaType[] parameterTypes, @Nullable FullyQualified[] thrownExceptions, @Nullable FullyQualified[] annotations, @Nullable List<String> defaultValue) {
            this.managedReference = managedReference;
            this.flagsBitMap = flagsBitMap & Flag.VALID_FLAGS;
            this.declaringType = TypeUtils.unknownIfNull(declaringType);
            this.name = name;
            this.returnType = TypeUtils.unknownIfNull(returnType);
            this.parameterNames = (String[])ListUtils.nullIfEmpty((Object[])parameterNames);
            this.parameterTypes = (JavaType[])ListUtils.nullIfEmpty((Object[])parameterTypes);
            this.thrownExceptions = (FullyQualified[])ListUtils.nullIfEmpty((Object[])thrownExceptions);
            this.annotations = (FullyQualified[])ListUtils.nullIfEmpty((Object[])annotations);
            this.defaultValue = ListUtils.nullIfEmpty(defaultValue);
        }

        @Override
        public Method unsafeSetManagedReference(Integer id) {
            this.managedReference = id;
            return this;
        }

        public Method unsafeSet(@Nullable FullyQualified declaringType, @Nullable JavaType returnType, @Nullable List<JavaType> parameterTypes, @Nullable List<FullyQualified> thrownExceptions, @Nullable List<FullyQualified> annotations) {
            this.declaringType = TypeUtils.unknownIfNull(declaringType);
            this.returnType = TypeUtils.unknownIfNull(returnType);
            this.parameterTypes = (JavaType[])ListUtils.arrayOrNullIfEmpty(parameterTypes, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            this.thrownExceptions = (FullyQualified[])ListUtils.arrayOrNullIfEmpty(thrownExceptions, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY);
            this.annotations = (FullyQualified[])ListUtils.arrayOrNullIfEmpty(annotations, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY);
            return this;
        }

        public Method unsafeSet(@Nullable FullyQualified declaringType, @Nullable JavaType returnType, @Nullable JavaType[] parameterTypes, @Nullable FullyQualified[] thrownExceptions, @Nullable FullyQualified[] annotations) {
            this.declaringType = TypeUtils.unknownIfNull(declaringType);
            this.returnType = TypeUtils.unknownIfNull(returnType);
            this.parameterTypes = (JavaType[])ListUtils.nullIfEmpty((Object[])parameterTypes);
            this.thrownExceptions = (FullyQualified[])ListUtils.nullIfEmpty((Object[])thrownExceptions);
            this.annotations = (FullyQualified[])ListUtils.nullIfEmpty((Object[])annotations);
            return this;
        }

        public boolean isConstructor() {
            return "<constructor>".equals(this.name);
        }

        public FullyQualified getDeclaringType() {
            return this.declaringType;
        }

        public boolean isOverride() {
            if (this.declaringType instanceof Unknown) {
                return false;
            }
            Stack<FullyQualified> interfaces = new Stack<FullyQualified>();
            interfaces.addAll(this.declaringType.getInterfaces());
            while (!interfaces.isEmpty()) {
                FullyQualified declaring = (FullyQualified)interfaces.pop();
                interfaces.addAll(declaring.getInterfaces());
                block1: for (Method method : declaring.getMethods()) {
                    if (!method.getName().equals(this.name)) continue;
                    List<JavaType> params = method.getParameterTypes();
                    if (this.getParameterTypes().size() != method.getParameterTypes().size()) continue;
                    for (int i = 0; i < params.size(); ++i) {
                        if (!TypeUtils.isOfType(this.getParameterTypes().get(i), params.get(i))) continue block1;
                    }
                    return true;
                }
            }
            return false;
        }

        public boolean isInheritedFrom(String fullyQualifiedTypeName) {
            if (this.declaringType instanceof Unknown) {
                return false;
            }
            Stack<FullyQualified> interfaces = new Stack<FullyQualified>();
            interfaces.addAll(this.declaringType.getInterfaces());
            while (!interfaces.isEmpty()) {
                FullyQualified declaring = (FullyQualified)interfaces.pop();
                interfaces.addAll(declaring.getInterfaces());
                if (declaring.getFullyQualifiedName().equals(fullyQualifiedTypeName)) continue;
                block1: for (Method method : declaring.getMethods()) {
                    if (!method.getName().equals(this.name)) continue;
                    List<JavaType> params = method.getParameterTypes();
                    if (this.getParameterTypes().size() != method.getParameterTypes().size()) continue;
                    for (int i = 0; i < params.size(); ++i) {
                        if (!TypeUtils.isOfType(this.getParameterTypes().get(i), params.get(i))) continue block1;
                    }
                    return true;
                }
            }
            return false;
        }

        public List<String> getParameterNames() {
            return this.parameterNames == null ? Collections.emptyList() : Arrays.asList(this.parameterNames);
        }

        public Method withParameterNames(@Nullable List<String> parameterNames) {
            Object[] parameterNamesArray = (String[])ListUtils.arrayOrNullIfEmpty(parameterNames, (Object[])EMPTY_STRING_ARRAY);
            if (Arrays.equals(parameterNamesArray, this.parameterNames)) {
                return this;
            }
            return new Method(this.managedReference, this.flagsBitMap, this.declaringType, this.name, this.returnType, (String[])parameterNamesArray, this.parameterTypes, this.thrownExceptions, this.annotations, this.defaultValue);
        }

        public List<JavaType> getParameterTypes() {
            return this.parameterTypes == null ? Collections.emptyList() : Arrays.asList(this.parameterTypes);
        }

        public Method withParameterTypes(@Nullable List<JavaType> parameterTypes) {
            Object[] parameterTypesArray = (JavaType[])ListUtils.arrayOrNullIfEmpty(parameterTypes, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            if (Arrays.equals(parameterTypesArray, this.parameterTypes)) {
                return this;
            }
            return new Method(this.managedReference, this.flagsBitMap, this.declaringType, this.name, this.returnType, this.parameterNames, (JavaType[])parameterTypesArray, this.thrownExceptions, this.annotations, this.defaultValue);
        }

        public List<FullyQualified> getThrownExceptions() {
            return this.thrownExceptions == null ? Collections.emptyList() : Arrays.asList(this.thrownExceptions);
        }

        public Method withThrownExceptions(@Nullable List<FullyQualified> thrownExceptions) {
            Object[] thrownExceptionsArray = (FullyQualified[])ListUtils.arrayOrNullIfEmpty(thrownExceptions, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY);
            if (Arrays.equals(thrownExceptionsArray, this.thrownExceptions)) {
                return this;
            }
            return new Method(this.managedReference, this.flagsBitMap, this.declaringType, this.name, this.returnType, this.parameterNames, this.parameterTypes, (FullyQualified[])thrownExceptionsArray, this.annotations, this.defaultValue);
        }

        public List<FullyQualified> getAnnotations() {
            return this.annotations == null ? Collections.emptyList() : Arrays.asList(this.annotations);
        }

        public Method withAnnotations(@Nullable List<FullyQualified> annotations) {
            Object[] annotationsArray = (FullyQualified[])ListUtils.arrayOrNullIfEmpty(annotations, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY);
            if (Arrays.equals(annotationsArray, this.annotations)) {
                return this;
            }
            return new Method(this.managedReference, this.flagsBitMap, this.declaringType, this.name, this.returnType, this.parameterNames, this.parameterTypes, this.thrownExceptions, (FullyQualified[])annotationsArray, this.defaultValue);
        }

        public boolean hasFlags(Flag ... test) {
            return Flag.hasFlags(this.flagsBitMap, test);
        }

        public Set<Flag> getFlags() {
            return Flag.bitMapToFlags(this.flagsBitMap);
        }

        public Method withFlags(Set<Flag> flags) {
            return this.withFlagsBitMap(Flag.flagsToBitMap(flags));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Method method = (Method)o;
            return Objects.equals(this.declaringType, method.declaringType) && this.name.equals(method.name) && Objects.equals(this.returnType, method.returnType) && Arrays.equals(this.parameterTypes, method.parameterTypes);
        }

        public String toString() {
            return new DefaultJavaTypeSignatureBuilder().methodSignature(this);
        }

        @Override
        @Nullable
        public Integer getManagedReference() {
            return this.managedReference;
        }

        public long getFlagsBitMap() {
            return this.flagsBitMap;
        }

        public String getName() {
            return this.name;
        }

        public JavaType getReturnType() {
            return this.returnType;
        }

        @Nullable
        public List<String> getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        @NonNull
        public Method withManagedReference(@Nullable Integer managedReference) {
            return this.managedReference == managedReference ? this : new Method(managedReference, this.flagsBitMap, this.declaringType, this.name, this.returnType, this.parameterNames, this.parameterTypes, this.thrownExceptions, this.annotations, this.defaultValue);
        }

        @NonNull
        private Method withFlagsBitMap(long flagsBitMap) {
            return this.flagsBitMap == flagsBitMap ? this : new Method(this.managedReference, flagsBitMap, this.declaringType, this.name, this.returnType, this.parameterNames, this.parameterTypes, this.thrownExceptions, this.annotations, this.defaultValue);
        }

        @NonNull
        public Method withDeclaringType(FullyQualified declaringType) {
            return this.declaringType == declaringType ? this : new Method(this.managedReference, this.flagsBitMap, declaringType, this.name, this.returnType, this.parameterNames, this.parameterTypes, this.thrownExceptions, this.annotations, this.defaultValue);
        }

        @NonNull
        public Method withName(String name) {
            return this.name == name ? this : new Method(this.managedReference, this.flagsBitMap, this.declaringType, name, this.returnType, this.parameterNames, this.parameterTypes, this.thrownExceptions, this.annotations, this.defaultValue);
        }

        @NonNull
        public Method withReturnType(JavaType returnType) {
            return this.returnType == returnType ? this : new Method(this.managedReference, this.flagsBitMap, this.declaringType, this.name, returnType, this.parameterNames, this.parameterTypes, this.thrownExceptions, this.annotations, this.defaultValue);
        }
    }

    public static final class Unknown
    extends FullyQualified {
        private static final Unknown INSTANCE = new Unknown();

        private Unknown() {
        }

        @JsonCreator
        public static Unknown getInstance() {
            return INSTANCE;
        }

        @Override
        public String getFullyQualifiedName() {
            return "<unknown>";
        }

        @Override
        public FullyQualified withFullyQualifiedName(String fullyQualifiedName) {
            return this;
        }

        @Override
        public List<FullyQualified> getAnnotations() {
            return Collections.emptyList();
        }

        @Override
        public boolean hasFlags(Flag ... test) {
            return false;
        }

        @Override
        public Set<Flag> getFlags() {
            return Collections.emptySet();
        }

        @Override
        public List<FullyQualified> getInterfaces() {
            return Collections.emptyList();
        }

        @Override
        public FullyQualified.Kind getKind() {
            return FullyQualified.Kind.Class;
        }

        @Override
        public List<Variable> getMembers() {
            return Collections.emptyList();
        }

        @Override
        public List<Method> getMethods() {
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public FullyQualified getOwningClass() {
            return null;
        }

        @Override
        @Nullable
        public FullyQualified getSupertype() {
            return null;
        }

        @Override
        public List<JavaType> getTypeParameters() {
            return Collections.emptyList();
        }

        public String toString() {
            return "Unknown";
        }

        @Override
        public boolean isAssignableFrom(Pattern pattern) {
            return false;
        }

        @Override
        public boolean isAssignableFrom(@Nullable JavaType type) {
            return false;
        }

        @Override
        public boolean isAssignableTo(String fullyQualifiedName) {
            return false;
        }
    }

    public static class Array
    implements JavaType {
        @Nullable
        private Integer managedReference;
        private JavaType elemType;

        public Array(@Nullable Integer managedReference, @Nullable JavaType elemType) {
            this.managedReference = managedReference;
            this.elemType = TypeUtils.unknownIfNull(elemType);
        }

        public JavaType getElemType() {
            return this.elemType;
        }

        @Override
        public Array unsafeSetManagedReference(Integer id) {
            this.managedReference = id;
            return this;
        }

        public Array unsafeSet(JavaType elemType) {
            this.elemType = TypeUtils.unknownIfNull(elemType);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Array array = (Array)o;
            return Objects.equals(this.elemType, array.elemType);
        }

        public String toString() {
            return new DefaultJavaTypeSignatureBuilder().signature(this);
        }

        @Override
        @NonNull
        public Array withManagedReference(@Nullable Integer managedReference) {
            return this.managedReference == managedReference ? this : new Array(managedReference, this.elemType);
        }

        @NonNull
        public Array withElemType(JavaType elemType) {
            return this.elemType == elemType ? this : new Array(this.managedReference, elemType);
        }

        @Override
        @Nullable
        public Integer getManagedReference() {
            return this.managedReference;
        }
    }

    public static class Parameterized
    extends FullyQualified {
        @Nullable
        private Integer managedReference;
        private FullyQualified type;
        @Nullable
        private JavaType[] typeParameters;

        public Parameterized(@Nullable Integer managedReference, @Nullable FullyQualified type, @Nullable List<JavaType> typeParameters) {
            this(managedReference, type, (JavaType[])ListUtils.arrayOrNullIfEmpty(typeParameters, (Object[])EMPTY_JAVA_TYPE_ARRAY));
        }

        @JsonCreator
        Parameterized(@Nullable Integer managedReference, @Nullable FullyQualified type, @Nullable JavaType[] typeParameters) {
            this.managedReference = managedReference;
            this.type = TypeUtils.unknownIfNull(type);
            this.typeParameters = (JavaType[])ListUtils.nullIfEmpty((Object[])typeParameters);
        }

        public FullyQualified getType() {
            return this.type;
        }

        @Override
        public List<JavaType> getTypeParameters() {
            return this.typeParameters == null ? Collections.emptyList() : Arrays.asList(this.typeParameters);
        }

        public Parameterized withTypeParameters(@Nullable List<JavaType> typeParameters) {
            Object[] typeParametersArray = (JavaType[])ListUtils.arrayOrNullIfEmpty(typeParameters, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            if (Arrays.equals(typeParametersArray, this.typeParameters)) {
                return this;
            }
            return new Parameterized(this.managedReference, this.type, (JavaType[])typeParametersArray);
        }

        @Override
        public Parameterized unsafeSetManagedReference(Integer id) {
            this.managedReference = id;
            return this;
        }

        public Parameterized unsafeSet(@Nullable FullyQualified type, @Nullable List<JavaType> typeParameters) {
            assert (type != this);
            this.type = TypeUtils.unknownIfNull(type);
            this.typeParameters = (JavaType[])ListUtils.arrayOrNullIfEmpty(typeParameters, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            return this;
        }

        public Parameterized unsafeSet(@Nullable FullyQualified type, @Nullable JavaType[] typeParameters) {
            assert (type != this);
            this.type = TypeUtils.unknownIfNull(type);
            this.typeParameters = (JavaType[])ListUtils.nullIfEmpty((Object[])typeParameters);
            return this;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.type.getFullyQualifiedName();
        }

        @Override
        public FullyQualified withFullyQualifiedName(String fullyQualifiedName) {
            return this.type.withFullyQualifiedName(fullyQualifiedName);
        }

        @Override
        public List<FullyQualified> getAnnotations() {
            return this.type.getAnnotations();
        }

        @Override
        public boolean hasFlags(Flag ... test) {
            return this.type.hasFlags(test);
        }

        @Override
        public Set<Flag> getFlags() {
            return this.type.getFlags();
        }

        @Override
        public List<FullyQualified> getInterfaces() {
            return this.type.getInterfaces();
        }

        @Override
        public FullyQualified.Kind getKind() {
            return this.type.getKind();
        }

        @Override
        public List<Variable> getMembers() {
            return this.type.getMembers();
        }

        @Override
        public List<Method> getMethods() {
            return this.type.getMethods();
        }

        @Override
        @Nullable
        public FullyQualified getOwningClass() {
            return this.type.getOwningClass();
        }

        @Override
        public FullyQualified getSupertype() {
            return this.type.getSupertype();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameterized that = (Parameterized)o;
            return Objects.equals(this.type, that.type) && Arrays.equals(this.typeParameters, that.typeParameters);
        }

        public String toString() {
            return new DefaultJavaTypeSignatureBuilder().signature(this);
        }

        @Override
        @Nullable
        public Integer getManagedReference() {
            return this.managedReference;
        }

        @Override
        @NonNull
        public Parameterized withManagedReference(@Nullable Integer managedReference) {
            return this.managedReference == managedReference ? this : new Parameterized(managedReference, this.type, this.typeParameters);
        }

        @NonNull
        public Parameterized withType(FullyQualified type) {
            return this.type == type ? this : new Parameterized(this.managedReference, type, this.typeParameters);
        }
    }

    public static class Class
    extends FullyQualified {
        @Nullable
        private Integer managedReference;
        private final long flagsBitMap;
        private final String fullyQualifiedName;
        private final FullyQualified.Kind kind;
        @Nullable
        private JavaType[] typeParameters;
        @Nullable
        private FullyQualified supertype;
        @Nullable
        private FullyQualified owningClass;
        @Nullable
        private FullyQualified[] annotations;
        @Nullable
        private FullyQualified[] interfaces;
        @Nullable
        private Variable[] members;
        @Nullable
        private Method[] methods;

        public Class(@Nullable Integer managedReference, long flagsBitMap, String fullyQualifiedName, FullyQualified.Kind kind, @Nullable List<JavaType> typeParameters, @Nullable FullyQualified supertype, @Nullable FullyQualified owningClass, @Nullable List<FullyQualified> annotations, @Nullable List<FullyQualified> interfaces, @Nullable List<Variable> members, @Nullable List<Method> methods) {
            this(managedReference, flagsBitMap, fullyQualifiedName, kind, (JavaType[])ListUtils.arrayOrNullIfEmpty(typeParameters, (Object[])EMPTY_JAVA_TYPE_ARRAY), supertype, owningClass, (FullyQualified[])ListUtils.arrayOrNullIfEmpty(annotations, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY), (FullyQualified[])ListUtils.arrayOrNullIfEmpty(interfaces, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY), (Variable[])ListUtils.arrayOrNullIfEmpty(members, (Object[])EMPTY_VARIABLE_ARRAY), (Method[])ListUtils.arrayOrNullIfEmpty(methods, (Object[])EMPTY_METHOD_ARRAY));
        }

        @JsonCreator
        Class(@Nullable Integer managedReference, long flagsBitMap, String fullyQualifiedName, FullyQualified.Kind kind, @Nullable JavaType[] typeParameters, @Nullable FullyQualified supertype, @Nullable FullyQualified owningClass, @Nullable FullyQualified[] annotations, @Nullable FullyQualified[] interfaces, @Nullable Variable[] members, @Nullable Method[] methods) {
            this.managedReference = managedReference;
            this.flagsBitMap = flagsBitMap & Flag.VALID_CLASS_FLAGS;
            this.fullyQualifiedName = fullyQualifiedName;
            this.kind = kind;
            this.typeParameters = (JavaType[])ListUtils.nullIfEmpty((Object[])typeParameters);
            this.supertype = supertype;
            this.owningClass = owningClass;
            this.annotations = (FullyQualified[])ListUtils.nullIfEmpty((Object[])annotations);
            this.interfaces = (FullyQualified[])ListUtils.nullIfEmpty((Object[])interfaces);
            this.members = (Variable[])ListUtils.nullIfEmpty((Object[])members);
            this.methods = (Method[])ListUtils.nullIfEmpty((Object[])methods);
        }

        @Override
        public List<FullyQualified> getAnnotations() {
            return this.annotations == null ? Collections.emptyList() : Arrays.asList(this.annotations);
        }

        public Class withAnnotations(@Nullable List<FullyQualified> annotations) {
            Object[] annotationsArray = (FullyQualified[])ListUtils.arrayOrNullIfEmpty(annotations, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY);
            if (Arrays.equals(annotationsArray, this.annotations)) {
                return this;
            }
            return new Class(this.managedReference, this.flagsBitMap, this.fullyQualifiedName, this.kind, this.typeParameters, this.supertype, this.owningClass, (FullyQualified[])annotationsArray, this.interfaces, this.members, this.methods);
        }

        @Override
        public List<FullyQualified> getInterfaces() {
            return this.interfaces == null ? Collections.emptyList() : Arrays.asList(this.interfaces);
        }

        public Class withInterfaces(@Nullable List<FullyQualified> interfaces) {
            Object[] interfacesArray = (FullyQualified[])ListUtils.arrayOrNullIfEmpty(interfaces, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY);
            if (Arrays.equals(interfacesArray, this.interfaces)) {
                return this;
            }
            return new Class(this.managedReference, this.flagsBitMap, this.fullyQualifiedName, this.kind, this.typeParameters, this.supertype, this.owningClass, this.annotations, (FullyQualified[])interfacesArray, this.members, this.methods);
        }

        @Override
        public List<Variable> getMembers() {
            return this.members == null ? Collections.emptyList() : Arrays.asList(this.members);
        }

        public Class withMembers(@Nullable List<Variable> members) {
            Object[] membersArray = (Variable[])ListUtils.arrayOrNullIfEmpty(members, (Object[])EMPTY_VARIABLE_ARRAY);
            if (Arrays.equals(membersArray, this.members)) {
                return this;
            }
            return new Class(this.managedReference, this.flagsBitMap, this.fullyQualifiedName, this.kind, this.typeParameters, this.supertype, this.owningClass, this.annotations, this.interfaces, (Variable[])membersArray, this.methods);
        }

        @Override
        public List<Method> getMethods() {
            return this.methods == null ? Collections.emptyList() : Arrays.asList(this.methods);
        }

        public Class withMethods(@Nullable List<Method> methods) {
            Object[] methodsArray = (Method[])ListUtils.arrayOrNullIfEmpty(methods, (Object[])EMPTY_METHOD_ARRAY);
            if (Arrays.equals(methodsArray, this.methods)) {
                return this;
            }
            return new Class(this.managedReference, this.flagsBitMap, this.fullyQualifiedName, this.kind, this.typeParameters, this.supertype, this.owningClass, this.annotations, this.interfaces, this.members, (Method[])methodsArray);
        }

        @Override
        public boolean hasFlags(Flag ... test) {
            return Flag.hasFlags(this.flagsBitMap, test);
        }

        @Override
        public Set<Flag> getFlags() {
            return Flag.bitMapToFlags(this.flagsBitMap);
        }

        public JavaType withFlags(Set<Flag> flags) {
            long flagsBitMap = Flag.flagsToBitMap(flags);
            if (flagsBitMap == this.flagsBitMap) {
                return this;
            }
            return new Class(this.managedReference, flagsBitMap, this.fullyQualifiedName, this.kind, this.typeParameters, this.supertype, this.owningClass, this.annotations, this.interfaces, this.members, this.methods);
        }

        @Override
        public List<JavaType> getTypeParameters() {
            return this.typeParameters == null ? Collections.emptyList() : Arrays.asList(this.typeParameters);
        }

        public Class withTypeParameters(@Nullable List<JavaType> typeParameters) {
            Object[] typeParametersArray = (JavaType[])ListUtils.arrayOrNullIfEmpty(typeParameters, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            if (Arrays.equals(typeParametersArray, this.typeParameters)) {
                return this;
            }
            return new Class(this.managedReference, this.flagsBitMap, this.fullyQualifiedName, this.kind, (JavaType[])typeParametersArray, this.supertype, this.owningClass, this.annotations, this.interfaces, this.members, this.methods);
        }

        public boolean isParameterized() {
            return this.typeParameters != null && this.typeParameters.length > 0;
        }

        @Override
        public Class unsafeSetManagedReference(Integer id) {
            this.managedReference = id;
            return this;
        }

        public Class unsafeSet(@Nullable List<JavaType> typeParameters, @Nullable FullyQualified supertype, @Nullable FullyQualified owningClass, @Nullable List<FullyQualified> annotations, @Nullable List<FullyQualified> interfaces, @Nullable List<Variable> members, @Nullable List<Method> methods) {
            this.typeParameters = (JavaType[])ListUtils.arrayOrNullIfEmpty(typeParameters, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            this.supertype = supertype;
            this.owningClass = owningClass;
            this.annotations = (FullyQualified[])ListUtils.arrayOrNullIfEmpty(annotations, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY);
            this.interfaces = (FullyQualified[])ListUtils.arrayOrNullIfEmpty(interfaces, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY);
            this.members = (Variable[])ListUtils.arrayOrNullIfEmpty(members, (Object[])EMPTY_VARIABLE_ARRAY);
            this.methods = (Method[])ListUtils.arrayOrNullIfEmpty(methods, (Object[])EMPTY_METHOD_ARRAY);
            return this;
        }

        public Class unsafeSet(@Nullable JavaType[] typeParameters, @Nullable FullyQualified supertype, @Nullable FullyQualified owningClass, @Nullable FullyQualified[] annotations, @Nullable FullyQualified[] interfaces, @Nullable Variable[] members, @Nullable Method[] methods) {
            this.typeParameters = (JavaType[])ListUtils.nullIfEmpty((Object[])typeParameters);
            this.supertype = supertype;
            this.owningClass = owningClass;
            this.annotations = (FullyQualified[])ListUtils.nullIfEmpty((Object[])annotations);
            this.interfaces = (FullyQualified[])ListUtils.nullIfEmpty((Object[])interfaces);
            this.members = (Variable[])ListUtils.nullIfEmpty((Object[])members);
            this.methods = (Method[])ListUtils.nullIfEmpty((Object[])methods);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Class aClass = (Class)o;
            return TypeUtils.fullyQualifiedNamesAreEqual(this.fullyQualifiedName, aClass.fullyQualifiedName) && (this.typeParameters == null && aClass.typeParameters == null || this.typeParameters != null && Arrays.equals(this.typeParameters, aClass.typeParameters));
        }

        public String toString() {
            return new DefaultJavaTypeSignatureBuilder().signature(this);
        }

        @Override
        @Nullable
        public Integer getManagedReference() {
            return this.managedReference;
        }

        public long getFlagsBitMap() {
            return this.flagsBitMap;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        @Override
        public FullyQualified.Kind getKind() {
            return this.kind;
        }

        @Override
        @Nullable
        public FullyQualified getSupertype() {
            return this.supertype;
        }

        @Override
        @Nullable
        public FullyQualified getOwningClass() {
            return this.owningClass;
        }

        @Override
        @NonNull
        public Class withManagedReference(@Nullable Integer managedReference) {
            return this.managedReference == managedReference ? this : new Class(managedReference, this.flagsBitMap, this.fullyQualifiedName, this.kind, this.typeParameters, this.supertype, this.owningClass, this.annotations, this.interfaces, this.members, this.methods);
        }

        @Override
        @NonNull
        public Class withFullyQualifiedName(String fullyQualifiedName) {
            return this.fullyQualifiedName == fullyQualifiedName ? this : new Class(this.managedReference, this.flagsBitMap, fullyQualifiedName, this.kind, this.typeParameters, this.supertype, this.owningClass, this.annotations, this.interfaces, this.members, this.methods);
        }

        @NonNull
        public Class withKind(FullyQualified.Kind kind) {
            return this.kind == kind ? this : new Class(this.managedReference, this.flagsBitMap, this.fullyQualifiedName, kind, this.typeParameters, this.supertype, this.owningClass, this.annotations, this.interfaces, this.members, this.methods);
        }

        @NonNull
        public Class withSupertype(@Nullable FullyQualified supertype) {
            return this.supertype == supertype ? this : new Class(this.managedReference, this.flagsBitMap, this.fullyQualifiedName, this.kind, this.typeParameters, supertype, this.owningClass, this.annotations, this.interfaces, this.members, this.methods);
        }

        @NonNull
        public Class withOwningClass(@Nullable FullyQualified owningClass) {
            return this.owningClass == owningClass ? this : new Class(this.managedReference, this.flagsBitMap, this.fullyQualifiedName, this.kind, this.typeParameters, this.supertype, owningClass, this.annotations, this.interfaces, this.members, this.methods);
        }
    }

    public static class MultiCatch
    implements JavaType {
        private JavaType[] throwableTypes;

        public MultiCatch(@Nullable List<JavaType> throwableTypes) {
            this.throwableTypes = (JavaType[])ListUtils.arrayOrNullIfEmpty(throwableTypes, (Object[])EMPTY_JAVA_TYPE_ARRAY);
        }

        @JsonCreator
        MultiCatch(@Nullable JavaType[] throwableTypes) {
            this.throwableTypes = (JavaType[])ListUtils.nullIfEmpty((Object[])throwableTypes);
        }

        public List<JavaType> getThrowableTypes() {
            if (this.throwableTypes == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(this.throwableTypes);
        }

        public MultiCatch withThrowableTypes(@Nullable List<JavaType> throwableTypes) {
            Object[] throwableTypesArray = (JavaType[])ListUtils.arrayOrNullIfEmpty(throwableTypes, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            if (Arrays.equals(throwableTypesArray, this.throwableTypes)) {
                return this;
            }
            return new MultiCatch((JavaType[])throwableTypesArray);
        }

        public MultiCatch unsafeSet(List<JavaType> throwableTypes) {
            this.throwableTypes = (JavaType[])ListUtils.arrayOrNullIfEmpty(throwableTypes, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            return this;
        }

        public MultiCatch unsafeSet(JavaType[] throwableTypes) {
            this.throwableTypes = (JavaType[])ListUtils.nullIfEmpty((Object[])throwableTypes);
            return this;
        }
    }
}

