/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class QualifyThisVisitor
extends JavaVisitor<ExecutionContext> {
    @Override
    public J visitIdentifier(J.Identifier ident, ExecutionContext executionContext) {
        if (ident.getSimpleName().equals("this") && !this.isAlreadyQualified(ident) && ident.getType() instanceof JavaType.Class) {
            JavaType.Class type = (JavaType.Class)ident.getType();
            return new J.FieldAccess(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, type.getClassName(), type, null), JLeftPadded.build(ident), type);
        }
        return ident;
    }

    private boolean isAlreadyQualified(J.Identifier ident) {
        Cursor parentCursor = this.getCursor().getParentTreeCursor();
        if (!(parentCursor.getValue() instanceof J.FieldAccess)) {
            return false;
        }
        J.FieldAccess parent = (J.FieldAccess)parentCursor.getValue();
        return parent.getName() == ident;
    }
}

