/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.marker;

import java.util.UUID;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;

public final class JavaProject
implements Marker {
    private final UUID id;
    private final String projectName;
    @Nullable
    private final Publication publication;

    public JavaProject(UUID id, String projectName, @Nullable Publication publication) {
        this.id = id;
        this.projectName = projectName;
        this.publication = publication;
    }

    public UUID getId() {
        return this.id;
    }

    public String getProjectName() {
        return this.projectName;
    }

    @Nullable
    public Publication getPublication() {
        return this.publication;
    }

    @NonNull
    public String toString() {
        return "JavaProject(id=" + this.getId() + ", projectName=" + this.getProjectName() + ", publication=" + this.getPublication() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaProject)) {
            return false;
        }
        JavaProject other = (JavaProject)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @NonNull
    public JavaProject withId(UUID id) {
        return this.id == id ? this : new JavaProject(id, this.projectName, this.publication);
    }

    @NonNull
    public JavaProject withProjectName(String projectName) {
        return this.projectName == projectName ? this : new JavaProject(this.id, projectName, this.publication);
    }

    @NonNull
    public JavaProject withPublication(@Nullable Publication publication) {
        return this.publication == publication ? this : new JavaProject(this.id, this.projectName, publication);
    }

    public static class Publication {
        private final String groupId;
        private final String artifactId;
        private final String version;

        public Publication(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Publication)) {
                return false;
            }
            Publication other = (Publication)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Publication;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "JavaProject.Publication(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ")";
        }
    }
}

