/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class CompareEnumsWithEqualityOperator
extends Recipe {
    public String getDisplayName() {
        return "Enum values should be compared with \"==\"";
    }

    public String getDescription() {
        return "Replaces `Enum equals(java.lang.Object)` with `Enum == java.lang.Object`. An `!Enum equals(java.lang.Object)` will change to `!=`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-4551");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod<ExecutionContext>("java.lang.Enum equals(java.lang.Object)");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher ENUM_EQUALS = new MethodMatcher("java.lang.Enum equals(java.lang.Object)");
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, executionContext);
                if (ENUM_EQUALS.matches(m)) {
                    boolean isNot;
                    Cursor parent = this.getCursor().dropParentUntil(is -> is instanceof J.Unary || is instanceof J.Block);
                    boolean bl = isNot = parent.getValue() instanceof J.Unary && ((J.Unary)parent.getValue()).getOperator() == J.Unary.Type.Not;
                    if (isNot) {
                        executionContext.putMessage("REMOVE_UNARY_NOT", parent.getValue());
                    }
                    String code = "#{any()} " + (isNot ? "!=" : "==") + " #{any()}";
                    return this.autoFormat(m.withTemplate(JavaTemplate.builder(() -> (this).getCursor(), code).build(), m.getCoordinates().replace(), m.getSelect(), m.getArguments().get(0)), executionContext);
                }
                return m;
            }

            @Override
            public J visitUnary(J.Unary unary, ExecutionContext executionContext) {
                J j = super.visitUnary(unary, executionContext);
                J.Unary asUnary = (J.Unary)j;
                if (executionContext.getMessage("REMOVE_UNARY_NOT") instanceof J.Unary && asUnary.equals(executionContext.getMessage("REMOVE_UNARY_NOT"))) {
                    return asUnary.getExpression().unwrap().withPrefix(asUnary.getPrefix());
                }
                return j;
            }
        };
    }
}

