/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

@Incubating(since="7.0.0")
public class FinalizeLocalVariablesVisitor<P>
extends JavaIsoVisitor<P> {
    @Override
    public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
        J.VariableDeclarations mv = (J.VariableDeclarations)this.visitAndCast(multiVariable, p, (x$0, x$1) -> super.visitVariableDeclarations((J.VariableDeclarations)x$0, x$1));
        if (mv.hasModifier(J.Modifier.Type.Final)) {
            return mv;
        }
        if (mv.getVariables().stream().anyMatch(nv -> nv.getInitializer() == null)) {
            return mv;
        }
        if (this.isDeclaredInForLoopControl()) {
            return mv;
        }
        if (mv.getVariables().stream().anyMatch(v -> v.isField(this.getCursor()) || this.isField(this.getCursor()))) {
            return mv;
        }
        if (mv.getVariables().stream().noneMatch(v -> FindAssignmentReferencesToVariable.find((J)this.getCursor().dropParentUntil(J.class::isInstance).getValue(), v).get())) {
            mv = this.maybeAutoFormat(mv, mv.withModifiers(ListUtils.concat(mv.getModifiers(), (Object)new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Final, Collections.emptyList()))), p, this.getCursor().dropParentUntil(J.class::isInstance));
        }
        return mv;
    }

    private boolean isDeclaredInForLoopControl() {
        return this.getCursor().dropParentUntil(J.class::isInstance).getValue() instanceof J.ForLoop.Control;
    }

    private boolean isField(Cursor cursor) {
        return cursor.getParentOrThrow().getParentOrThrow().getParentOrThrow().getValue() instanceof J.ClassDeclaration;
    }

    private static class FindAssignmentReferencesToVariable {
        private FindAssignmentReferencesToVariable() {
        }

        private static AtomicBoolean find(J j, final J.VariableDeclarations.NamedVariable variable) {
            JavaIsoVisitor<AtomicBoolean> findVisitor = new JavaIsoVisitor<AtomicBoolean>(){

                @Override
                public J.Assignment visitAssignment(J.Assignment assignment, AtomicBoolean hasAssignment) {
                    J.Identifier i;
                    if (hasAssignment.get()) {
                        return assignment;
                    }
                    J a = super.visitAssignment(assignment, hasAssignment);
                    if (((J.Assignment)a).getVariable() instanceof J.Identifier && (i = (J.Identifier)((J.Assignment)a).getVariable()).getSimpleName().equals(variable.getSimpleName())) {
                        hasAssignment.set(true);
                    }
                    return a;
                }

                @Override
                public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignOp, AtomicBoolean hasAssignment) {
                    J.Identifier i;
                    if (hasAssignment.get()) {
                        return assignOp;
                    }
                    J a = super.visitAssignmentOperation(assignOp, hasAssignment);
                    if (((J.AssignmentOperation)a).getVariable() instanceof J.Identifier && (i = (J.Identifier)((J.AssignmentOperation)a).getVariable()).getSimpleName().equals(variable.getSimpleName())) {
                        hasAssignment.set(true);
                    }
                    return a;
                }

                @Override
                public J.Unary visitUnary(J.Unary unary, AtomicBoolean hasAssignment) {
                    J.Identifier i;
                    if (hasAssignment.get()) {
                        return unary;
                    }
                    J u = super.visitUnary(unary, hasAssignment);
                    if (((J.Unary)u).getExpression() instanceof J.Identifier && (i = (J.Identifier)((J.Unary)u).getExpression()).getSimpleName().equals(variable.getSimpleName())) {
                        hasAssignment.set(true);
                    }
                    return u;
                }
            };
            AtomicBoolean hasAssignment = new AtomicBoolean(false);
            findVisitor.visit(j, hasAssignment);
            return hasAssignment;
        }
    }
}

